/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.Model;
import org.xml.sax.Attributes;

public abstract class BaseModelAction
extends Action {
    Model parentModel;
    Model currentModel;
    boolean inError = false;

    /*
     * WARNING - void declaration
     */
    @Override
    public void begin(SaxEventInterpretationContext saxEventInterpretationContext, String name, Attributes attributes) throws ActionException {
        void var1_1;
        void var2_3;
        void var3_4;
        this.parentModel = null;
        this.inError = false;
        if (!this.validPreconditions(saxEventInterpretationContext, name, attributes)) {
            this.inError = true;
            return;
        }
        this.currentModel = this.buildCurrentModel(saxEventInterpretationContext, name, (Attributes)var3_4);
        this.currentModel.setTag(name);
        if (!saxEventInterpretationContext.isModelStackEmpty()) {
            this.parentModel = saxEventInterpretationContext.peekModel();
        }
        int lineNumber = BaseModelAction.getLineNumber(saxEventInterpretationContext);
        this.currentModel.setLineNumber((int)var2_3);
        var1_1.pushModel(this.currentModel);
    }

    protected abstract Model buildCurrentModel(SaxEventInterpretationContext var1, String var2, Attributes var3);

    protected boolean validPreconditions(SaxEventInterpretationContext intercon, String name, Attributes attributes) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void body(SaxEventInterpretationContext ec, String body) throws ActionException {
        void var2_2;
        if (this.currentModel == null) {
            throw new ActionException("current model is null. Is <configuration> element missing?");
        }
        this.currentModel.addText((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void end(SaxEventInterpretationContext saxEventInterpretationContext, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Model m = saxEventInterpretationContext.peekModel();
        if (m != this.currentModel) {
            void var2_2;
            this.addWarn("The object " + var2_2 + "] at the top of the stack differs from the model [" + this.currentModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            void var1_1;
            this.parentModel.addSubModel(this.currentModel);
            var1_1.popModel();
        }
    }
}

