/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

public class JsonEscapeUtil {
    protected static final char[] HEXADECIMALS_TABLE = "0123456789ABCDEF".toCharArray();
    static final int ESCAPE_CODES_COUNT = 32;
    static final String[] ESCAPE_CODES = new String[32];

    /*
     * WARNING - void declaration
     */
    private static String _computeEscapeCodeBelowASCII32(char c) {
        void var1_1;
        char c2;
        void var2_2;
        if (c > ' ') {
            throw new IllegalArgumentException("input must be less than 32");
        }
        StringBuilder sb = new StringBuilder(6);
        sb.append("\\u00");
        int highPart = c >> 4;
        sb.append(HEXADECIMALS_TABLE[var2_2]);
        char lowPart = (char)(c & 0xF);
        sb.append(HEXADECIMALS_TABLE[c2]);
        return var1_1.toString();
    }

    static String getObligatoryEscapeCode(char c) {
        char c2;
        if (c < ' ') {
            return ESCAPE_CODES[c];
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c2 == '\\') {
            return "\\/";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String jsonEscapeString(String input) {
        void var2_3;
        int length = input.length();
        int lenthWithLeeway = (int)((double)length * 1.1);
        StringBuilder sb = new StringBuilder(lenthWithLeeway);
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            String escaped = JsonEscapeUtil.getObligatoryEscapeCode(c);
            if (escaped == null) {
                sb.append(c);
                continue;
            }
            sb.append(escaped);
        }
        return var2_3.toString();
    }

    static {
        block7: for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            switch (c) {
                case '\b': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\b";
                    continue block7;
                }
                case '\t': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\t";
                    continue block7;
                }
                case '\n': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\n";
                    continue block7;
                }
                case '\f': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\f";
                    continue block7;
                }
                case '\r': {
                    JsonEscapeUtil.ESCAPE_CODES[c] = "\\r";
                    continue block7;
                }
                default: {
                    char c2 = c;
                    JsonEscapeUtil.ESCAPE_CODES[c2] = JsonEscapeUtil._computeEscapeCodeBelowASCII32(c2);
                }
            }
        }
    }
}

