/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.util.ContextUtil;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Map;

public class FileAppender<E>
extends OutputStreamAppender<E> {
    public static final long DEFAULT_BUFFER_SIZE = 8192L;
    protected static String COLLISION_WITH_EARLIER_APPENDER_URL = "http://logback.qos.ch/codes.html#earlier_fa_collision";
    protected boolean append = true;
    protected String fileName = null;
    private boolean prudent = false;
    private FileSize bufferSize = new FileSize(8192L);

    /*
     * WARNING - void declaration
     */
    public void setFile(String file) {
        void var1_1;
        if (file == null) {
            this.fileName = file;
            return;
        }
        this.fileName = var1_1.trim();
    }

    public boolean isAppend() {
        return this.append;
    }

    public final String rawFileProperty() {
        return this.fileName;
    }

    public String getFile() {
        return this.fileName;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var1_1;
        int errors = 0;
        if (this.getFile() != null) {
            this.addInfo("File property is set to [" + this.fileName + "]");
            if (this.prudent && !this.isAppend()) {
                this.setAppend(true);
                this.addWarn("Setting \"Append\" property to true on account of \"Prudent\" mode");
            }
            if (this.checkForFileCollisionInPreviousFileAppenders()) {
                this.addError("Collisions detected with FileAppender/RollingAppender instances defined earlier. Aborting.");
                this.addError("For more information, please visit " + COLLISION_WITH_EARLIER_APPENDER_URL);
                ++errors;
            } else {
                try {
                    FileAppender fileAppender = this;
                    fileAppender.openFile(fileAppender.getFile());
                }
                catch (IOException e) {
                    void var2_2;
                    ++errors;
                    this.addError("openFile(" + this.fileName + "," + this.append + ") call failed.", (Throwable)var2_2);
                }
            }
        } else {
            ++errors;
            this.addError("\"File\" property not set for appender named [" + this.name + "].");
        }
        if (var1_1 == false) {
            super.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void stop() {
        void var1_1;
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        Map<String, String> map = ContextUtil.getFilenameCollisionMap(this.context);
        if (map == null || this.getName() == null) {
            return;
        }
        var1_1.remove(this.getName());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean checkForFileCollisionInPreviousFileAppenders() {
        void var1_1;
        boolean collisionsDetected = false;
        if (this.fileName == null) {
            return false;
        }
        Map previousFilesMap = (Map)this.context.getObject("FA_FILENAMES_MAP");
        if (previousFilesMap == null) {
            return false;
        }
        for (Map.Entry entry : previousFilesMap.entrySet()) {
            if (!this.fileName.equals(entry.getValue())) continue;
            this.addErrorForCollision("File", (String)entry.getValue(), (String)entry.getKey());
            collisionsDetected = true;
        }
        if (this.name != null) {
            void var2_2;
            var2_2.put(this.getName(), this.fileName);
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void addErrorForCollision(String optionName, String optionValue, String appenderName) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.addError("'" + (String)var1_1 + "' option has the same value \"" + (String)var2_2 + "\" as that given for appender [" + (String)var3_3 + "] defined earlier.");
    }

    /*
     * WARNING - void declaration
     */
    public void openFile(String file_name) throws IOException {
        this.streamWriteLock.lock();
        try {
            void var1_1;
            File file = new File(file_name);
            boolean bl = FileUtil.createMissingParentDirectories(file);
            if (!bl) {
                this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
            }
            ResilientFileOutputStream resilientFos = new ResilientFileOutputStream(file, this.append, this.bufferSize.getSize());
            resilientFos.setContext(this.context);
            this.setOutputStream((OutputStream)var1_1);
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    public boolean isPrudent() {
        return this.prudent;
    }

    /*
     * WARNING - void declaration
     */
    public void setPrudent(boolean prudent) {
        void var1_1;
        this.prudent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAppend(boolean append) {
        void var1_1;
        this.append = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setBufferSize(FileSize bufferSize) {
        void var1_1;
        this.addInfo("Setting bufferSize to [" + bufferSize.toString() + "]");
        this.bufferSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void writeOut(E event) throws IOException {
        void var1_1;
        if (this.prudent) {
            this.safeWriteOut(event);
            return;
        }
        super.writeOut(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void safeWriteOut(E event) {
        byte[] byteArray = this.encoder.encode(event);
        if (byteArray == null || byteArray.length == 0) {
            return;
        }
        this.streamWriteLock.lock();
        try {
            void var1_1;
            this.safeWriteBytes((byte[])var1_1);
            return;
        }
        finally {
            this.streamWriteLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void safeWriteBytes(byte[] byteArray) {
        block8: {
            ResilientFileOutputStream resilientFOS = (ResilientFileOutputStream)this.getOutputStream();
            FileChannel fileChannel = resilientFOS.getChannel();
            if (fileChannel == null) {
                return;
            }
            boolean interrupted = Thread.interrupted();
            FileLock fileLock = null;
            try {
                void var1_1;
                fileLock = fileChannel.lock();
                long position = fileChannel.position();
                long size = fileChannel.size();
                if (size != position) {
                    void var3_4;
                    var3_4.position(size);
                }
                this.writeByteArrayToOutputStreamWithPossibleFlush((byte[])var1_1);
                this.releaseFileLock(fileLock);
                if (interrupted) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            catch (IOException e) {
                void var2_3;
                var2_3.postIOFailure(e);
                return;
            }
            finally {
                this.releaseFileLock(fileLock);
                if (!interrupted) break block8;
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void releaseFileLock(FileLock fileLock) {
        if (fileLock != null && fileLock.isValid()) {
            try {
                fileLock.release();
                return;
            }
            catch (IOException e) {
                void var1_2;
                this.addError("failed to release lock", (Throwable)var1_2);
            }
        }
    }
}

