/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.joran.spi.ConsoleTarget;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.Loader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Optional;

public class ConsoleAppender<E>
extends OutputStreamAppender<E> {
    protected ConsoleTarget target = ConsoleTarget.SystemOut;
    protected boolean withJansi = false;
    private static final String AnsiConsole_CLASS_NAME = "org.fusesource.jansi.AnsiConsole";
    private static final String JANSI2_OUT_METHOD_NAME = "out";
    private static final String JANSI2_ERR_METHOD_NAME = "err";
    private static final String wrapSystemOut_METHOD_NAME = "wrapSystemOut";
    private static final String wrapSystemErr_METHOD_NAME = "wrapSystemErr";
    private static final Class<?>[] ARGUMENT_TYPES = new Class[]{PrintStream.class};

    /*
     * WARNING - void declaration
     */
    public void setTarget(String value) {
        void var2_2;
        ConsoleTarget t = ConsoleTarget.findByName(value.trim());
        if (t == null) {
            void var1_1;
            this.targetWarn((String)var1_1);
            return;
        }
        this.target = var2_2;
    }

    public String getTarget() {
        return this.target.getName();
    }

    /*
     * WARNING - void declaration
     */
    private void targetWarn(String val) {
        void var1_1;
        WarnStatus status = new WarnStatus("[" + val + "] should be one of " + Arrays.toString((Object[])ConsoleTarget.values()), this);
        status.add(new WarnStatus("Using previously set target, System.out by default.", this));
        this.addStatus((Status)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void start() {
        void var1_1;
        OutputStream targetStream = this.target.getStream();
        if (this.withJansi) {
            targetStream = this.wrapWithJansi(targetStream);
        }
        this.setOutputStream((OutputStream)var1_1);
        super.start();
    }

    /*
     * WARNING - void declaration
     */
    private OutputStream wrapWithJansi(OutputStream targetStream) {
        try {
            void var3_4;
            this.addInfo("Enabling JANSI AnsiPrintStream for the console.");
            ClassLoader classLoader = Loader.getClassLoaderOfObject(this.context);
            GenericDeclaration classObj = classLoader.loadClass(AnsiConsole_CLASS_NAME);
            String methodNameJansi2 = this.target == ConsoleTarget.SystemOut ? JANSI2_OUT_METHOD_NAME : JANSI2_ERR_METHOD_NAME;
            Object optOutMethod = Arrays.stream(classObj.getMethods()).filter(m -> {
                String string;
                return m.getName().equals(string);
            }).filter(m -> m.getParameters().length == 0).filter(m -> Modifier.isStatic(m.getModifiers())).filter(m -> {
                Method method;
                return PrintStream.class.isAssignableFrom(method.getReturnType());
            }).findAny();
            if (((Optional)optOutMethod).isPresent()) {
                optOutMethod = ((Optional)optOutMethod).orElseThrow(() -> new NoSuchElementException("No value present"));
                return (PrintStream)((Method)optOutMethod).invoke(null, new Object[0]);
            }
            String methodName = this.target == ConsoleTarget.SystemOut ? wrapSystemOut_METHOD_NAME : wrapSystemErr_METHOD_NAME;
            classObj = classObj.getMethod((String)var3_4, ARGUMENT_TYPES);
            return (OutputStream)((Method)classObj).invoke(null, new PrintStream(targetStream));
        }
        catch (Exception e) {
            void var1_1;
            void var2_3;
            this.addWarn("Failed to create AnsiPrintStream. Falling back on the default stream.", (Throwable)var2_3);
            return var1_1;
        }
    }

    public boolean isWithJansi() {
        return this.withJansi;
    }

    /*
     * WARNING - void declaration
     */
    public void setWithJansi(boolean withJansi) {
        void var1_1;
        this.withJansi = var1_1;
    }
}

