/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.html.stream;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.html.Entities;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.Unsafe;
import kotlinx.html.org.w3c.dom.events.Event;
import kotlinx.html.stream.StreamKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0001*\u00060\u0002j\u0002`\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\r\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\"\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0016J!\u0010(\u001a\u00020\u00182\u0017\u0010)\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180*\u00a2\u0006\u0002\b+H\u0016J\u0010\u0010,\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J,\u0010-\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u00180*H\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u00061"}, d2={"Lkotlinx/html/stream/HTMLStreamBuilder;", "O", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "Lkotlinx/html/TagConsumer;", "out", "prettyPrint", "", "xhtmlCompatible", "(Ljava/lang/Appendable;ZZ)V", "UnsafeImpl", "Lkotlinx/html/Unsafe;", "getUnsafeImpl", "()Lkotlinx/html/Unsafe;", "level", "", "ln", "getOut", "()Ljava/lang/Appendable;", "Ljava/lang/Appendable;", "getPrettyPrint", "()Z", "getXhtmlCompatible", "appendln", "", "finalize", "indent", "onTagAttributeChange", "tag", "Lkotlinx/html/Tag;", "attribute", "", "value", "onTagComment", "content", "", "onTagContent", "onTagContentEntity", "entity", "Lkotlinx/html/Entities;", "onTagContentUnsafe", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "onTagEnd", "onTagEvent", "event", "Lkotlinx/html/org/w3c/dom/events/Event;", "onTagStart", "kotlinx-html"})
@SourceDebugExtension(value={"SMAP\nstream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 stream.kt\nkotlinx/html/stream/HTMLStreamBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1864#2,3:241\n*S KotlinDebug\n*F\n+ 1 stream.kt\nkotlinx/html/stream/HTMLStreamBuilder\n*L\n31#1:241,3\n*E\n"})
public final class HTMLStreamBuilder<O extends Appendable>
implements TagConsumer<O> {
    private final O out;
    private final boolean prettyPrint;
    private final boolean xhtmlCompatible;
    private int level;
    private boolean ln;
    private final Unsafe UnsafeImpl;

    /*
     * WARNING - void declaration
     */
    public HTMLStreamBuilder(O out, boolean prettyPrint, boolean xhtmlCompatible) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(out, (String)"out");
        this.out = var1_1;
        this.prettyPrint = var2_2;
        this.xhtmlCompatible = var3_3;
        this.ln = true;
        this.UnsafeImpl = new Unsafe(this){
            final /* synthetic */ HTMLStreamBuilder<O> this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final void unaryPlus(String $this$unaryPlus) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
                this.this$0.getOut().append((CharSequence)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void unaryPlus(Entities $this$unaryPlus) {
                void var1_1;
                Unsafe.DefaultImpls.unaryPlus(this, (Entities)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void raw(String s2) {
                void var1_1;
                Unsafe.DefaultImpls.raw((Unsafe)this, (String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void raw(Entities entity) {
                void var1_1;
                Unsafe.DefaultImpls.raw((Unsafe)this, (Entities)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            public final void raw(Number n) {
                void var1_1;
                Unsafe.DefaultImpls.raw((Unsafe)this, (Number)var1_1);
            }
        };
    }

    public final O getOut() {
        return this.out;
    }

    public final boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public final boolean getXhtmlCompatible() {
        return this.xhtmlCompatible;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagStart(Tag tag) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (this.prettyPrint && !tag.getInlineTag()) {
            this.indent();
        }
        int n = this.level;
        this.level = n + 1;
        this.out.append("<");
        this.out.append(tag.getTagName());
        if (tag.getNamespace() != null) {
            this.out.append(" xmlns=\"");
            this.out.append(tag.getNamespace());
            this.out.append("\"");
        }
        if (!tag.getAttributes().isEmpty()) {
            Iterator iterator;
            Iterable $this$forEachIndexed$iv = tag.getAttributesEntries();
            int index$iv = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Map.Entry e;
                int n2;
                Object item$iv = iterator.next();
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                if (!StreamKt.access$isValidXmlAttributeName((String)(e = (Map.Entry)item$iv).getKey())) {
                    throw new IllegalArgumentException("Tag " + tag.getTagName() + " has invalid attribute name " + (String)e.getKey());
                }
                this.out.append(' ');
                this.out.append((CharSequence)e.getKey());
                this.out.append("=\"");
                StreamKt.escapeAppend(this.out, (CharSequence)e.getValue());
                this.out.append('\"');
            }
        }
        if (this.xhtmlCompatible && var1_1.getEmptyTag()) {
            this.out.append("/");
        }
        this.out.append(">");
        this.ln = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagAttributeChange(Tag tag, String attribute, String value) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"attribute");
        throw new UnsupportedOperationException("tag attribute can't be changed as it was already written to the stream. Use with DelayedConsumer to be able to modify attributes");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagEvent(Tag tag, String event, Function1<? super Event, Unit> value) {
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)var3_3, (String)"value");
        throw new UnsupportedOperationException("you can't assign lambda event handler when building text");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagEnd(Tag tag) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        int n = this.level;
        this.level = n + -1;
        if (this.ln) {
            this.indent();
        }
        if (!tag.getEmptyTag()) {
            this.out.append("</");
            this.out.append(tag.getTagName());
            this.out.append(">");
        }
        if (this.prettyPrint && !var1_1.getInlineTag()) {
            this.appendln();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagContent(CharSequence content) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        StreamKt.escapeAppend(this.out, (CharSequence)var1_1);
        this.ln = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagContentEntity(Entities entity) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        this.out.append(var1_1.getText());
        this.ln = false;
    }

    @Override
    public final O finalize() {
        return this.out;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagContentUnsafe(Function1<? super Unsafe, Unit> block) {
        void var1_1;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        var1_1.invoke((Object)this.UnsafeImpl);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onTagComment(CharSequence content) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (this.prettyPrint) {
            this.indent();
        }
        this.out.append("<!--");
        StreamKt.access$escapeComment(this.out, (CharSequence)var1_1);
        this.out.append("-->");
        this.ln = false;
    }

    public final Unsafe getUnsafeImpl() {
        return this.UnsafeImpl;
    }

    private final void appendln() {
        if (this.prettyPrint && !this.ln) {
            this.out.append("\n");
            this.ln = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void indent() {
        if (this.prettyPrint) {
            void var1_1;
            int remaining;
            if (!this.ln) {
                this.out.append("\n");
            }
            for (remaining = this.level; remaining >= 4; remaining -= 4) {
                this.out.append("        ");
            }
            while (remaining >= 2) {
                this.out.append("    ");
                remaining -= 2;
            }
            if (var1_1 > 0) {
                this.out.append("  ");
            }
            this.ln = false;
        }
    }
}

