/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.routing;

import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.server.routing.IgnoreTrailingSlashKt;
import io.ktor.server.routing.RouteSelector;
import io.ktor.server.routing.RouteSelectorEvaluation;
import io.ktor.server.routing.RoutingResolveContext;
import io.ktor.util.PlatformUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchNamedGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0096@\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector;", "Lio/ktor/server/routing/RouteSelector;", "Lkotlin/text/Regex;", "regex", "<init>", "(Lkotlin/text/Regex;)V", "Lio/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lio/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lio/ktor/server/routing/RoutingResolveContext;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlin/text/MatchResult;", "result", "lastSlashPosition", "", "prefix", "countSegments", "(Lkotlin/text/MatchResult;ILjava/lang/String;)I", "toString", "()Ljava/lang/String;", "Lkotlin/text/Regex;", "Companion", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRegexRouting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n+ 2 Parameters.kt\nio/ktor/http/Parameters$Companion\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,291:1\n24#2:292\n1317#3,2:293\n1104#4,3:295\n*S KotlinDebug\n*F\n+ 1 RegexRouting.kt\nio/ktor/server/routing/PathSegmentRegexRouteSelector\n*L\n259#1:292\n260#1:293,2\n275#1:295,3\n*E\n"})
public final class PathSegmentRegexRouteSelector
extends RouteSelector {
    public static final Companion Companion = new Companion(null);
    private final Regex regex;
    private static final Regex GROUP_NAME_MATCHER = PlatformUtils.INSTANCE.getIS_JS() ? new Regex("(^|[^\\\\])\\(\\?<(\\p{L}[\\p{L}\\p{N}]*)>(.*?[^\\\\])?\\)") : new Regex("(^|[^\\\\])\\(\\?<(\\p{Alpha}\\p{Alnum}*)>(.*?[^\\\\])?\\)");

    /*
     * WARNING - void declaration
     */
    public PathSegmentRegexRouteSelector(Regex regex) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        this.regex = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object evaluate(RoutingResolveContext context, int segmentIndex, Continuation<? super RouteSelectorEvaluation> $completion) {
        void var1_2;
        ParametersBuilder parametersBuilder;
        int n;
        String prefix = StringsKt.startsWith$default((CharSequence)this.regex.getPattern(), (char)'/', (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.regex.getPattern(), (String)"\\/", (boolean)false, (int)2, null) ? "/" : "";
        String postfix = StringsKt.endsWith$default((CharSequence)this.regex.getPattern(), (char)'/', (boolean)false, (int)2, null) && IgnoreTrailingSlashKt.getIgnoreTrailingSlash(context.getCall()) ? "/" : "";
        String pathSegments = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)context.getSegments(), (int)segmentIndex), (CharSequence)"/", (CharSequence)prefix, (CharSequence)postfix, (int)0, null, null, (int)56, null);
        MatchResult matchResult = Regex.find$default((Regex)this.regex, (CharSequence)pathSegments, (int)0, (int)2, null);
        if (matchResult == null) {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        MatchResult result = matchResult;
        int consumedLength2 = matchResult.getValue().length();
        if (pathSegments.length() == consumedLength2) {
            n = context.getSegments().size() - segmentIndex;
        } else if (pathSegments.charAt(consumedLength2) == '/') {
            n = this.countSegments(result, consumedLength2, prefix);
        } else if (consumedLength2 > 0 && pathSegments.charAt(consumedLength2 - 1) == '/') {
            n = this.countSegments(result, consumedLength2 - 1, (String)parametersBuilder);
        } else {
            return RouteSelectorEvaluation.Companion.getFailed();
        }
        int segmentIncrement = n;
        MatchGroupCollection matchGroupCollection = result.getGroups();
        Intrinsics.checkNotNull((Object)matchGroupCollection, (String)"null cannot be cast to non-null type kotlin.text.MatchNamedGroupCollection");
        MatchNamedGroupCollection groups = (MatchNamedGroupCollection)matchGroupCollection;
        ParametersBuilder $this$evaluate_u24lambda_u242 = parametersBuilder = ParametersKt.ParametersBuilder$default((int)0, (int)1, null);
        Object object = Regex.findAll$default((Regex)GROUP_NAME_MATCHER, (CharSequence)this.regex.getPattern(), (int)0, (int)2, null);
        object = object.iterator();
        while (object.hasNext()) {
            Object consumedLength2 = object.next();
            String name = (String)(consumedLength2 = (MatchResult)consumedLength2).getDestructured().getMatch().getGroupValues().get(2);
            Object object2 = groups.get(name);
            if (object2 == null || (object2 = object2.getValue()) == null) {
                object2 = "";
            }
            Object value = object2;
            $this$evaluate_u24lambda_u242.append(name, (String)value);
        }
        Parameters parameters = parametersBuilder.build();
        return new RouteSelectorEvaluation.Success(1.0, parameters, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final int countSegments(MatchResult result, int lastSlashPosition, String prefix) {
        void var1_2;
        void var3_4;
        void var2_3;
        String string = result.getValue().substring(0, lastSlashPosition);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        result = string;
        CharSequence $this$count$iv = string;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char c;
            char c2 = $this$count$iv.charAt(i);
            c2 = c2;
            if (!(c == '/')) continue;
            ++count$iv;
        }
        void count = var2_3;
        if (Intrinsics.areEqual((Object)var3_4, (Object)"/")) {
            return (int)count;
        }
        return (int)(var1_2 + true);
    }

    public final String toString() {
        return "Regex(" + this.regex.getPattern() + ')';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/routing/PathSegmentRegexRouteSelector$Companion;", "", "<init>", "()V", "Lkotlin/text/Regex;", "GROUP_NAME_MATCHER", "Lkotlin/text/Regex;", "ktor-server-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

