/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.request;

import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.RangesKt;
import io.ktor.http.RangesSpecifier;
import io.ktor.server.plugins.OriginConnectionPointKt;
import io.ktor.server.request.ApplicationRequest;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u001b\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0011\u0010\u0005\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0011\u0010\b\u001a\u00020\u0007*\u00020\u0000\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0019\u0010\u000f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000e*\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0011\u0010\u0011\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0006\u001a\u0011\u0010\u0012\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0006\u001a\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0006\u001a\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0006\u001a\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0006\u001a\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u001a\u0010\u0006\u001a\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u001b\u0010\u0019\u001a\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u001c\u0010\u0006\u001a\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u001d\u0010\u0019\u001a\u0013\u0010\u001e\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u001e\u0010\u0006\u001a\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0000\u00a2\u0006\u0004\b\u001f\u0010\u0019\u001a\u0011\u0010!\u001a\u00020 *\u00020\u0000\u00a2\u0006\u0004\b!\u0010\"\u001a\u0011\u0010#\u001a\u00020 *\u00020\u0000\u00a2\u0006\u0004\b#\u0010\"\u001a\u0013\u0010$\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b$\u0010\u0006\u001a\u0013\u0010%\u001a\u0004\u0018\u00010\u0001*\u00020\u0000\u00a2\u0006\u0004\b%\u0010\u0006\u001a\u0011\u0010&\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b&\u0010\u0006\u001a\u0011\u0010(\u001a\u00020'*\u00020\u0000\u00a2\u0006\u0004\b(\u0010)\u001a\u0013\u0010+\u001a\u0004\u0018\u00010**\u00020\u0000\u00a2\u0006\u0004\b+\u0010,\"\u0015\u0010.\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0006\"\u0015\u00102\u001a\u00020/*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b0\u00101\"\u0015\u00104\u001a\u00020\u0001*\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0006\u00a8\u00065"}, d2={"Lio/ktor/server/request/ApplicationRequest;", "", "name", "header", "(Lio/ktor/server/request/ApplicationRequest;Ljava/lang/String;)Ljava/lang/String;", "queryString", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/lang/String;", "Lio/ktor/http/ContentType;", "contentType", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/ContentType;", "", "contentLength", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/lang/Long;", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "contentCharset", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/nio/charset/Charset;", "document", "path", "authorization", "location", "accept", "", "Lio/ktor/http/HeaderValue;", "acceptItems", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/util/List;", "acceptEncoding", "acceptEncodingItems", "acceptLanguage", "acceptLanguageItems", "acceptCharset", "acceptCharsetItems", "", "isChunked", "(Lio/ktor/server/request/ApplicationRequest;)Z", "isMultipart", "userAgent", "cacheControl", "host", "", "port", "(Lio/ktor/server/request/ApplicationRequest;)I", "Lio/ktor/http/RangesSpecifier;", "ranges", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/RangesSpecifier;", "getUri", "uri", "Lio/ktor/http/HttpMethod;", "getHttpMethod", "(Lio/ktor/server/request/ApplicationRequest;)Lio/ktor/http/HttpMethod;", "httpMethod", "getHttpVersion", "httpVersion", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nApplicationRequestProperties.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationRequestProperties.kt\nio/ktor/server/request/ApplicationRequestPropertiesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class ApplicationRequestPropertiesKt {
    /*
     * WARNING - void declaration
     */
    public static final String header(ApplicationRequest $this$header, String name) {
        void var1_1;
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$header, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return applicationRequest.getHeaders().get((String)var1_1);
    }

    public static final String queryString(ApplicationRequest $this$queryString) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$queryString, (String)"<this>");
        return StringsKt.substringAfter((String)OriginConnectionPointKt.getOrigin(applicationRequest).getUri(), (char)'?', (String)"");
    }

    public static final ContentType contentType(ApplicationRequest $this$contentType) {
        String string;
        block3: {
            block2: {
                String string2;
                Intrinsics.checkNotNullParameter((Object)$this$contentType, (String)"<this>");
                string = ApplicationRequestPropertiesKt.header($this$contentType, HttpHeaders.INSTANCE.getContentType());
                if (string == null) break block2;
                String it = string;
                string = ContentType.Companion.parse(string2);
                if (string != null) break block3;
            }
            string = ContentType.Companion.getAny();
        }
        return string;
    }

    public static final Long contentLength(ApplicationRequest $this$contentLength) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$contentLength, (String)"<this>");
        String string = ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getContentLength());
        if (string != null) {
            return StringsKt.toLongOrNull((String)string);
        }
        return null;
    }

    public static final Charset contentCharset(ApplicationRequest $this$contentCharset) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$contentCharset, (String)"<this>");
        return ContentTypesKt.charset((HeaderValueWithParameters)((HeaderValueWithParameters)ApplicationRequestPropertiesKt.contentType(applicationRequest)));
    }

    public static final String document(ApplicationRequest $this$document) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$document, (String)"<this>");
        return StringsKt.substringAfterLast$default((String)ApplicationRequestPropertiesKt.path(applicationRequest), (char)'/', null, (int)2, null);
    }

    public static final String path(ApplicationRequest $this$path) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$path, (String)"<this>");
        return StringsKt.substringBefore$default((String)OriginConnectionPointKt.getOrigin(applicationRequest).getUri(), (char)'?', null, (int)2, null);
    }

    public static final String authorization(ApplicationRequest $this$authorization) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$authorization, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAuthorization());
    }

    public static final String location(ApplicationRequest $this$location) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getLocation());
    }

    public static final String accept(ApplicationRequest $this$accept) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$accept, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAccept());
    }

    public static final List<HeaderValue> acceptItems(ApplicationRequest $this$acceptItems) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$acceptItems, (String)"<this>");
        return HttpHeaderValueParserKt.parseAndSortContentTypeHeader((String)ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAccept()));
    }

    public static final String acceptEncoding(ApplicationRequest $this$acceptEncoding) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$acceptEncoding, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAcceptEncoding());
    }

    public static final List<HeaderValue> acceptEncodingItems(ApplicationRequest $this$acceptEncodingItems) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$acceptEncodingItems, (String)"<this>");
        return HttpHeaderValueParserKt.parseAndSortHeader((String)ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAcceptEncoding()));
    }

    public static final String acceptLanguage(ApplicationRequest $this$acceptLanguage) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$acceptLanguage, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAcceptLanguage());
    }

    public static final List<HeaderValue> acceptLanguageItems(ApplicationRequest $this$acceptLanguageItems) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$acceptLanguageItems, (String)"<this>");
        return HttpHeaderValueParserKt.parseAndSortHeader((String)ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAcceptLanguage()));
    }

    public static final String acceptCharset(ApplicationRequest $this$acceptCharset) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$acceptCharset, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAcceptCharset());
    }

    public static final List<HeaderValue> acceptCharsetItems(ApplicationRequest $this$acceptCharsetItems) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$acceptCharsetItems, (String)"<this>");
        return HttpHeaderValueParserKt.parseAndSortHeader((String)ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getAcceptCharset()));
    }

    public static final boolean isChunked(ApplicationRequest $this$isChunked) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$isChunked, (String)"<this>");
        String string = ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getTransferEncoding());
        if (string != null) {
            return StringsKt.compareTo((String)string, (String)"chunked", (boolean)true) == 0;
        }
        return false;
    }

    public static final boolean isMultipart(ApplicationRequest $this$isMultipart) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$isMultipart, (String)"<this>");
        return ApplicationRequestPropertiesKt.contentType(applicationRequest).match(ContentType.MultiPart.INSTANCE.getAny());
    }

    public static final String userAgent(ApplicationRequest $this$userAgent) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$userAgent, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getUserAgent());
    }

    public static final String cacheControl(ApplicationRequest $this$cacheControl) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$cacheControl, (String)"<this>");
        return ApplicationRequestPropertiesKt.header(applicationRequest, HttpHeaders.INSTANCE.getCacheControl());
    }

    public static final String host(ApplicationRequest $this$host) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$host, (String)"<this>");
        return OriginConnectionPointKt.getOrigin(applicationRequest).getServerHost();
    }

    public static final int port(ApplicationRequest $this$port) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$port, (String)"<this>");
        return OriginConnectionPointKt.getOrigin(applicationRequest).getServerPort();
    }

    public static final RangesSpecifier ranges(ApplicationRequest $this$ranges) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$ranges, (String)"<this>");
        String string2 = ApplicationRequestPropertiesKt.header((ApplicationRequest)((Object)string), HttpHeaders.INSTANCE.getRange());
        if (string2 != null) {
            string = string2;
            return RangesKt.parseRangesSpecifier((String)string2);
        }
        return null;
    }

    public static final String getUri(ApplicationRequest $this$uri) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$uri, (String)"<this>");
        return OriginConnectionPointKt.getOrigin(applicationRequest).getUri();
    }

    public static final HttpMethod getHttpMethod(ApplicationRequest $this$httpMethod) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$httpMethod, (String)"<this>");
        return OriginConnectionPointKt.getOrigin(applicationRequest).getMethod();
    }

    public static final String getHttpVersion(ApplicationRequest $this$httpVersion) {
        ApplicationRequest applicationRequest;
        Intrinsics.checkNotNullParameter((Object)$this$httpVersion, (String)"<this>");
        return OriginConnectionPointKt.getOrigin(applicationRequest).getVersion();
    }
}

