/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEnvironmentBuilder;
import io.ktor.server.engine.CommandLineKt;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.util.CharsetKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u001aI\u0010\t\u001a\u00020\b*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a!\u0010\u000e\u001a\u00020\b*\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\fH\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a!\u0010\u0012\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00110\u0010H\u0000\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u001f\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0017\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lio/ktor/server/engine/ApplicationEngine$Configuration;", "", "host", "sslPort", "sslKeyStorePath", "sslKeyStorePassword", "sslPrivateKeyPassword", "sslKeyAlias", "", "configureSSLConnectors", "(Lio/ktor/server/engine/ApplicationEngine$Configuration;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lio/ktor/server/engine/ApplicationEnvironmentBuilder;", "", "args", "configurePlatformProperties", "(Lio/ktor/server/engine/ApplicationEnvironmentBuilder;[Ljava/lang/String;)V", "", "Lkotlin/Pair;", "getKtorEnvironmentProperties", "()Ljava/util/List;", "key", "getEnvironmentProperty", "(Ljava/lang/String;)Ljava/lang/String;", "value", "setEnvironmentProperty", "(Ljava/lang/String;Ljava/lang/String;)V", "clearEnvironmentProperty", "(Ljava/lang/String;)V", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nEnvironmentUtilsJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentUtilsJvm.kt\nio/ktor/server/engine/EnvironmentUtilsJvmKt\n+ 2 EngineConnectorConfigJvm.kt\nio/ktor/server/engine/EngineConnectorConfigJvmKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,97:1\n20#2,2:98\n11483#3,9:100\n13409#3:109\n13410#3:111\n11492#3:112\n1#4:110\n1#4:113\n216#5,2:114\n*S KotlinDebug\n*F\n+ 1 EnvironmentUtilsJvm.kt\nio/ktor/server/engine/EnvironmentUtilsJvmKt\n*L\n51#1:98,2\n64#1:100,9\n64#1:109\n64#1:111\n64#1:112\n64#1:110\n77#1:114,2\n*E\n"})
public final class EnvironmentUtilsJvmKt {
    /*
     * WARNING - void declaration
     */
    public static final void configureSSLConnectors(ApplicationEngine.Configuration $this$configureSSLConnectors, String host, String sslPort, String sslKeyStorePath, String sslKeyStorePassword, String sslPrivateKeyPassword, String sslKeyAlias) {
        EngineSSLConnectorBuilder engineSSLConnectorBuilder;
        void var2_2;
        void var1_1;
        void $this$sslConnector$iv;
        EngineSSLConnectorBuilder keyStorePassword$iv;
        void keyStore$iv;
        List<EngineConnectorConfig> list;
        Intrinsics.checkNotNullParameter((Object)$this$configureSSLConnectors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)sslPort, (String)"sslPort");
        Intrinsics.checkNotNullParameter((Object)sslKeyAlias, (String)"sslKeyAlias");
        if (sslKeyStorePath == null) {
            throw new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or ktor.security.ssl.keyStore config");
        }
        if (sslKeyStorePassword == null) {
            throw new IllegalArgumentException("SSL requires keystore password: use ktor.security.ssl.keyStorePassword config");
        }
        if (sslPrivateKeyPassword == null) {
            throw new IllegalArgumentException("SSL requires certificate password: use ktor.security.ssl.privateKeyPassword config");
        }
        Object file2 = new File(sslKeyStorePath);
        File keyStoreFile = ((File)file2).exists() || ((File)file2).isAbsolute() ? file2 : new File(".", sslKeyStorePath).getAbsoluteFile();
        file2 = KeyStore.getInstance(KeyStore.getDefaultType());
        KeyStore $this$configureSSLConnectors_u24lambda_u243 = file2;
        Closeable closeable = new FileInputStream(keyStoreFile);
        Object object = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            $this$configureSSLConnectors_u24lambda_u243.load(it, CharsetKt.toCharArray((String)sslKeyStorePassword));
        }
        catch (Throwable throwable) {
            try {
                Throwable throwable2 = throwable;
                object = throwable;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                throw throwable3;
            }
        }
        CloseableKt.closeFinally((Closeable)closeable, null);
        if ($this$configureSSLConnectors_u24lambda_u243.getKey(sslKeyAlias, CharsetKt.toCharArray((String)sslPrivateKeyPassword)) == null) {
            object = "The specified key " + sslKeyAlias + " doesn't exist in the key store " + sslKeyStorePath;
            throw new IllegalArgumentException(object.toString());
        }
        Object keyStore = file2;
        file2 = $this$configureSSLConnectors;
        Intrinsics.checkNotNull((Object)keyStore);
        $this$configureSSLConnectors_u24lambda_u243 = list;
        $this$configureSSLConnectors = () -> EnvironmentUtilsJvmKt.configureSSLConnectors$lambda$4(sslKeyStorePassword);
        Function0 privateKeyPassword$iv = () -> EnvironmentUtilsJvmKt.configureSSLConnectors$lambda$5(sslPrivateKeyPassword);
        EngineSSLConnectorBuilder engineSSLConnectorBuilder2 = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
        EngineSSLConnectorBuilder $this$configureSSLConnectors_u24lambda_u246 = engineSSLConnectorBuilder2;
        list = $this$sslConnector$iv.getConnectors();
        $this$configureSSLConnectors_u24lambda_u246.setHost((String)var1_1);
        ((EngineConnectorBuilder)$this$configureSSLConnectors_u24lambda_u246).setPort(Integer.parseInt((String)var2_2));
        engineSSLConnectorBuilder.setKeyStorePath(keyStoreFile);
        list.add(engineSSLConnectorBuilder2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configurePlatformProperties(ApplicationEnvironmentBuilder $this$configurePlatformProperties, String[] args) {
        ClassLoader classLoader;
        ApplicationEnvironmentBuilder applicationEnvironmentBuilder;
        URL uRL;
        void $this$mapNotNullTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$configurePlatformProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Collection destination$iv$iv = new ArrayList();
        for (void v0 : $this$mapNotNullTo$iv$iv2) {
            Pair<String, String> it$iv$iv;
            void var5_7 = v0;
            var5_7 = v0;
            var5_7 = v0;
            if (CommandLineKt.splitPair((String)v0, '=') == null) continue;
            destination$iv$iv.add(it$iv$iv);
        }
        Map $this$mapNotNullTo$iv$iv2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string = (String)$this$mapNotNullTo$iv$iv2.get("-jar");
        if (string != null) {
            void var2_4;
            String it = string;
            uRL = StringsKt.startsWith$default((String)string, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it).toURL() : new File((String)var2_4).toURI().toURL();
        } else {
            uRL = null;
        }
        URL jar = uRL;
        ApplicationEnvironmentBuilder applicationEnvironmentBuilder2 = applicationEnvironmentBuilder;
        if (jar != null) {
            void var1_3;
            applicationEnvironmentBuilder = applicationEnvironmentBuilder2;
            URL[] uRLArray = new URL[1];
            URL[] uRLArray2 = uRLArray;
            uRLArray[0] = var1_3;
            applicationEnvironmentBuilder2 = applicationEnvironmentBuilder;
            classLoader = new URLClassLoader(uRLArray2, ApplicationEnvironment.class.getClassLoader());
        } else {
            ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getClassLoader(...)");
        }
        applicationEnvironmentBuilder2.setClassLoader(classLoader);
    }

    public static final List<Pair<String, String>> getKtorEnvironmentProperties() {
        List list;
        List $this$getKtorEnvironmentProperties_u24lambda_u2411 = list = CollectionsKt.createListBuilder();
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        Object object = properties;
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            String value;
            String key2;
            Map.Entry entry;
            Map.Entry it = entry = (Map.Entry)object.next();
            Object k = entry.getKey();
            if ((k instanceof String ? (String)k : null) == null || !StringsKt.startsWith$default((String)(key2 = key2), (String)"ktor.", (boolean)false, (int)2, null) || ((it = it.getValue()) instanceof String ? (String)((Object)it) : null) == null) continue;
            value = value;
            $this$getKtorEnvironmentProperties_u24lambda_u2411.add(TuplesKt.to((Object)key2, (Object)entry));
        }
        return CollectionsKt.build((List)list);
    }

    public static final String getEnvironmentProperty(String key2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        return System.getProperty(string);
    }

    /*
     * WARNING - void declaration
     */
    public static final void setEnvironmentProperty(String key2, String value) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        System.setProperty(string, (String)var1_1);
    }

    public static final void clearEnvironmentProperty(String key2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        System.clearProperty(string);
    }

    private static final char[] configureSSLConnectors$lambda$4(String $sslKeyStorePassword) {
        return CharsetKt.toCharArray((String)$sslKeyStorePassword);
    }

    private static final char[] configureSSLConnectors$lambda$5(String $sslPrivateKeyPassword) {
        return CharsetKt.toCharArray((String)$sslPrivateKeyPassword);
    }
}

