/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class SpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(SpnegoAuthenticator.class);
    private String _authMethod = "SPNEGO";

    public SpnegoAuthenticator() {
    }

    /*
     * WARNING - void declaration
     */
    public SpnegoAuthenticator(String authMethod) {
        void var1_1;
        this._authMethod = var1_1;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException {
        String spnegoToken;
        UserIdentity user;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String header = req.getHeader(HttpHeader.AUTHORIZATION.asString());
        String authScheme = this.getAuthSchemeFromHeader(header);
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        if (header != null && this.isAuthSchemeNegotiate(authScheme) && (user = this.login(null, spnegoToken = header.substring(10), request)) != null) {
            void var1_1;
            return new UserAuthentication(this.getAuthMethod(), (UserIdentity)var1_1);
        }
        try {
            void var2_2;
            if (DeferredAuthentication.isDeferred(res)) {
                return Authentication.UNAUTHENTICATED;
            }
            LOG.debug("Sending challenge", new Object[0]);
            res.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), HttpHeader.NEGOTIATE.asString());
            var2_2.sendError(401);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException ioe) {
            void var3_5;
            throw new ServerAuthException((Throwable)var3_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    String getAuthSchemeFromHeader(String header) {
        void var1_1;
        if (header == null || header.isEmpty()) {
            return "";
        }
        String trimmedHeader = header.trim();
        int index = trimmedHeader.indexOf(32);
        if (index > 0) {
            void var2_2;
            return trimmedHeader.substring(0, (int)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    boolean isAuthSchemeNegotiate(String authScheme) {
        void var1_1;
        if (authScheme == null || authScheme.length() != HttpHeader.NEGOTIATE.asString().length()) {
            return false;
        }
        return var1_1.equalsIgnoreCase(HttpHeader.NEGOTIATE.asString());
    }

    @Override
    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

