/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = Log.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(ServletRequest request) {
    }

    /*
     * WARNING - void declaration
     */
    public UserIdentity login(String username, Object password, ServletRequest servletRequest) {
        UserIdentity user = this._loginService.login(username, password, servletRequest);
        if (user != null) {
            void var1_1;
            void var2_2;
            void var3_3;
            Request request;
            Request request2 = request = Request.getBaseRequest((ServletRequest)var3_3);
            this.renewSession((HttpServletRequest)request2, (HttpServletResponse)(request2 == null ? null : var2_2.getResponse()));
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void logout(ServletRequest request) {
        void var1_1;
        HttpSession session = (request = (HttpServletRequest)request).getSession(false);
        if (session == null) {
            return;
        }
        var1_1.removeAttribute("org.eclipse.jetty.security.sessionCreatedSecure");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        void var1_1;
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + this + " in " + configuration);
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + this + " in " + configuration);
        }
        this._renewSession = var1_1.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpSession renewSession(HttpServletRequest request, HttpServletResponse response) {
        void var3_4;
        HttpSession httpSession = request.getSession(false);
        if (this._renewSession && httpSession != null) {
            HttpSession httpSession2 = httpSession;
            synchronized (httpSession2) {
                if (httpSession.getAttribute("org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    if (httpSession instanceof Session) {
                        Session s = (Session)httpSession;
                        String oldId = s.getId();
                        s.renewId(request);
                        s.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
                        if (s.isIdChanged() && response instanceof Response) {
                            void var1_1;
                            void var2_3;
                            ((Response)var2_3).replaceCookie(s.getSessionHandler().getSessionCookie((HttpSession)s, request.getContextPath(), var1_1.isSecure()));
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("renew {}->{}", new Object[]{oldId, s.getId()});
                        }
                    } else {
                        LOG.warn("Unable to renew session " + httpSession, new Object[0]);
                    }
                    return httpSession;
                }
            }
        }
        return var3_4;
    }
}

