/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FormAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(FormAuthenticator.class);
    public static final String __FORM_LOGIN_PAGE = "org.eclipse.jetty.security.form_login_page";
    public static final String __FORM_ERROR_PAGE = "org.eclipse.jetty.security.form_error_page";
    public static final String __FORM_DISPATCH = "org.eclipse.jetty.security.dispatch";
    public static final String __J_URI = "org.eclipse.jetty.security.form_URI";
    public static final String __J_POST = "org.eclipse.jetty.security.form_POST";
    public static final String __J_METHOD = "org.eclipse.jetty.security.form_METHOD";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private boolean _dispatch;
    private boolean _alwaysSaveUri;

    public FormAuthenticator() {
    }

    /*
     * WARNING - void declaration
     */
    public FormAuthenticator(String login, String error, boolean dispatch) {
        this();
        void var3_3;
        if (login != null) {
            void var1_1;
            this.setLoginPage((String)var1_1);
        }
        if (error != null) {
            void var2_2;
            this.setErrorPage((String)var2_2);
        }
        this._dispatch = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void setAlwaysSaveUri(boolean alwaysSave) {
        void var1_1;
        this._alwaysSaveUri = var1_1;
    }

    public boolean getAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        void var1_1;
        String dispatch;
        String error;
        super.setConfiguration(configuration);
        String login = configuration.getInitParameter(__FORM_LOGIN_PAGE);
        if (login != null) {
            this.setLoginPage(login);
        }
        if ((error = configuration.getInitParameter(__FORM_ERROR_PAGE)) != null) {
            void var2_2;
            this.setErrorPage((String)var2_2);
        }
        this._dispatch = (dispatch = configuration.getInitParameter(__FORM_DISPATCH)) == null ? this._dispatch : Boolean.parseBoolean((String)var1_1);
    }

    @Override
    public String getAuthMethod() {
        return "FORM";
    }

    /*
     * WARNING - void declaration
     */
    private void setLoginPage(String path) {
        void var1_1;
        if (!path.startsWith("/")) {
            LOG.warn("form-login-page must start with /", new Object[0]);
            path = "/" + path;
        }
        this._formLoginPage = path;
        this._formLoginPath = var1_1;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setErrorPage(String path) {
        void var1_1;
        if (path == null || path.trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
            return;
        }
        if (!path.startsWith("/")) {
            LOG.warn("form-error-page must start with /", new Object[0]);
            path = "/" + path;
        }
        this._formErrorPage = path;
        this._formErrorPath = var1_1;
        if (this._formErrorPath.indexOf(63) > 0) {
            this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UserIdentity login(String username, Object password, ServletRequest request) {
        void var1_1;
        UserIdentity user = super.login(username, password, request);
        if (user != null) {
            void var2_2;
            void var3_3;
            HttpSession session = ((HttpServletRequest)request).getSession(true);
            SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, password);
            var3_3.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)var2_2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logout(ServletRequest request) {
        void var1_1;
        super.logout(request);
        request = (HttpServletRequest)request;
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        var1_1.removeAttribute("org.eclipse.jetty.security.UserIdentity");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void prepareRequest(ServletRequest request) {
        void var3_3;
        Request request2;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        if (session == null || session.getAttribute("org.eclipse.jetty.security.UserIdentity") == null) {
            return;
        }
        String juri = (String)session.getAttribute(__J_URI);
        if (juri == null || juri.length() == 0) {
            return;
        }
        String method = (String)session.getAttribute(__J_METHOD);
        if (method == null || method.length() == 0) {
            return;
        }
        StringBuffer buf = httpRequest.getRequestURL();
        if (httpRequest.getQueryString() != null) {
            buf.append("?").append(httpRequest.getQueryString());
        }
        if (!juri.equals(buf.toString())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            void var2_2;
            LOG.debug("Restoring original method {} for {} with method {}", new Object[]{method, juri, var2_2.getMethod()});
        }
        request2 = Request.getBaseRequest((ServletRequest)request2);
        request2.setMethod((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        Response baseResponse = baseRequest.getResponse();
        String uri = request.getRequestURI();
        if (uri == null) {
            uri = "/";
        }
        if (!(mandatory |= this.isJSecurityCheck(uri))) {
            return new DeferredAuthentication(this);
        }
        if (this.isLoginOrErrorPage(URIUtil.addPaths((String)request.getServletPath(), (String)request.getPathInfo())) && !DeferredAuthentication.isDeferred(response)) {
            return new DeferredAuthentication(this);
        }
        try {
            void var4_10;
            StringBuffer buf;
            FormAuthentication formAuth;
            if (this.isJSecurityCheck(uri)) {
                String username = request.getParameter(__J_USERNAME);
                String password = request.getParameter(__J_PASSWORD);
                UserIdentity user = ((LoginAuthenticator)this).login(username, password, (ServletRequest)request);
                LOG.debug("jsecuritycheck {} {}", new Object[]{username, user});
                HttpSession session = request.getSession(false);
                if (user != null) {
                    String nuri;
                    username = session;
                    synchronized (username) {
                        nuri = (String)session.getAttribute(__J_URI);
                        if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                            nuri = "/";
                        }
                        formAuth = new FormAuthentication(this.getAuthMethod(), user);
                    }
                    LOG.debug("authenticated {}->{}", new Object[]{formAuth, nuri});
                    response.setContentLength(0);
                    baseResponse.sendRedirect(response.encodeRedirectURL(nuri), true);
                    return formAuth;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Form authentication FAILED for " + StringUtil.printable((String)username), new Object[0]);
                }
                if (this._formErrorPage == null) {
                    LOG.debug("auth failed {}->403", new Object[]{username});
                    if (response != null) {
                        response.sendError(403);
                    }
                } else if (this._dispatch) {
                    LOG.debug("auth failed {}=={}", new Object[]{username, this._formErrorPage});
                    RequestDispatcher dispatcher = formAuth.getRequestDispatcher(this._formErrorPage);
                    response.setHeader(HttpHeader.CACHE_CONTROL.asString(), HttpHeaderValue.NO_CACHE.asString());
                    response.setDateHeader(HttpHeader.EXPIRES.asString(), 1L);
                    dispatcher.forward((ServletRequest)new FormRequest((HttpServletRequest)formAuth), (ServletResponse)new FormResponse(response));
                } else {
                    LOG.debug("auth failed {}->{}", new Object[]{username, this._formErrorPage});
                    baseResponse.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths((String)formAuth.getContextPath(), (String)this._formErrorPage)), true);
                }
                return Authentication.SEND_FAILURE;
            }
            HttpSession session = formAuth.getSession(false);
            Authentication authentication = session == null ? null : (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
            if (authentication != null) {
                if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                    LOG.debug("auth revoked {}", new Object[]{authentication});
                    session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
                } else {
                    HttpSession user = session;
                    synchronized (user) {
                        String jUri = (String)session.getAttribute(__J_URI);
                        if (jUri != null) {
                            LOG.debug("auth retry {}->{}", new Object[]{authentication, jUri});
                            buf = formAuth.getRequestURL();
                            if (formAuth.getQueryString() != null) {
                                buf.append("?").append(formAuth.getQueryString());
                            }
                            if (jUri.equals(buf.toString())) {
                                MultiMap jPost = (MultiMap)session.getAttribute(__J_POST);
                                if (jPost != null) {
                                    LOG.debug("auth rePOST {}->{}", new Object[]{authentication, jUri});
                                    baseRequest.setContentParameters(jPost);
                                }
                                session.removeAttribute(__J_URI);
                                session.removeAttribute(__J_METHOD);
                                session.removeAttribute(__J_POST);
                            }
                        }
                    }
                    LOG.debug("auth {}", new Object[]{authentication});
                    return authentication;
                }
            }
            if (DeferredAuthentication.isDeferred(response)) {
                LOG.debug("auth deferred {}", new Object[]{session == null ? null : session.getId()});
                return Authentication.UNAUTHENTICATED;
            }
            session = session != null ? session : var4_10.getSession(true);
            HttpSession user = session;
            synchronized (session) {
                if (session.getAttribute(__J_URI) == null || this._alwaysSaveUri) {
                    StringBuffer buf2 = var4_10.getRequestURL();
                    if (var4_10.getQueryString() != null) {
                        buf2.append("?").append(var4_10.getQueryString());
                    }
                    session.setAttribute(__J_URI, (Object)buf2.toString());
                    session.setAttribute(__J_METHOD, (Object)var4_10.getMethod());
                    if (MimeTypes.Type.FORM_ENCODED.is(buf.getContentType()) && HttpMethod.POST.is(var4_10.getMethod())) {
                        void var1_1;
                        MultiMap formParameters = new MultiMap();
                        baseRequest.extractFormParameters(formParameters);
                        session.setAttribute(__J_POST, (Object)var1_1);
                    }
                }
                // ** MonitorExit[user] (shouldn't be in output)
                if (this._dispatch) {
                    LOG.debug("challenge {}=={}", new Object[]{session.getId(), this._formLoginPage});
                    RequestDispatcher dispatcher = var4_10.getRequestDispatcher(this._formLoginPage);
                    response.setHeader(HttpHeader.CACHE_CONTROL.asString(), HttpHeaderValue.NO_CACHE.asString());
                    response.setDateHeader(HttpHeader.EXPIRES.asString(), 1L);
                    dispatcher.forward((ServletRequest)new FormRequest((HttpServletRequest)var4_10), (ServletResponse)new FormResponse(response));
                } else {
                    void var2_5;
                    LOG.debug("challenge {}->{}", new Object[]{session.getId(), this._formLoginPage});
                    baseResponse.sendRedirect(var2_5.encodeRedirectURL(URIUtil.addPaths((String)var4_10.getContextPath(), (String)this._formLoginPage)), true);
                }
                return Authentication.SEND_CONTINUE;
            }
        }
        catch (IOException | ServletException e) {
            void var3_9;
            throw new ServerAuthException((Throwable)var3_9);
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isJSecurityCheck(String uri) {
        void var1_2;
        void var2_3;
        int jsc = uri.indexOf(__J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + 17;
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt((int)var2_3);
        return c == ';' || c == '#' || c == '/' || var1_2 == 63;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLoginOrErrorPage(String pathInContext) {
        void var1_1;
        return pathInContext != null && (pathInContext.equals(this._formErrorPath) || var1_1.equals(this._formLoginPath));
    }

    @Override
    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public static class FormAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        /*
         * WARNING - void declaration
         */
        public FormAuthentication(String method, UserIdentity userIdentity) {
            super((String)var1_1, (UserIdentity)var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public String toString() {
            return "Form" + super.toString();
        }
    }

    protected static class FormResponse
    extends HttpServletResponseWrapper {
        /*
         * WARNING - void declaration
         */
        public FormResponse(HttpServletResponse response) {
            super((HttpServletResponse)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public void addDateHeader(String name, long date) {
            if (this.notIgnored(name)) {
                void var2_2;
                void var1_1;
                super.addDateHeader((String)var1_1, (long)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void addHeader(String name, String value) {
            if (this.notIgnored(name)) {
                void var2_2;
                void var1_1;
                super.addHeader((String)var1_1, (String)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setDateHeader(String name, long date) {
            if (this.notIgnored(name)) {
                void var2_2;
                void var1_1;
                super.setDateHeader((String)var1_1, (long)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void setHeader(String name, String value) {
            if (this.notIgnored(name)) {
                void var2_2;
                void var1_1;
                super.setHeader((String)var1_1, (String)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean notIgnored(String name) {
            void var1_1;
            return !HttpHeader.CACHE_CONTROL.is(name) && !HttpHeader.PRAGMA.is(name) && !HttpHeader.ETAG.is(name) && !HttpHeader.EXPIRES.is(name) && !HttpHeader.LAST_MODIFIED.is(name) && !HttpHeader.AGE.is((String)var1_1);
        }
    }

    protected static class FormRequest
    extends HttpServletRequestWrapper {
        /*
         * WARNING - void declaration
         */
        public FormRequest(HttpServletRequest request) {
            super((HttpServletRequest)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public long getDateHeader(String name) {
            void var1_1;
            if (name.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return -1L;
            }
            return super.getDateHeader((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public String getHeader(String name) {
            void var1_1;
            if (name.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return null;
            }
            return super.getHeader((String)var1_1);
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(Collections.list(super.getHeaderNames()));
        }

        /*
         * WARNING - void declaration
         */
        public Enumeration<String> getHeaders(String name) {
            void var1_1;
            if (name.toLowerCase(Locale.ENGLISH).startsWith("if-")) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getHeaders((String)var1_1);
        }
    }
}

