/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.SpnegoUserIdentity;
import org.eclipse.jetty.security.SpnegoUserPrincipal;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ConfigurableSpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = Log.getLogger(ConfigurableSpnegoAuthenticator.class);
    private final String _authMethod;
    private Duration _authenticationDuration = Duration.ofNanos(-1L);

    public ConfigurableSpnegoAuthenticator() {
        this("SPNEGO");
    }

    /*
     * WARNING - void declaration
     */
    public ConfigurableSpnegoAuthenticator(String authMethod) {
        void var1_1;
        this._authMethod = var1_1;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    public Duration getAuthenticationDuration() {
        return this._authenticationDuration;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthenticationDuration(Duration authenticationDuration) {
        void var1_1;
        this._authenticationDuration = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UserIdentity login(String username, Object password, ServletRequest servletRequest) {
        void var1_1;
        SpnegoUserIdentity user = (SpnegoUserIdentity)this._loginService.login(username, password, servletRequest);
        if (user != null && user.isEstablished()) {
            void var2_2;
            void var3_3;
            Request request;
            Request request2 = request = Request.getBaseRequest((ServletRequest)var3_3);
            this.renewSession((HttpServletRequest)request2, (HttpServletResponse)(request2 == null ? null : var2_2.getResponse()));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        void var2_2;
        void var1_1;
        void var3_4;
        boolean bl;
        Duration authnDuration;
        UserIdentity identity;
        UserIdentityHolder holder;
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String header = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        String spnegoToken = this.getSpnegoToken(header);
        HttpSession httpSession = request.getSession(false);
        if (header != null && spnegoToken != null) {
            Object principal;
            SpnegoUserIdentity identity2 = (SpnegoUserIdentity)((LoginAuthenticator)this).login(null, spnegoToken, (ServletRequest)request);
            if (identity2.isEstablished()) {
                if (!DeferredAuthentication.isDeferred(response)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending final token", new Object[0]);
                    }
                    principal = (SpnegoUserPrincipal)identity2.getUserPrincipal();
                    this.setSpnegoToken(response, ((SpnegoUserPrincipal)principal).getEncodedToken());
                }
                if (!((Duration)(principal = this.getAuthenticationDuration())).isNegative()) {
                    if (httpSession == null) {
                        httpSession = request.getSession(true);
                    }
                    httpSession.setAttribute(UserIdentityHolder.ATTRIBUTE, (Object)new UserIdentityHolder(identity2));
                }
                return new UserAuthentication(this.getAuthMethod(), identity2);
            }
            if (DeferredAuthentication.isDeferred(response)) {
                return Authentication.UNAUTHENTICATED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending intermediate challenge", new Object[0]);
            }
            principal = (SpnegoUserPrincipal)identity2.getUserPrincipal();
            this.sendChallenge(response, ((SpnegoUserPrincipal)principal).getEncodedToken());
            return Authentication.SEND_CONTINUE;
        }
        if (!(httpSession == null || (holder = (UserIdentityHolder)httpSession.getAttribute(UserIdentityHolder.ATTRIBUTE)) == null || (identity = holder._userIdentity) == null || (authnDuration = this.getAuthenticationDuration()).isNegative() || (bl = !authnDuration.isZero() && Instant.now().isAfter(((UserIdentityHolder)var3_4)._validFrom.plus(authnDuration))) && HttpMethod.GET.is(var1_1.getMethod()))) {
            return new UserAuthentication(this.getAuthMethod(), identity);
        }
        if (DeferredAuthentication.isDeferred(response)) {
            return Authentication.UNAUTHENTICATED;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending initial challenge", new Object[0]);
        }
        this.sendChallenge((HttpServletResponse)var2_2, null);
        return Authentication.SEND_CONTINUE;
    }

    /*
     * WARNING - void declaration
     */
    private void sendChallenge(HttpServletResponse response, String token) throws ServerAuthException {
        try {
            void var2_3;
            this.setSpnegoToken(response, (String)var2_3);
            response.sendError(401);
            return;
        }
        catch (IOException x) {
            void var1_2;
            throw new ServerAuthException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setSpnegoToken(HttpServletResponse response, String token) {
        void var3_3;
        void var1_1;
        String value = HttpHeader.NEGOTIATE.asString();
        if (token != null) {
            void var2_2;
            value = value + " " + (String)var2_2;
        }
        var1_1.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private String getSpnegoToken(String header) {
        if (header == null) {
            return null;
        }
        String scheme = HttpHeader.NEGOTIATE.asString() + " ";
        if (header.regionMatches(true, 0, scheme, 0, scheme.length())) {
            void var2_2;
            void var1_1;
            return var1_1.substring(var2_2.length()).trim();
        }
        return null;
    }

    @Override
    public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }

    private static class UserIdentityHolder
    implements Serializable {
        private static final String ATTRIBUTE = UserIdentityHolder.class.getName();
        private final transient Instant _validFrom = Instant.now();
        private final transient UserIdentity _userIdentity;

        /*
         * WARNING - void declaration
         */
        private UserIdentityHolder(UserIdentity userIdentity) {
            void var1_1;
            this._userIdentity = var1_1;
        }
    }
}

