/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.authentication;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.security.CertificateValidator;
import org.eclipse.jetty.util.security.Password;

public class ClientCertAuthenticator
extends LoginAuthenticator {
    private static final String PASSWORD_PROPERTY = "org.eclipse.jetty.ssl.password";
    private String _trustStorePath;
    private String _trustStoreProvider;
    private String _trustStoreType = "JKS";
    private transient Password _trustStorePassword;
    private boolean _validateCerts;
    private String _crlPath;
    private int _maxCertPathLength = -1;
    private boolean _enableCRLDP = false;
    private boolean _enableOCSP = false;
    private String _ocspResponderURL;

    @Override
    public String getAuthMethod() {
        return "CLIENT_CERT";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        try {
            if (certs != null && certs.length > 0) {
                Object trustStore;
                if (this._validateCerts) {
                    ClientCertAuthenticator clientCertAuthenticator = this;
                    trustStore = clientCertAuthenticator.getKeyStore(clientCertAuthenticator._trustStorePath, this._trustStoreType, this._trustStoreProvider, this._trustStorePassword == null ? null : this._trustStorePassword.toString());
                    ClientCertAuthenticator clientCertAuthenticator2 = this;
                    Collection<? extends CRL> crls = clientCertAuthenticator2.loadCRL(clientCertAuthenticator2._crlPath);
                    CertificateValidator certificateValidator = new CertificateValidator((KeyStore)trustStore, crls);
                    certificateValidator.validate(certs);
                }
                trustStore = certs;
                int n = certs.length;
                for (int i = 0; i < n; ++i) {
                    void var3_4;
                    char[] credential;
                    String username;
                    UserIdentity user;
                    X509Certificate cert = trustStore[i];
                    if (cert == null) continue;
                    Principal principal = cert.getSubjectDN();
                    if (principal == null) {
                        principal = cert.getIssuerDN();
                    }
                    if ((user = this.login(username = principal == null ? "clientcert" : principal.getName(), credential = Base64.getEncoder().encodeToString(cert.getSignature()).toCharArray(), req)) == null) continue;
                    return new UserAuthentication(this.getAuthMethod(), (UserIdentity)var3_4);
                }
            }
            if (!DeferredAuthentication.isDeferred(response)) {
                void var2_2;
                var2_2.sendError(403);
                return Authentication.SEND_FAILURE;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (Exception e) {
            throw new ServerAuthException(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected KeyStore getKeyStore(InputStream storeStream, String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        void var3_3;
        void var2_2;
        return this.getKeyStore((String)var2_2, (String)var3_3, storeProvider, storePassword);
    }

    /*
     * WARNING - void declaration
     */
    protected KeyStore getKeyStore(String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        void var3_3;
        void var2_2;
        return CertificateUtils.getKeyStore((Resource)Resource.newResource((String)storePath), (String)var2_2, (String)var3_3, (String)storePassword);
    }

    protected Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        return CertificateUtils.loadCRL((String)crlPath);
    }

    @Override
    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public boolean isValidateCerts() {
        return this._validateCerts;
    }

    /*
     * WARNING - void declaration
     */
    public void setValidateCerts(boolean validateCerts) {
        void var1_1;
        this._validateCerts = var1_1;
    }

    public String getTrustStore() {
        return this._trustStorePath;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStore(String trustStorePath) {
        void var1_1;
        this._trustStorePath = var1_1;
    }

    public String getTrustStoreProvider() {
        return this._trustStoreProvider;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStoreProvider(String trustStoreProvider) {
        void var1_1;
        this._trustStoreProvider = var1_1;
    }

    public String getTrustStoreType() {
        return this._trustStoreType;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStoreType(String trustStoreType) {
        void var1_1;
        this._trustStoreType = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrustStorePassword(String password) {
        void var1_1;
        this._trustStorePassword = Password.getPassword((String)PASSWORD_PROPERTY, (String)var1_1, null);
    }

    public String getCrlPath() {
        return this._crlPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setCrlPath(String crlPath) {
        void var1_1;
        this._crlPath = var1_1;
    }

    public int getMaxCertPathLength() {
        return this._maxCertPathLength;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxCertPathLength(int maxCertPathLength) {
        void var1_1;
        this._maxCertPathLength = var1_1;
    }

    public boolean isEnableCRLDP() {
        return this._enableCRLDP;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableCRLDP(boolean enableCRLDP) {
        void var1_1;
        this._enableCRLDP = var1_1;
    }

    public boolean isEnableOCSP() {
        return this._enableOCSP;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableOCSP(boolean enableOCSP) {
        void var1_1;
        this._enableOCSP = var1_1;
    }

    public String getOcspResponderURL() {
        return this._ocspResponderURL;
    }

    /*
     * WARNING - void declaration
     */
    public void setOcspResponderURL(String ocspResponderURL) {
        void var1_1;
        this._ocspResponderURL = var1_1;
    }
}

