/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.security.Credential;

public class UserStore
extends AbstractLifeCycle {
    private IdentityService _identityService = new DefaultIdentityService();
    private final Map<String, UserIdentity> _knownUserIdentities = new ConcurrentHashMap<String, UserIdentity>();

    /*
     * WARNING - void declaration
     */
    public void addUser(String username, Credential credential, String[] roles) {
        void var3_3;
        void var1_1;
        String[] stringArray;
        AbstractLoginService.UserPrincipal userPrincipal = new AbstractLoginService.UserPrincipal(username, credential);
        Subject subject = new Subject();
        subject.getPrincipals().add(userPrincipal);
        subject.getPrivateCredentials().add(stringArray);
        if (roles != null) {
            stringArray = roles;
            int n = roles.length;
            for (int i = 0; i < n; ++i) {
                String role = stringArray[i];
                subject.getPrincipals().add(new AbstractLoginService.RolePrincipal(role));
            }
        }
        subject.setReadOnly();
        this._knownUserIdentities.put((String)var1_1, this._identityService.newUserIdentity(subject, userPrincipal, (String[])var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void removeUser(String username) {
        void var1_1;
        this._knownUserIdentities.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public UserIdentity getUserIdentity(String userName) {
        void var1_1;
        return this._knownUserIdentities.get(var1_1);
    }

    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public Map<String, UserIdentity> getKnownUserIdentities() {
        return this._knownUserIdentities;
    }
}

