/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class SecurityHandler
extends HandlerWrapper
implements Authenticator.AuthConfiguration {
    private static final Logger LOG = Log.getLogger(SecurityHandler.class);
    private static final List<Authenticator.Factory> __knownAuthenticatorFactories = new ArrayList<Authenticator.Factory>();
    private boolean _checkWelcomeFiles = false;
    private Authenticator _authenticator;
    private Authenticator.Factory _authenticatorFactory;
    private String _realmName;
    private String _authMethod;
    private final Map<String, String> _initParameters = new HashMap<String, String>();
    private LoginService _loginService;
    private IdentityService _identityService;
    private boolean _renewSession = true;
    public static final Principal __NO_USER;
    public static final Principal __NOBODY;

    protected SecurityHandler() {
        this.addBean(new DumpableCollection("knownAuthenticatorFactories", __knownAuthenticatorFactories));
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdentityService(IdentityService identityService) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        SecurityHandler securityHandler = this;
        securityHandler.updateBean(securityHandler._identityService, identityService);
        this._identityService = var1_1;
    }

    @Override
    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoginService(LoginService loginService) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        SecurityHandler securityHandler = this;
        securityHandler.updateBean(securityHandler._loginService, loginService);
        this._loginService = var1_1;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthenticator(Authenticator authenticator) {
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        SecurityHandler securityHandler = this;
        securityHandler.updateBean(securityHandler._authenticator, authenticator);
        this._authenticator = var1_1;
        if (this._authenticator != null) {
            this._authMethod = this._authenticator.getAuthMethod();
        }
    }

    public Authenticator.Factory getAuthenticatorFactory() {
        return this._authenticatorFactory;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthenticatorFactory(Authenticator.Factory authenticatorFactory) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        SecurityHandler securityHandler = this;
        securityHandler.updateBean(securityHandler._authenticatorFactory, authenticatorFactory);
        this._authenticatorFactory = var1_1;
    }

    public List<Authenticator.Factory> getKnownAuthenticatorFactories() {
        return __knownAuthenticatorFactories;
    }

    @Override
    public String getRealmName() {
        return this._realmName;
    }

    /*
     * WARNING - void declaration
     */
    public void setRealmName(String realmName) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._realmName = var1_1;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    /*
     * WARNING - void declaration
     */
    public void setAuthMethod(String authMethod) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authMethod = var1_1;
    }

    public boolean isCheckWelcomeFiles() {
        return this._checkWelcomeFiles;
    }

    /*
     * WARNING - void declaration
     */
    public void setCheckWelcomeFiles(boolean authenticateWelcomeFiles) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._checkWelcomeFiles = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getInitParameter(String key) {
        void var1_1;
        return this._initParameters.get(var1_1);
    }

    @Override
    public Set<String> getInitParameterNames() {
        return this._initParameters.keySet();
    }

    /*
     * WARNING - void declaration
     */
    public String setInitParameter(String key, String value) {
        void var2_2;
        void var1_1;
        if (this.isStarted()) {
            throw new IllegalStateException("started");
        }
        return this._initParameters.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected LoginService findLoginService() throws Exception {
        void var2_2;
        Object list = this.getServer().getBeans(LoginService.class);
        LoginService service = null;
        String realm = this.getRealmName();
        if (realm != null) {
            list = list.iterator();
            while (list.hasNext()) {
                LoginService s = (LoginService)list.next();
                if (s.getName() == null || !s.getName().equals(realm)) continue;
                service = s;
                break;
            }
        } else if (list.size() == 1) {
            void var1_1;
            service = (LoginService)var1_1.iterator().next();
        }
        return var2_2;
    }

    protected IdentityService findIdentityService() {
        return (IdentityService)this.getServer().getBean(IdentityService.class);
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        block19: {
            block20: {
                Iterator<Authenticator.Factory> iterator;
                ContextHandler.Context context = ContextHandler.getCurrentContext();
                if (context != null) {
                    Enumeration names = context.getInitParameterNames();
                    while (names != null && names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        if (!name.startsWith("org.eclipse.jetty.security.") || this.getInitParameter(name) != null) continue;
                        this.setInitParameter(name, context.getInitParameter(name));
                    }
                }
                if (this._loginService == null) {
                    SecurityHandler securityHandler = this;
                    securityHandler.setLoginService(securityHandler.findLoginService());
                    if (this._loginService != null) {
                        SecurityHandler securityHandler2 = this;
                        securityHandler2.unmanage(securityHandler2._loginService);
                    }
                }
                if (this._identityService == null) {
                    if (this._loginService != null) {
                        SecurityHandler securityHandler = this;
                        securityHandler.setIdentityService(securityHandler._loginService.getIdentityService());
                    }
                    if (this._identityService == null) {
                        SecurityHandler securityHandler = this;
                        securityHandler.setIdentityService(securityHandler.findIdentityService());
                    }
                    if (this._identityService == null) {
                        this.setIdentityService(new DefaultIdentityService());
                        SecurityHandler securityHandler = this;
                        securityHandler.manage(securityHandler._identityService);
                    } else {
                        SecurityHandler securityHandler = this;
                        securityHandler.unmanage(securityHandler._identityService);
                    }
                }
                if (this._loginService != null) {
                    if (this._loginService.getIdentityService() == null) {
                        this._loginService.setIdentityService(this._identityService);
                    } else if (this._loginService.getIdentityService() != this._identityService) {
                        throw new IllegalStateException("LoginService has different IdentityService to " + this);
                    }
                }
                if (this._authenticator != null) break block19;
                if (this._authenticatorFactory == null) break block20;
                SecurityHandler securityHandler = this;
                Authenticator authenticator = this._authenticatorFactory.getAuthenticator(this.getServer(), (ServletContext)ContextHandler.getCurrentContext(), securityHandler, securityHandler._identityService, this._loginService);
                if (authenticator == null) break block19;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created authenticator {} with {}", new Object[]{authenticator, this._authenticatorFactory});
                }
                this.setAuthenticator((Authenticator)((Object)iterator));
                break block19;
            }
            for (Authenticator.Factory factory : this.getKnownAuthenticatorFactories()) {
                void var1_1;
                SecurityHandler securityHandler = this;
                Authenticator authenticator = factory.getAuthenticator(this.getServer(), (ServletContext)ContextHandler.getCurrentContext(), securityHandler, securityHandler._identityService, this._loginService);
                if (authenticator == null) continue;
                if (LOG.isDebugEnabled()) {
                    void var3_3;
                    LOG.debug("Created authenticator {} with {}", new Object[]{authenticator, var3_3});
                }
                this.setAuthenticator((Authenticator)var1_1);
                break;
            }
        }
        if (this._authenticator != null) {
            this._authenticator.setConfiguration(this);
        } else if (this._realmName != null) {
            LOG.warn("No Authenticator for " + this, new Object[0]);
            throw new IllegalStateException("No Authenticator");
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SecurityHandler securityHandler = this;
        if (!securityHandler.isManaged(securityHandler._identityService)) {
            SecurityHandler securityHandler2 = this;
            securityHandler2.removeBean(securityHandler2._identityService);
            this._identityService = null;
        }
        SecurityHandler securityHandler3 = this;
        if (!securityHandler3.isManaged(securityHandler3._loginService)) {
            SecurityHandler securityHandler4 = this;
            securityHandler4.removeBean(securityHandler4._loginService);
            this._loginService = null;
        }
        super.doStop();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean checkSecurity(Request request) {
        switch (request.getDispatcherType()) {
            case REQUEST: 
            case ASYNC: {
                return true;
            }
            case FORWARD: {
                if (this.isCheckWelcomeFiles() && request.getAttribute("org.eclipse.jetty.server.welcome") != null) {
                    void var1_1;
                    var1_1.removeAttribute("org.eclipse.jetty.server.welcome");
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isSessionRenewedOnAuthentication() {
        return this._renewSession;
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionRenewedOnAuthentication(boolean renew) {
        void var1_1;
        this._renewSession = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void handle(String pathInContext, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block36: {
            void var3_5;
            void var2_4;
            void var1_1;
            Handler handler;
            block37: {
                block35: {
                    RoleInfo roleInfo;
                    Response base_response = baseRequest.getResponse();
                    handler = this.getHandler();
                    if (handler == null) {
                        return;
                    }
                    Authenticator authenticator = this._authenticator;
                    if (!this.checkSecurity(baseRequest)) break block37;
                    if (authenticator != null) {
                        authenticator.prepareRequest((ServletRequest)baseRequest);
                    }
                    if (!this.checkUserDataPermissions(pathInContext, baseRequest, base_response, roleInfo = this.prepareConstraintInfo(pathInContext, baseRequest))) {
                        if (!baseRequest.isHandled()) {
                            response.sendError(403);
                            baseRequest.setHandled(true);
                        }
                        return;
                    }
                    boolean isAuthMandatory = this.isAuthMandatory(baseRequest, base_response, roleInfo);
                    if (isAuthMandatory && authenticator == null) {
                        LOG.warn("No authenticator for: " + roleInfo, new Object[0]);
                        if (!baseRequest.isHandled()) {
                            response.sendError(403);
                            baseRequest.setHandled(true);
                        }
                        return;
                    }
                    Object previousIdentity = null;
                    try {
                        Authentication authentication = baseRequest.getAuthentication();
                        if (authentication == null || authentication == Authentication.NOT_CHECKED) {
                            Authentication authentication2 = authentication = authenticator == null ? Authentication.UNAUTHENTICATED : authenticator.validateRequest((ServletRequest)request, (ServletResponse)response, isAuthMandatory);
                        }
                        if (authentication instanceof Authentication.Wrapped) {
                            request = ((Authentication.Wrapped)authentication).getHttpServletRequest();
                            response = ((Authentication.Wrapped)authentication).getHttpServletResponse();
                        }
                        if (authentication instanceof Authentication.ResponseSent) {
                            baseRequest.setHandled(true);
                        } else if (authentication instanceof Authentication.User) {
                            Authentication.User userAuth = (Authentication.User)authentication;
                            baseRequest.setAuthentication(authentication);
                            if (this._identityService != null) {
                                previousIdentity = this._identityService.associate(userAuth.getUserIdentity());
                            }
                            if (isAuthMandatory && !(base_response = this.checkWebResourcePermissions(pathInContext, baseRequest, base_response, roleInfo, userAuth.getUserIdentity()))) {
                                response.sendError(403, "!role");
                                baseRequest.setHandled(true);
                                if (this._identityService != null) {
                                    this._identityService.disassociate(previousIdentity);
                                }
                                return;
                            }
                            handler.handle(pathInContext, baseRequest, request, response);
                            if (authenticator != null) {
                                authenticator.secureResponse((ServletRequest)request, (ServletResponse)response, isAuthMandatory, userAuth);
                            }
                        } else if (authentication instanceof Authentication.Deferred) {
                            DeferredAuthentication deferred = (DeferredAuthentication)authentication;
                            baseRequest.setAuthentication(authentication);
                            try {
                                handler.handle(pathInContext, baseRequest, request, response);
                            }
                            finally {
                                previousIdentity = deferred.getPreviousAssociation();
                            }
                            if (authenticator != null) {
                                Authentication auth = baseRequest.getAuthentication();
                                if (auth instanceof Authentication.User) {
                                    Authentication.User userAuth = (Authentication.User)auth;
                                    authenticator.secureResponse((ServletRequest)request, (ServletResponse)response, isAuthMandatory, (Authentication.User)var1_1);
                                } else {
                                    authenticator.secureResponse((ServletRequest)request, (ServletResponse)response, isAuthMandatory, null);
                                }
                            }
                        } else if (isAuthMandatory) {
                            response.sendError(401, "unauthenticated");
                            baseRequest.setHandled(true);
                        } else {
                            baseRequest.setAuthentication(authentication);
                            if (this._identityService != null) {
                                previousIdentity = this._identityService.associate(null);
                            }
                            handler.handle((String)var1_1, baseRequest, request, response);
                            if (authenticator != null) {
                                authenticator.secureResponse((ServletRequest)request, (ServletResponse)response, isAuthMandatory, null);
                            }
                        }
                        if (this._identityService == null) break block35;
                    }
                    catch (ServerAuthException e) {
                        response.sendError(500, e.getMessage());
                        break block36;
                    }
                    finally {
                        if (this._identityService == null) break block35;
                        this._identityService.disassociate(previousIdentity);
                    }
                    this._identityService.disassociate(previousIdentity);
                    break block36;
                }
                return;
            }
            handler.handle((String)var1_1, (Request)var2_4, (HttpServletRequest)var3_5, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static SecurityHandler getCurrentSecurityHandler() {
        void var0;
        ContextHandler.Context context = ContextHandler.getCurrentContext();
        if (context == null) {
            return null;
        }
        return (SecurityHandler)var0.getContextHandler().getChildHandlerByClass(SecurityHandler.class);
    }

    /*
     * WARNING - void declaration
     */
    public void logout(Authentication.User user) {
        IdentityService identityService;
        LOG.debug("logout {}", new Object[]{user});
        if (user == null) {
            return;
        }
        LoginService loginService = this.getLoginService();
        if (loginService != null) {
            void var2_2;
            var2_2.logout(user.getUserIdentity());
        }
        if ((identityService = this.getIdentityService()) != null) {
            void var1_1;
            var1_1.disassociate(null);
        }
    }

    protected abstract RoleInfo prepareConstraintInfo(String var1, Request var2);

    protected abstract boolean checkUserDataPermissions(String var1, Request var2, Response var3, RoleInfo var4) throws IOException;

    protected abstract boolean isAuthMandatory(Request var1, Response var2, Object var3);

    protected abstract boolean checkWebResourcePermissions(String var1, Request var2, Response var3, Object var4, UserIdentity var5) throws IOException;

    /*
     * WARNING - void declaration
     */
    static {
        Iterator<Authenticator.Factory> serviceLoaderIterator = ServiceLoader.load(Authenticator.Factory.class).iterator();
        while (true) {
            try {
                while (serviceLoaderIterator.hasNext()) {
                    __knownAuthenticatorFactories.add(serviceLoaderIterator.next());
                }
            }
            catch (ServiceConfigurationError error) {
                void var1_1;
                LOG.warn("Error while loading AuthenticatorFactory with ServiceLoader", (Throwable)var1_1);
                continue;
            }
            break;
        }
        __knownAuthenticatorFactories.add(new DefaultAuthenticatorFactory());
        __NO_USER = new Principal(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String toString() {
                return "No User";
            }
        };
        __NOBODY = new Principal(){

            @Override
            public String getName() {
                return "Nobody";
            }

            @Override
            public String toString() {
                return this.getName();
            }
        };
    }

    public class NotChecked
    implements Principal {
        final /* synthetic */ SecurityHandler this$0;

        /*
         * WARNING - void declaration
         */
        public NotChecked(SecurityHandler this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return this.this$0;
        }
    }
}

