/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jetty.security.UserDataConstraint;

public class RoleInfo {
    private boolean _isAnyAuth;
    private boolean _isAnyRole;
    private boolean _checked;
    private boolean _forbidden;
    private UserDataConstraint _userDataConstraint;
    private final Set<String> _roles = new CopyOnWriteArraySet<String>();

    public boolean isChecked() {
        return this._checked;
    }

    /*
     * WARNING - void declaration
     */
    public void setChecked(boolean checked) {
        void var1_1;
        this._checked = checked;
        if (var1_1 == false) {
            this._forbidden = false;
            this._roles.clear();
            this._isAnyRole = false;
            this._isAnyAuth = false;
        }
    }

    public boolean isForbidden() {
        return this._forbidden;
    }

    /*
     * WARNING - void declaration
     */
    public void setForbidden(boolean forbidden) {
        void var1_1;
        this._forbidden = forbidden;
        if (var1_1 != false) {
            this._checked = true;
            this._userDataConstraint = null;
            this._isAnyRole = false;
            this._isAnyAuth = false;
            this._roles.clear();
        }
    }

    public boolean isAnyRole() {
        return this._isAnyRole;
    }

    /*
     * WARNING - void declaration
     */
    public void setAnyRole(boolean anyRole) {
        void var1_1;
        this._isAnyRole = anyRole;
        if (var1_1 != false) {
            this._checked = true;
        }
    }

    public boolean isAnyAuth() {
        return this._isAnyAuth;
    }

    /*
     * WARNING - void declaration
     */
    public void setAnyAuth(boolean anyAuth) {
        void var1_1;
        this._isAnyAuth = anyAuth;
        if (var1_1 != false) {
            this._checked = true;
        }
    }

    public UserDataConstraint getUserDataConstraint() {
        return this._userDataConstraint;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserDataConstraint(UserDataConstraint userDataConstraint) {
        void var1_1;
        if (userDataConstraint == null) {
            throw new NullPointerException("Null UserDataConstraint");
        }
        if (this._userDataConstraint == null) {
            this._userDataConstraint = userDataConstraint;
            return;
        }
        this._userDataConstraint = this._userDataConstraint.combine((UserDataConstraint)var1_1);
    }

    public Set<String> getRoles() {
        return this._roles;
    }

    /*
     * WARNING - void declaration
     */
    public void addRole(String role) {
        void var1_1;
        this._roles.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void combine(RoleInfo other) {
        void var1_1;
        if (other._forbidden) {
            this.setForbidden(true);
        } else if (other._checked) {
            this.setChecked(true);
            if (other._isAnyAuth) {
                this.setAnyAuth(true);
            }
            if (other._isAnyRole) {
                this.setAnyRole(true);
            }
            this._roles.addAll(other._roles);
        }
        this.setUserDataConstraint(var1_1._userDataConstraint);
    }

    public String toString() {
        return String.format("RoleInfo@%x{%s%s%s%s,%s}", new Object[]{this.hashCode(), this._forbidden ? "Forbidden," : "", this._checked ? "Checked," : "", this._isAnyAuth ? "AnyAuth," : "", this._isAnyRole ? "*" : this._roles, this._userDataConstraint});
    }
}

