/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.PathWatcher;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarFileResource;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class PropertyUserStore
extends UserStore
implements PathWatcher.Listener {
    private static final Logger LOG = Log.getLogger(PropertyUserStore.class);
    protected Path _configPath;
    protected PathWatcher _pathWatcher;
    protected boolean _hotReload = false;
    protected boolean _firstLoad = true;
    protected List<UserListener> _listeners;

    public String getConfig() {
        if (this._configPath != null) {
            return this._configPath.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfig(String config) {
        block6: {
            if (config == null) {
                this._configPath = null;
                return;
            }
            try {
                void var1_1;
                Resource configResource = Resource.newResource((String)config);
                if (configResource instanceof JarFileResource) {
                    this._configPath = this.extractPackedFile((JarFileResource)configResource);
                    break block6;
                }
                if (configResource instanceof PathResource) {
                    this._configPath = ((PathResource)configResource).getPath();
                    break block6;
                }
                if (configResource.getFile() != null) {
                    this.setConfigFile(configResource.getFile());
                    break block6;
                }
                throw new IllegalArgumentException((String)var1_1);
            }
            catch (Exception e) {
                void var2_3;
                this._configPath = null;
                throw new IllegalStateException((Throwable)var2_3);
            }
        }
    }

    public Path getConfigPath() {
        return this._configPath;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setConfigPath(String configFile) {
        void var1_1;
        this.setConfig((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Path extractPackedFile(JarFileResource configResource) throws IOException {
        void var2_2;
        void var3_4;
        String uri = configResource.getURI().toASCIIString();
        int colon = uri.lastIndexOf(":");
        int bangSlash = uri.indexOf("!/");
        if (colon < 0 || bangSlash < 0 || colon > bangSlash) {
            throw new IllegalArgumentException("Not resolved JarFile resource: " + uri);
        }
        String entryPath = StringUtil.sanitizeFileSystemName((String)uri.substring(colon + 2));
        Path tmpDirectory = Files.createTempDirectory("users_store", new FileAttribute[0]);
        tmpDirectory.toFile().deleteOnExit();
        Path extractedPath = Paths.get(var3_4.toString(), entryPath);
        Files.deleteIfExists(extractedPath);
        extractedPath.toFile().deleteOnExit();
        IO.copy((InputStream)configResource.getInputStream(), (OutputStream)new FileOutputStream(extractedPath.toFile()));
        if (this.isHotReload()) {
            void var1_1;
            LOG.warn("Cannot hot reload from packed configuration: {}", new Object[]{var1_1});
            this.setHotReload(false);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setConfigPath(File configFile) {
        void var1_1;
        this.setConfigFile((File)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigFile(File configFile) {
        void var1_1;
        if (configFile == null) {
            this._configPath = null;
            return;
        }
        this._configPath = var1_1.toPath();
    }

    /*
     * WARNING - void declaration
     */
    public void setConfigPath(Path configPath) {
        void var1_1;
        this._configPath = var1_1;
    }

    public Resource getConfigResource() {
        if (this._configPath == null) {
            return null;
        }
        return new PathResource(this._configPath);
    }

    public boolean isHotReload() {
        return this._hotReload;
    }

    /*
     * WARNING - void declaration
     */
    public void setHotReload(boolean enable) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this._hotReload = var1_1;
    }

    public String toString() {
        return String.format("%s@%x[users.count=%d,identityService=%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getKnownUserIdentities().size(), this.getIdentityService());
    }

    /*
     * WARNING - void declaration
     */
    protected void loadUsers() throws IOException {
        Resource config;
        if (this._configPath == null) {
            throw new IllegalStateException("No config path set");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading {} from {}", new Object[]{this, this._configPath});
        }
        if (!(config = this.getConfigResource()).exists()) {
            throw new IllegalStateException("Config does not exist: " + config);
        }
        Properties properties = new Properties();
        properties.load(config.getInputStream());
        HashSet<String> known = new HashSet<String>();
        for (Map.Entry entry : properties.entrySet()) {
            void var3_7;
            String username = ((String)entry.getKey()).trim();
            String string = ((String)entry.getValue()).trim();
            String roles = null;
            int c = string.indexOf(44);
            if (c >= 0) {
                roles = string.substring(c + 1).trim();
                String string2 = string.substring(0, c).trim();
            }
            if (username.length() <= 0) continue;
            String[] roleArray = IdentityService.NO_ROLES;
            if (roles != null && roles.length() > 0) {
                roleArray = StringUtil.csvSplit((String)roles);
            }
            known.add(username);
            Credential credential = Credential.getCredential((String)var3_7);
            this.addUser(username, credential, roleArray);
            this.notifyUpdate(username, credential, roleArray);
        }
        ArrayList<String> currentlyKnownUsers = new ArrayList<String>(this.getKnownUserIdentities().keySet());
        if (!this._firstLoad) {
            void var2_2;
            for (String user : var2_2) {
                if (known.contains(user)) continue;
                this.removeUser(user);
                this.notifyRemove(user);
            }
        }
        this._firstLoad = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loaded " + (Object)((Object)this) + " from " + this._configPath, new Object[0]);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.loadUsers();
        if (this.isHotReload() && this._configPath != null) {
            this._pathWatcher = new PathWatcher();
            this._pathWatcher.watch(this._configPath);
            this._pathWatcher.addListener((EventListener)((Object)this));
            this._pathWatcher.setNotifyExistingOnStart(false);
            this._pathWatcher.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onPathWatchEvent(PathWatcher.PathWatchEvent event) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path watch event: {}", new Object[]{event.getType()});
            }
            this.loadUsers();
            return;
        }
        catch (IOException e) {
            void var1_2;
            LOG.warn((Throwable)var1_2);
            return;
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._pathWatcher != null) {
            this._pathWatcher.stop();
        }
        this._pathWatcher = null;
    }

    private void notifyUpdate(String username, Credential credential, String[] roleArray) {
        if (this._listeners != null) {
            for (UserListener userListener : this._listeners) {
                userListener.update(username, credential, roleArray);
            }
        }
    }

    private void notifyRemove(String username) {
        if (this._listeners != null) {
            for (UserListener userListener : this._listeners) {
                userListener.remove(username);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerUserListener(UserListener listener) {
        void var1_1;
        if (this._listeners == null) {
            this._listeners = new ArrayList<UserListener>();
        }
        this._listeners.add((UserListener)var1_1);
    }

    public static interface UserListener {
        public void update(String var1, Credential var2, String[] var3);

        public void remove(String var1);
    }
}

