/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class JDBCLoginService
extends AbstractLoginService {
    private static final Logger LOG = Log.getLogger(JDBCLoginService.class);
    protected String _config;
    protected String _jdbcDriver;
    protected String _url;
    protected String _userName;
    protected String _password;
    protected String _userTableKey;
    protected String _userTablePasswordField;
    protected String _roleTableRoleField;
    protected Connection _con;
    protected String _userSql;
    protected String _roleSql;

    public JDBCLoginService() throws IOException {
    }

    /*
     * WARNING - void declaration
     */
    public JDBCLoginService(String name) throws IOException {
        void var1_1;
        this.setName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public JDBCLoginService(String name, String config) throws IOException {
        void var2_2;
        void var1_1;
        this.setName((String)var1_1);
        this.setConfig((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public JDBCLoginService(String name, IdentityService identityService, String config) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setName((String)var1_1);
        this.setIdentityService((IdentityService)var2_2);
        this.setConfig((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        void var1_1;
        void var3_4;
        Properties properties = new Properties();
        Resource resource = Resource.newResource((String)this._config);
        try (InputStream in = resource.getInputStream();){
            properties.load(in);
        }
        this._jdbcDriver = properties.getProperty("jdbcdriver");
        this._url = properties.getProperty("url");
        this._userName = properties.getProperty("username");
        this._password = properties.getProperty("password");
        String userTable = properties.getProperty("usertable");
        this._userTableKey = properties.getProperty("usertablekey");
        String userTableUserField = properties.getProperty("usertableuserfield");
        this._userTablePasswordField = properties.getProperty("usertablepasswordfield");
        String roleTable = properties.getProperty("roletable");
        String roleTableKey = properties.getProperty("roletablekey");
        this._roleTableRoleField = properties.getProperty("roletablerolefield");
        String userRoleTable = properties.getProperty("userroletable");
        String userRoleTableUserKey = properties.getProperty("userroletableuserkey");
        String userRoleTableRoleKey = properties.getProperty("userroletablerolekey");
        if (this._jdbcDriver == null || this._jdbcDriver.equals("") || this._url == null || this._url.equals("") || this._userName == null || this._userName.equals("") || this._password == null) {
            LOG.warn("UserRealm " + this.getName() + " has not been properly configured", new Object[0]);
        }
        this._userSql = "select " + this._userTableKey + "," + this._userTablePasswordField + " from " + (String)resource + " where " + (String)var3_4 + " = ?";
        this._roleSql = "select r." + this._roleTableRoleField + " from " + roleTable + " r, " + userRoleTable + " u where u." + userRoleTableUserKey + " = ? and r." + roleTableKey + " = u." + (String)var1_1;
        Loader.loadClass((String)this._jdbcDriver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        super.doStart();
    }

    public String getConfig() {
        return this._config;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfig(String config) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._config = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void connectDatabase() {
        try {
            Class.forName(this._jdbcDriver);
            this._con = DriverManager.getConnection(this._url, this._userName, this._password);
            return;
        }
        catch (SQLException e) {
            LOG.warn("UserRealm " + this.getName() + " could not connect to database; will try later", (Throwable)e);
            return;
        }
        catch (ClassNotFoundException e) {
            void var1_2;
            LOG.warn("UserRealm " + this.getName() + " could not connect to database; will try later", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AbstractLoginService.UserPrincipal loadUserInfo(String username) {
        try {
            if (this._con == null) {
                this.connectDatabase();
            }
            if (this._con == null) {
                throw new SQLException("Can't connect to database");
            }
            try (PreparedStatement stat1 = this._con.prepareStatement(this._userSql);){
                ResultSet rs1;
                block15: {
                    JDBCUserPrincipal jDBCUserPrincipal;
                    stat1.setObject(1, username);
                    rs1 = stat1.executeQuery();
                    try {
                        if (!rs1.next()) break block15;
                        int key = rs1.getInt(this._userTableKey);
                        String credentials = rs1.getString(this._userTablePasswordField);
                        jDBCUserPrincipal = new JDBCUserPrincipal(this, (String)((Object)jDBCUserPrincipal), Credential.getCredential((String)credentials), key);
                        if (rs1 == null) return jDBCUserPrincipal;
                    }
                    catch (Throwable throwable) {
                        if (rs1 == null) throw throwable;
                        try {
                            void var3_4;
                            var3_4.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    rs1.close();
                    return jDBCUserPrincipal;
                }
                if (rs1 == null) return null;
                rs1.close();
                return null;
            }
        }
        catch (SQLException e) {
            void var2_3;
            LOG.warn("UserRealm " + this.getName() + " could not load user information from database", (Throwable)var2_3);
            this.closeConnection();
        }
        return null;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    @Override
    public String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
        ResultSet rs2;
        PreparedStatement stat2;
        String[] roles22222222;
        block18: {
            block17: {
                JDBCUserPrincipal jdbcUser = (JDBCUserPrincipal)user;
                if (this._con == null) {
                    this.connectDatabase();
                }
                if (this._con == null) {
                    throw new SQLException("Can't connect to database");
                }
                roles22222222 = new ArrayList();
                stat2 = this._con.prepareStatement(this._roleSql);
                stat2.setInt(1, jdbcUser.getUserKey());
                rs2 = stat2.executeQuery();
                while (rs2.next()) {
                    roles22222222.add(rs2.getString(this._roleTableRoleField));
                }
                roles22222222 = roles22222222.toArray(new String[roles22222222.size()]);
                if (rs2 == null) break block17;
                rs2.close();
            }
            if (stat2 == null) break block18;
            stat2.close();
        }
        return roles22222222;
        {
            catch (Throwable roles22222222) {
                try {
                    try {
                        if (rs2 != null) {
                            try {
                                void var1_1;
                                var1_1.close();
                            }
                            catch (Throwable throwable) {
                                roles22222222.addSuppressed(throwable);
                            }
                        }
                        throw roles22222222;
                    }
                    catch (Throwable throwable) {
                        if (stat2 != null) {
                            try {
                                void var3_8;
                                var3_8.close();
                            }
                            catch (Throwable roles22222222) {
                                throwable.addSuppressed(roles22222222);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    void var2_7;
                    LOG.warn("UserRealm " + this.getName() + " could not load user information from database", (Throwable)var2_7);
                    this.closeConnection();
                    return null;
                }
            }
        }
    }

    protected void doStop() throws Exception {
        this.closeConnection();
        super.doStop();
    }

    /*
     * WARNING - void declaration
     */
    private void closeConnection() {
        if (this._con != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing db connection for JDBCUserRealm", new Object[0]);
            }
            try {
                this._con.close();
            }
            catch (Exception e) {
                void var1_1;
                LOG.ignore((Throwable)var1_1);
            }
        }
        this._con = null;
    }

    public class JDBCUserPrincipal
    extends AbstractLoginService.UserPrincipal {
        int _userKey;
        final /* synthetic */ JDBCLoginService this$0;

        /*
         * WARNING - void declaration
         */
        public JDBCUserPrincipal(JDBCLoginService this$0, String name, Credential credential, int key) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((String)var2_2, (Credential)var3_3);
            this._userKey = key;
        }

        public int getUserKey() {
            return this._userKey;
        }
    }
}

