/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class HashLoginService
extends AbstractLoginService {
    private static final Logger LOG = Log.getLogger(HashLoginService.class);
    private String _config;
    private boolean hotReload = false;
    private UserStore _userStore;
    private boolean _userStoreAutoCreate = false;

    public HashLoginService() {
    }

    /*
     * WARNING - void declaration
     */
    public HashLoginService(String name) {
        void var1_1;
        this.setName((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HashLoginService(String name, String config) {
        void var2_2;
        void var1_1;
        this.setName((String)var1_1);
        this.setConfig((String)var2_2);
    }

    public String getConfig() {
        return this._config;
    }

    @Deprecated
    public Resource getConfigResource() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setConfig(String config) {
        void var1_1;
        this._config = var1_1;
    }

    public boolean isHotReload() {
        return this.hotReload;
    }

    /*
     * WARNING - void declaration
     */
    public void setHotReload(boolean enable) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this.hotReload = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserStore(UserStore userStore) {
        void var1_1;
        HashLoginService hashLoginService = this;
        hashLoginService.updateBean((Object)hashLoginService._userStore, (Object)userStore);
        this._userStore = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String[] loadRoleInfo(AbstractLoginService.UserPrincipal user) {
        void var1_1;
        UserIdentity id = this._userStore.getUserIdentity(user.getName());
        if (id == null) {
            return null;
        }
        Set<AbstractLoginService.RolePrincipal> roles = id.getSubject().getPrincipals(AbstractLoginService.RolePrincipal.class);
        if (roles == null) {
            return null;
        }
        List<String> list = roles.stream().map(rolePrincipal -> rolePrincipal.getName()).collect(Collectors.toList());
        return list.toArray(new String[var1_1.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AbstractLoginService.UserPrincipal loadUserInfo(String userName) {
        UserIdentity id = this._userStore.getUserIdentity(userName);
        if (id != null) {
            void var1_1;
            return (AbstractLoginService.UserPrincipal)var1_1.getUserPrincipal();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        super.doStart();
        if (this._userStore == null) {
            void var1_1;
            if (LOG.isDebugEnabled()) {
                LOG.debug("doStart: Starting new PropertyUserStore. PropertiesFile: " + this._config + " hotReload: " + this.hotReload, new Object[0]);
            }
            PropertyUserStore propertyUserStore = new PropertyUserStore();
            propertyUserStore.setHotReload(this.hotReload);
            propertyUserStore.setConfigPath(this._config);
            this.setUserStore((UserStore)var1_1);
            this._userStoreAutoCreate = true;
        }
    }

    UserStore getUserStore() {
        return this._userStore;
    }

    boolean isUserStoreAutoCreate() {
        return this._userStoreAutoCreate;
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this._userStoreAutoCreate) {
            this.setUserStore(null);
            this._userStoreAutoCreate = false;
        }
    }
}

