/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.ServletRequest;
import javax.servlet.ServletSecurityElement;
import javax.servlet.annotation.ServletSecurity;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserDataConstraint;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Constraint;

public class ConstraintSecurityHandler
extends SecurityHandler
implements ConstraintAware {
    private static final Logger LOG = Log.getLogger(SecurityHandler.class);
    private static final String OMISSION_SUFFIX = ".omission";
    private static final String ALL_METHODS = "*";
    private final List<ConstraintMapping> _constraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final List<ConstraintMapping> _durableConstraintMappings = new CopyOnWriteArrayList<ConstraintMapping>();
    private final Set<String> _roles = new CopyOnWriteArraySet<String>();
    private final PathMap<Map<String, RoleInfo>> _constraintMap = new PathMap();
    private boolean _denyUncoveredMethods = false;

    public static Constraint createConstraint() {
        return new Constraint();
    }

    /*
     * WARNING - void declaration
     */
    public static Constraint createConstraint(Constraint constraint) {
        try {
            return (Constraint)constraint.clone();
        }
        catch (CloneNotSupportedException e) {
            void var0_1;
            throw new IllegalStateException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Constraint createConstraint(String name, boolean authenticate, String[] roles, int dataConstraint) {
        void var3_3;
        void var2_2;
        void var1_1;
        Constraint constraint = ConstraintSecurityHandler.createConstraint();
        if (name != null) {
            String string;
            constraint.setName(string);
        }
        constraint.setAuthenticate((boolean)var1_1);
        constraint.setRoles((String[])var2_2);
        constraint.setDataConstraint((int)var3_3);
        return constraint;
    }

    /*
     * WARNING - void declaration
     */
    public static Constraint createConstraint(String name, HttpConstraintElement element) {
        void var1_1;
        return ConstraintSecurityHandler.createConstraint(name, element.getRolesAllowed(), element.getEmptyRoleSemantic(), var1_1.getTransportGuarantee());
    }

    /*
     * WARNING - void declaration
     */
    public static Constraint createConstraint(String name, String[] rolesAllowed, ServletSecurity.EmptyRoleSemantic permitOrDeny, ServletSecurity.TransportGuarantee transport) {
        void var3_3;
        Constraint constraint = ConstraintSecurityHandler.createConstraint();
        if (rolesAllowed == null || rolesAllowed.length == 0) {
            void var2_2;
            if (var2_2.equals((Object)ServletSecurity.EmptyRoleSemantic.DENY)) {
                constraint.setName(name + "-Deny");
                constraint.setAuthenticate(true);
            } else {
                constraint.setName(name + "-Permit");
                constraint.setAuthenticate(false);
            }
        } else {
            String string;
            void var1_1;
            constraint.setAuthenticate(true);
            constraint.setRoles((String[])var1_1);
            constraint.setName(string + "-RolesAllowed");
        }
        constraint.setDataConstraint(var3_3.equals((Object)ServletSecurity.TransportGuarantee.CONFIDENTIAL) ? 2 : 0);
        return constraint;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ConstraintMapping> getConstraintMappingsForPath(String pathSpec, List<ConstraintMapping> constraintMappings) {
        void var2_2;
        Iterator iterator;
        if (pathSpec == null || "".equals(pathSpec.trim()) || constraintMappings == null || constraintMappings.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<void> mappings = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            ConstraintMapping mapping = (ConstraintMapping)iterator.next();
            if (!pathSpec.equals(mapping.getPathSpec())) continue;
            mappings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ConstraintMapping> removeConstraintMappingsForPath(String pathSpec, List<ConstraintMapping> constraintMappings) {
        void var2_2;
        Iterator iterator;
        if (pathSpec == null || "".equals(pathSpec.trim()) || constraintMappings == null || constraintMappings.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<void> mappings = new ArrayList<void>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            ConstraintMapping mapping = (ConstraintMapping)iterator.next();
            if (pathSpec.equals(mapping.getPathSpec())) continue;
            mappings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static List<ConstraintMapping> createConstraintsWithMappingsForPath(String name, String pathSpec, ServletSecurityElement securityElement) {
        void var3_3;
        ArrayList<ConstraintMapping> mappings = new ArrayList<ConstraintMapping>();
        ConstraintMapping httpConstraintMapping = null;
        if (securityElement.getEmptyRoleSemantic() != ServletSecurity.EmptyRoleSemantic.PERMIT || securityElement.getRolesAllowed().length != 0 || securityElement.getTransportGuarantee() != ServletSecurity.TransportGuarantee.NONE) {
            Constraint httpConstraint = ConstraintSecurityHandler.createConstraint(name, (HttpConstraintElement)securityElement);
            httpConstraintMapping = new ConstraintMapping();
            httpConstraintMapping.setPathSpec(pathSpec);
            httpConstraintMapping.setConstraint(httpConstraint);
            mappings.add(httpConstraintMapping);
        }
        ArrayList<String> methodOmissions = new ArrayList<String>();
        Collection methodConstraintElements = securityElement.getHttpMethodConstraints();
        if (methodConstraintElements != null) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                HttpMethodConstraintElement methodConstraintElement = (HttpMethodConstraintElement)iterator.next();
                Constraint methodConstraint = ConstraintSecurityHandler.createConstraint(name, (HttpConstraintElement)methodConstraintElement);
                ConstraintMapping mapping = new ConstraintMapping();
                mapping.setConstraint(methodConstraint);
                mapping.setPathSpec(pathSpec);
                if (methodConstraintElement.getMethodName() != null) {
                    mapping.setMethod(methodConstraintElement.getMethodName());
                    methodOmissions.add(methodConstraintElement.getMethodName());
                }
                mappings.add(mapping);
            }
        }
        if (methodOmissions.size() > 0 && httpConstraintMapping != null) {
            httpConstraintMapping.setMethodOmissions(methodOmissions.toArray(new String[0]));
        }
        return var3_3;
    }

    @Override
    public List<ConstraintMapping> getConstraintMappings() {
        return this._constraintMappings;
    }

    @Override
    public Set<String> getRoles() {
        return this._roles;
    }

    /*
     * WARNING - void declaration
     */
    public void setConstraintMappings(List<ConstraintMapping> constraintMappings) {
        void var1_1;
        this.setConstraintMappings((List<ConstraintMapping>)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void setConstraintMappings(ConstraintMapping[] constraintMappings) {
        void var1_1;
        this.setConstraintMappings(Arrays.asList(var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConstraintMappings(List<ConstraintMapping> constraintMappings, Set<String> roles) {
        void var2_2;
        this._constraintMappings.clear();
        this._constraintMappings.addAll(constraintMappings);
        this._durableConstraintMappings.clear();
        if (this.isInDurableState()) {
            this._durableConstraintMappings.addAll(constraintMappings);
        }
        if (roles == null) {
            Iterator iterator;
            roles = new HashSet<String>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ConstraintMapping constraintMapping = (ConstraintMapping)iterator.next();
                String[] cmr = constraintMapping.getConstraint().getRoles();
                if (cmr == null) continue;
                for (ConstraintMapping r : constraintMapping) {
                    if (ALL_METHODS.equals(r)) continue;
                    roles.add((String)((Object)r));
                }
            }
        }
        this.setRoles((Set<String>)var2_2);
        if (this.isStarted()) {
            this._constraintMappings.stream().forEach(m -> {
                void var1_1;
                this.processConstraintMapping((ConstraintMapping)var1_1);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRoles(Set<String> roles) {
        void var1_1;
        this._roles.clear();
        this._roles.addAll((Collection<String>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addConstraintMapping(ConstraintMapping mapping) {
        this._constraintMappings.add(mapping);
        if (this.isInDurableState()) {
            this._durableConstraintMappings.add(mapping);
        }
        if (mapping.getConstraint() != null && mapping.getConstraint().getRoles() != null) {
            for (String role : mapping.getConstraint().getRoles()) {
                if (ALL_METHODS.equals(role) || "**".equals(role)) continue;
                this.addRole(role);
            }
        }
        if (this.isStarted()) {
            void var1_1;
            this.processConstraintMapping((ConstraintMapping)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addRole(String role) {
        void var2_2;
        boolean modified = this._roles.add(role);
        if (this.isStarted() && var2_2 != false) {
            for (Object object : this._constraintMap.values()) {
                for (RoleInfo info : object.values()) {
                    if (!info.isAnyRole()) continue;
                    info.addRole(role);
                }
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._constraintMappings.stream().forEach(m -> {
            void var1_1;
            this.processConstraintMapping((ConstraintMapping)var1_1);
        });
        this.checkPathsWithUncoveredHttpMethods();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._constraintMap.clear();
        this._constraintMappings.clear();
        this._constraintMappings.addAll(this._durableConstraintMappings);
    }

    /*
     * WARNING - void declaration
     */
    protected void processConstraintMapping(ConstraintMapping mapping) {
        void var1_1;
        RoleInfo roleInfo;
        RoleInfo allMethodsRoleInfo;
        HashMap<String, RoleInfo> mappings = (HashMap<String, RoleInfo>)this._constraintMap.get((Object)mapping.getPathSpec());
        if (mappings == null) {
            mappings = new HashMap<String, RoleInfo>();
            this._constraintMap.put(mapping.getPathSpec(), mappings);
        }
        if ((allMethodsRoleInfo = (RoleInfo)mappings.get(ALL_METHODS)) != null && allMethodsRoleInfo.isForbidden()) {
            return;
        }
        if (mapping.getMethodOmissions() != null && mapping.getMethodOmissions().length > 0) {
            this.processConstraintMappingWithMethodOmissions(mapping, mappings);
            return;
        }
        String httpMethod = mapping.getMethod();
        if (httpMethod == null) {
            httpMethod = ALL_METHODS;
        }
        if ((roleInfo = (RoleInfo)mappings.get(httpMethod)) == null) {
            roleInfo = new RoleInfo();
            mappings.put(httpMethod, roleInfo);
            if (allMethodsRoleInfo != null) {
                void var3_3;
                roleInfo.combine((RoleInfo)var3_3);
            }
        }
        if (roleInfo.isForbidden()) {
            return;
        }
        this.configureRoleInfo(roleInfo, (ConstraintMapping)var1_1);
        if (roleInfo.isForbidden() && httpMethod.equals(ALL_METHODS)) {
            void var2_2;
            mappings.clear();
            var2_2.put(ALL_METHODS, roleInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void processConstraintMappingWithMethodOmissions(ConstraintMapping mapping, Map<String, RoleInfo> mappings) {
        void var1_1;
        void var2_2;
        String[] omissions = mapping.getMethodOmissions();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < omissions.length; ++i) {
            if (i > 0) {
                sb.append(".");
            }
            sb.append(omissions[i]);
        }
        sb.append(OMISSION_SUFFIX);
        RoleInfo ri = new RoleInfo();
        var2_2.put(sb.toString(), ri);
        this.configureRoleInfo(ri, (ConstraintMapping)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void configureRoleInfo(RoleInfo ri, ConstraintMapping mapping) {
        Constraint constraint = ((ConstraintMapping)mapping).getConstraint();
        boolean forbidden = constraint.isForbidden();
        ri.setForbidden(forbidden);
        UserDataConstraint userDataConstraint = UserDataConstraint.get(((ConstraintMapping)mapping).getConstraint().getDataConstraint());
        ri.setUserDataConstraint(userDataConstraint);
        if (!ri.isForbidden()) {
            boolean checked = ((ConstraintMapping)mapping).getConstraint().getAuthenticate();
            ri.setChecked(checked);
            if (ri.isChecked()) {
                String[] stringArray;
                if (((ConstraintMapping)mapping).getConstraint().isAnyRole()) {
                    for (String role : this._roles) {
                        void var3_8;
                        ri.addRole((String)var3_8);
                    }
                    ri.setAnyRole(true);
                    return;
                }
                if (((ConstraintMapping)mapping).getConstraint().isAnyAuth()) {
                    ri.setAnyAuth(true);
                    return;
                }
                String[] stringArray2 = stringArray = stringArray.getConstraint().getRoles();
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String role = stringArray2[i];
                    if (!this._roles.contains(role)) {
                        throw new IllegalArgumentException("Attempt to use undeclared role: " + role + ", known roles: " + this._roles);
                    }
                    ri.addRole(role);
                }
            }
        }
    }

    @Override
    protected RoleInfo prepareConstraintInfo(String pathInContext, Request request) {
        Map mappings = (Map)this._constraintMap.match(pathInContext);
        if (mappings != null) {
            RoleInfo roleInfo;
            String httpMethod = request.getMethod();
            RoleInfo roleInfo2 = (RoleInfo)mappings.get(httpMethod);
            if (roleInfo2 == null) {
                Iterator iterator;
                ArrayList<Object> applicableConstraints = new ArrayList<Object>();
                RoleInfo all = (RoleInfo)mappings.get(ALL_METHODS);
                if (all != null) {
                    applicableConstraints.add(roleInfo);
                }
                for (Map.Entry entry : iterator.entrySet()) {
                    if (entry.getKey() == null || !((String)entry.getKey()).endsWith(OMISSION_SUFFIX) || ((String)entry.getKey()).contains(httpMethod)) continue;
                    applicableConstraints.add((RoleInfo)entry.getValue());
                }
                if (applicableConstraints.size() == 0 && this.isDenyUncoveredHttpMethods()) {
                    roleInfo = new RoleInfo();
                    roleInfo.setForbidden(true);
                } else if (applicableConstraints.size() == 1) {
                    roleInfo = (RoleInfo)applicableConstraints.get(0);
                } else {
                    roleInfo = new RoleInfo();
                    roleInfo.setUserDataConstraint(UserDataConstraint.None);
                    for (RoleInfo roleInfo3 : applicableConstraints) {
                        roleInfo.combine(roleInfo3);
                    }
                }
            }
            return roleInfo;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, RoleInfo roleInfo) throws IOException {
        void var1_1;
        if (roleInfo == null) {
            return true;
        }
        if (roleInfo.isForbidden()) {
            return false;
        }
        UserDataConstraint dataConstraint = roleInfo.getUserDataConstraint();
        if (dataConstraint == null || dataConstraint == UserDataConstraint.None) {
            return true;
        }
        roleInfo = Request.getBaseRequest((ServletRequest)request);
        HttpConfiguration httpConfig = roleInfo.getHttpChannel().getHttpConfiguration();
        if (dataConstraint == UserDataConstraint.Confidential || dataConstraint == UserDataConstraint.Integral) {
            void var2_2;
            if (request.isSecure()) {
                return true;
            }
            if (httpConfig.getSecurePort() > 0) {
                String scheme = httpConfig.getSecureScheme();
                int port = httpConfig.getSecurePort();
                String url = URIUtil.newURI((String)scheme, (String)request.getServerName(), (int)port, (String)request.getRequestURI(), (String)request.getQueryString());
                response.setContentLength(0);
                response.sendRedirect((String)var1_1, true);
            } else {
                void var3_3;
                var3_3.sendError(403, "!Secure");
            }
            var2_2.setHandled(true);
            return false;
        }
        throw new IllegalArgumentException("Invalid dataConstraint value: " + var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isAuthMandatory(Request baseRequest, Response baseResponse, Object constraintInfo) {
        void var3_3;
        return constraintInfo != null && ((RoleInfo)var3_3).isChecked();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) throws IOException {
        void var3_4;
        void var2_2;
        void var1_1;
        if (constraintInfo == null) {
            return true;
        }
        RoleInfo roleInfo = (RoleInfo)constraintInfo;
        if (!roleInfo.isChecked()) {
            return true;
        }
        if (roleInfo.isAnyAuth() && request.getUserPrincipal() != null) {
            return true;
        }
        boolean isUserInRole = false;
        for (String role : roleInfo.getRoles()) {
            if (!userIdentity.isUserInRole(role, null)) continue;
            isUserInRole = true;
            break;
        }
        if (var1_1.isAnyRole() && var2_2.getUserPrincipal() != null && isUserInRole) {
            return true;
        }
        return (boolean)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_2;
        void var1_1;
        this.dumpObjects((Appendable)var1_1, (String)var2_2, new Object[]{DumpableCollection.from((String)"roles", (Object[])new Object[]{this._roles}), DumpableCollection.from((String)"constraints", (Object[])new Object[]{this._constraintMap.entrySet()})});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDenyUncoveredHttpMethods(boolean deny) {
        void var1_1;
        this._denyUncoveredMethods = var1_1;
    }

    @Override
    public boolean isDenyUncoveredHttpMethods() {
        return this._denyUncoveredMethods;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkPathsWithUncoveredHttpMethods() {
        Set<String> paths = this.getPathsWithUncoveredHttpMethods();
        if (paths != null && !paths.isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                String p = (String)iterator.next();
                LOG.warn("{} has uncovered http methods for path: {}", new Object[]{ContextHandler.getCurrentContext(), var2_2});
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(new Throwable());
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getPathsWithUncoveredHttpMethods() {
        void var1_1;
        if (this._denyUncoveredMethods) {
            return Collections.emptySet();
        }
        HashSet<String> uncoveredPaths = new HashSet<String>();
        for (Map.Entry entry : this._constraintMap.entrySet()) {
            Map methodMappings = (Map)entry.getValue();
            if (methodMappings.get(ALL_METHODS) != null) continue;
            boolean hasOmissions = this.omissionsExist((String)entry.getKey(), methodMappings);
            for (String method : methodMappings.keySet()) {
                if (method.endsWith(OMISSION_SUFFIX)) {
                    Object object = this.getOmittedMethods(method);
                    object = object.iterator();
                    while (object.hasNext()) {
                        String m = (String)object.next();
                        if (methodMappings.containsKey(m)) continue;
                        uncoveredPaths.add((String)entry.getKey());
                    }
                    continue;
                }
                if (hasOmissions) continue;
                uncoveredPaths.add((String)entry.getKey());
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean omissionsExist(String path, Map<String, RoleInfo> methodMappings) {
        void var1_2;
        Iterator iterator;
        if (methodMappings == null) {
            return false;
        }
        boolean hasOmissions = false;
        for (String string : iterator.keySet()) {
            if (!string.endsWith(OMISSION_SUFFIX)) continue;
            hasOmissions = true;
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    protected Set<String> getOmittedMethods(String omission) {
        void var2_2;
        if (omission == null || !omission.endsWith(OMISSION_SUFFIX)) {
            return Collections.emptySet();
        }
        String[] strings = omission.split("\\.");
        HashSet<String> methods = new HashSet<String>();
        for (int i = 0; i < strings.length - 1; ++i) {
            methods.add(strings[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInDurableState() {
        void var2_2;
        void var1_1;
        ContextHandler context = ContextHandler.getContextHandler(null);
        Server server = this.getServer();
        return context == null && server == null || context != null && !context.isRunning() || var1_1 == null && server != null && !var2_2.isRunning();
    }
}

