/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.file.Path;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SpnegoUserIdentity;
import org.eclipse.jetty.security.SpnegoUserPrincipal;
import org.eclipse.jetty.security.authentication.AuthorizationService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class ConfigurableSpnegoLoginService
extends ContainerLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(ConfigurableSpnegoLoginService.class);
    private final GSSManager _gssManager = GSSManager.getInstance();
    private final String _realm;
    private final AuthorizationService _authorizationService;
    private IdentityService _identityService = new DefaultIdentityService();
    private String _serviceName;
    private Path _keyTabPath;
    private String _hostName;
    private SpnegoContext _context;

    /*
     * WARNING - void declaration
     */
    public ConfigurableSpnegoLoginService(String realm, AuthorizationService authorizationService) {
        void var2_2;
        void var1_1;
        this._realm = var1_1;
        this._authorizationService = var2_2;
    }

    @Override
    public String getName() {
        return this._realm;
    }

    public Path getKeyTabPath() {
        return this._keyTabPath;
    }

    /*
     * WARNING - void declaration
     */
    public void setKeyTabPath(Path keyTabFile) {
        void var1_1;
        this._keyTabPath = var1_1;
    }

    public String getServiceName() {
        return this._serviceName;
    }

    /*
     * WARNING - void declaration
     */
    public void setServiceName(String serviceName) {
        void var1_1;
        this._serviceName = var1_1;
    }

    public String getHostName() {
        return this._hostName;
    }

    /*
     * WARNING - void declaration
     */
    public void setHostName(String hostName) {
        void var1_1;
        this._hostName = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        void var1_1;
        if (this._hostName == null) {
            this._hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving credentials for service {}/{}", new Object[]{this.getServiceName(), this.getHostName()});
        }
        LoginContext loginContext = new LoginContext("", null, null, new SpnegoConfiguration());
        loginContext.login();
        Subject subject = loginContext.getSubject();
        this._context = Subject.doAs(subject, this.newSpnegoContext((Subject)var1_1));
        super.doStart();
    }

    /*
     * WARNING - void declaration
     */
    private PrivilegedAction<SpnegoContext> newSpnegoContext(Subject subject) {
        void var1_1;
        return () -> this.lambda$newSpnegoContext$0((Subject)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UserIdentity login(String username, Object credentials, ServletRequest req) {
        void var2_2;
        void var1_1;
        void var3_3;
        UserIdentity roles;
        Subject subject = this._context._subject;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpSession httpSession = request.getSession(false);
        GSSContext gssContext = null;
        if (httpSession != null) {
            GSSContextHolder holder = (GSSContextHolder)httpSession.getAttribute(GSSContextHolder.ATTRIBUTE);
            GSSContext gSSContext = gssContext = holder == null ? null : holder.gssContext;
        }
        if (gssContext == null) {
            gssContext = Subject.doAs(subject, this.newGSSContext());
        }
        byte[] input = Base64.getDecoder().decode((String)credentials);
        byte[] output = Subject.doAs(this._context._subject, this.acceptGSSContext(gssContext, input));
        String token = Base64.getEncoder().encodeToString(output);
        String userName = this.toUserName(gssContext);
        SpnegoUserPrincipal principal = new SpnegoUserPrincipal(userName, token);
        if (gssContext.isEstablished()) {
            if (httpSession != null) {
                httpSession.removeAttribute(GSSContextHolder.ATTRIBUTE);
            }
            roles = this._authorizationService.getUserIdentity(request, userName);
            return new SpnegoUserIdentity(subject, principal, roles);
        }
        if (httpSession == null) {
            httpSession = roles.getSession(true);
        }
        GSSContextHolder holder = new GSSContextHolder(gssContext);
        httpSession.setAttribute(GSSContextHolder.ATTRIBUTE, (Object)var3_3);
        return new SpnegoUserIdentity((Subject)var1_1, (Principal)var2_2, null);
    }

    private PrivilegedAction<GSSContext> newGSSContext() {
        return () -> {
            try {
                return this._gssManager.createContext(this._context._serviceCredential);
            }
            catch (GSSException x) {
                void var1_1;
                throw new RuntimeException((Throwable)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private PrivilegedAction<byte[]> acceptGSSContext(GSSContext gssContext, byte[] token) {
        void var2_2;
        return () -> ConfigurableSpnegoLoginService.lambda$acceptGSSContext$2(gssContext, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private String toUserName(GSSContext gssContext) {
        try {
            void var2_3;
            String name = gssContext.getSrcName().toString();
            int at = name.indexOf(64);
            if (at < 0) {
                return name;
            }
            return name.substring(0, (int)var2_3);
        }
        catch (GSSException x) {
            void var1_2;
            throw new RuntimeException((Throwable)var1_2);
        }
    }

    @Override
    public boolean validate(UserIdentity user) {
        return false;
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIdentityService(IdentityService identityService) {
        void var1_1;
        this._identityService = var1_1;
    }

    @Override
    public void logout(UserIdentity user) {
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ byte[] lambda$acceptGSSContext$2(GSSContext gssContext, byte[] token) {
        try {
            void var1_2;
            return gssContext.acceptSecContext(token, 0, ((void)var1_2).length);
        }
        catch (GSSException x) {
            void var0_1;
            throw new RuntimeException((Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ SpnegoContext lambda$newSpnegoContext$0(Subject subject) {
        try {
            void var3_4;
            void var1_1;
            GSSName serviceName = this._gssManager.createName(this.getServiceName() + "@" + this.getHostName(), GSSName.NT_HOSTBASED_SERVICE);
            Oid kerberosOid = new Oid("1.2.840.113554.1.2.2");
            Oid spnegoOid = new Oid("1.3.6.1.5.5.2");
            Oid[] mechanisms = new Oid[]{kerberosOid, spnegoOid};
            GSSCredential serviceCredential = this._gssManager.createCredential(serviceName, 0, mechanisms, 2);
            SpnegoContext context = new SpnegoContext();
            SpnegoContext.access$102(context, (Subject)var1_1);
            SpnegoContext.access$502(context, serviceCredential);
            return var3_4;
        }
        catch (GSSException x) {
            void var2_3;
            throw new RuntimeException((Throwable)var2_3);
        }
    }

    private static class GSSContextHolder
    implements Serializable {
        public static final String ATTRIBUTE = GSSContextHolder.class.getName();
        private final transient GSSContext gssContext;

        /*
         * WARNING - void declaration
         */
        private GSSContextHolder(GSSContext gssContext) {
            void var1_1;
            this.gssContext = var1_1;
        }
    }

    private static class SpnegoContext {
        private Subject _subject;
        private GSSCredential _serviceCredential;

        private SpnegoContext() {
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Subject access$102(SpnegoContext x0, Subject x1) {
            void var1_1;
            x0._subject = var1_1;
            return x0._subject;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ GSSCredential access$502(SpnegoContext x0, GSSCredential x1) {
            void var1_1;
            x0._serviceCredential = var1_1;
            return x0._serviceCredential;
        }
    }

    private class SpnegoConfiguration
    extends Configuration {
        private SpnegoConfiguration() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            void var1_1;
            void var2_2;
            String principal = ConfigurableSpnegoLoginService.this.getServiceName() + "/" + ConfigurableSpnegoLoginService.this.getHostName();
            HashMap<String, String> options = new HashMap<String, String>();
            if (LOG.isDebugEnabled()) {
                options.put("debug", "true");
            }
            options.put("doNotPrompt", "true");
            options.put("refreshKrb5Config", "true");
            options.put("principal", principal);
            options.put("useKeyTab", "true");
            Path keyTabPath = ConfigurableSpnegoLoginService.this.getKeyTabPath();
            if (keyTabPath != null) {
                options.put("keyTab", keyTabPath.toAbsolutePath().toString());
            }
            options.put("storeKey", "true");
            options.put("isInitiator", "false");
            String moduleClass = "com.sun.security.auth.module.Krb5LoginModule";
            AppConfigurationEntry config = new AppConfigurationEntry(moduleClass, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)var2_2);
            return new AppConfigurationEntry[]{var1_1};
        }
    }
}

