/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.Serializable;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintAware;
import org.eclipse.jetty.security.LoggedOutAuthentication;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.UserIdentity;

public abstract class AbstractUserAuthentication
implements Serializable,
Authentication.User {
    private static final long serialVersionUID = -6290411814232723403L;
    protected String _method;
    protected transient UserIdentity _userIdentity;

    /*
     * WARNING - void declaration
     */
    public AbstractUserAuthentication(String method, UserIdentity userIdentity) {
        void var2_2;
        void var1_1;
        this._method = var1_1;
        this._userIdentity = var2_2;
    }

    public String getAuthMethod() {
        return this._method;
    }

    public UserIdentity getUserIdentity() {
        return this._userIdentity;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isUserInRole(UserIdentity.Scope scope, String role) {
        void var1_1;
        void var2_2;
        void var3_3;
        String roleToTest = null;
        if (scope != null && scope.getRoleRefMap() != null) {
            roleToTest = (String)scope.getRoleRefMap().get(role);
        }
        if (roleToTest == null) {
            roleToTest = role;
        }
        if ("**".equals(var3_3.trim())) {
            if (!this.declaredRolesContains("**")) {
                return true;
            }
            return this._userIdentity.isUserInRole(role, scope);
        }
        return this._userIdentity.isUserInRole((String)var2_2, (UserIdentity.Scope)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean declaredRolesContains(String roleName) {
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security == null) {
            return false;
        }
        if (security instanceof ConstraintAware) {
            void var1_1;
            void var2_2;
            Set<String> declaredRoles = ((ConstraintAware)((Object)security)).getRoles();
            return declaredRoles != null && var2_2.contains(var1_1);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Authentication logout(ServletRequest request) {
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security != null) {
            security.logout(this);
            Authenticator authenticator = security.getAuthenticator();
            if (authenticator instanceof LoginAuthenticator) {
                void var2_2;
                void var1_1;
                ((LoginAuthenticator)authenticator).logout((ServletRequest)var1_1);
                return new LoggedOutAuthentication((LoginAuthenticator)var2_2);
            }
        }
        return Authentication.UNAUTHENTICATED;
    }
}

