/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.Serializable;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

public abstract class AbstractLoginService
extends ContainerLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(AbstractLoginService.class);
    protected IdentityService _identityService = new DefaultIdentityService();
    protected String _name;
    protected boolean _fullValidate = false;

    protected abstract String[] loadRoleInfo(UserPrincipal var1);

    protected abstract UserPrincipal loadUserInfo(String var1);

    protected AbstractLoginService() {
        AbstractLoginService abstractLoginService = this;
        abstractLoginService.addBean(abstractLoginService._identityService);
    }

    @Override
    public String getName() {
        return this._name;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIdentityService(IdentityService identityService) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        AbstractLoginService abstractLoginService = this;
        abstractLoginService.updateBean(abstractLoginService._identityService, identityService);
        this._identityService = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setName(String name) {
        void var1_1;
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this._name = var1_1;
    }

    public String toString() {
        return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this._name);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UserIdentity login(String username, Object credentials, ServletRequest request) {
        if (username == null) {
            return null;
        }
        UserPrincipal userPrincipal = this.loadUserInfo(username);
        if (userPrincipal != null && userPrincipal.authenticate(credentials)) {
            void var2_2;
            void var1_1;
            void var3_3;
            String[] roles = this.loadRoleInfo(userPrincipal);
            Subject subject = new Subject();
            subject.getPrincipals().add(userPrincipal);
            subject.getPrivateCredentials().add(userPrincipal._credential);
            if (roles != null) {
                String[] stringArray = roles;
                int n = roles.length;
                for (int i = 0; i < n; ++i) {
                    String role = stringArray[i];
                    subject.getPrincipals().add(new RolePrincipal(role));
                }
            }
            subject.setReadOnly();
            return this._identityService.newUserIdentity((Subject)var3_3, (Principal)var1_1, (String[])var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean validate(UserIdentity user) {
        if (!this.isFullValidate()) {
            return true;
        }
        UserPrincipal fresh = this.loadUserInfo(user.getUserPrincipal().getName());
        if (fresh == null) {
            return false;
        }
        if (user.getUserPrincipal() instanceof UserPrincipal) {
            void var1_1;
            void var2_2;
            return var2_2.authenticate(((UserPrincipal)var1_1.getUserPrincipal())._credential);
        }
        throw new IllegalStateException("UserPrincipal not KnownUser");
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    @Override
    public void logout(UserIdentity user) {
    }

    public boolean isFullValidate() {
        return this._fullValidate;
    }

    /*
     * WARNING - void declaration
     */
    public void setFullValidate(boolean fullValidate) {
        void var1_1;
        this._fullValidate = var1_1;
    }

    public static class UserPrincipal
    implements Serializable,
    Principal {
        private static final long serialVersionUID = -6226920753748399662L;
        private final String _name;
        private final Credential _credential;

        /*
         * WARNING - void declaration
         */
        public UserPrincipal(String name, Credential credential) {
            void var2_2;
            void var1_1;
            this._name = var1_1;
            this._credential = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public boolean authenticate(Object credentials) {
            void var1_1;
            return this._credential != null && this._credential.check((Object)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public boolean authenticate(Credential c) {
            void var1_1;
            return this._credential != null && c != null && this._credential.equals(var1_1);
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public String toString() {
            return this._name;
        }
    }

    public static class RolePrincipal
    implements Serializable,
    Principal {
        private static final long serialVersionUID = 2998397924051854402L;
        private final String _roleName;

        /*
         * WARNING - void declaration
         */
        public RolePrincipal(String name) {
            void var1_1;
            this._roleName = var1_1;
        }

        @Override
        public String getName() {
            return this._roleName;
        }
    }
}

