/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix matrix) {
        ByteMatrix byteMatrix;
        return MaskUtil.applyMaskPenaltyRule1Internal(matrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, false);
    }

    /*
     * WARNING - void declaration
     */
    static int applyMaskPenaltyRule2(ByteMatrix matrix) {
        void var1_2;
        int penalty = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y = 0; y < height - 1; ++y) {
            for (int x = 0; x < width - 1; ++x) {
                byte value = array[y][x];
                if (value != array[y][x + 1] || value != array[y + 1][x] || value != array[y + 1][x + 1]) continue;
                ++penalty;
            }
        }
        return 3 * var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static int applyMaskPenaltyRule3(ByteMatrix matrix) {
        void var1_2;
        int numPenalties = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                byte[] arrayY = array[y];
                if (x + 6 < width && arrayY[x] == 1 && arrayY[x + 1] == 0 && arrayY[x + 2] == 1 && arrayY[x + 3] == 1 && arrayY[x + 4] == 1 && arrayY[x + 5] == 0 && arrayY[x + 6] == 1 && (MaskUtil.isWhiteHorizontal(arrayY, x - 4, x) || MaskUtil.isWhiteHorizontal(arrayY, x + 7, x + 11))) {
                    ++numPenalties;
                }
                if (y + 6 >= height || array[y][x] != 1 || array[y + 1][x] != 0 || array[y + 2][x] != 1 || array[y + 3][x] != 1 || array[y + 4][x] != 1 || array[y + 5][x] != 0 || array[y + 6][x] != 1 || !MaskUtil.isWhiteVertical(array, x, y - 4, y) && !MaskUtil.isWhiteVertical(array, x, y + 7, y + 11)) continue;
                ++numPenalties;
            }
        }
        return (int)(var1_2 * 40);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isWhiteHorizontal(byte[] rowArray, int from, int to) {
        void i;
        from = Math.max(from, 0);
        to = Math.min(to, rowArray.length);
        while (i < to) {
            if (rowArray[i] == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isWhiteVertical(byte[][] array, int col, int from, int to) {
        void i;
        from = Math.max(from, 0);
        to = Math.min(to, array.length);
        while (i < to) {
            if (array[i][col] == 1) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static int applyMaskPenaltyRule4(ByteMatrix matrix) {
        void var1_1;
        ByteMatrix byteMatrix;
        int numDarkCells = 0;
        byte[][] array = matrix.getArray();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        for (int y = 0; y < height; ++y) {
            byte[] arrayY = array[y];
            for (int x = 0; x < width; ++x) {
                if (arrayY[x] != 1) continue;
                ++numDarkCells;
            }
        }
        int numTotalCells = matrix.getHeight() * byteMatrix.getWidth();
        return Math.abs((int)((var1_1 << 1) - numTotalCells)) * 10 / numTotalCells * 10;
    }

    /*
     * WARNING - void declaration
     */
    static boolean getDataMaskBit(int maskPattern, int x, int y) {
        int n;
        switch (maskPattern) {
            case 0: {
                int intermediate = y + x & 1;
                break;
            }
            case 1: {
                int intermediate = y & 1;
                break;
            }
            case 2: {
                int intermediate = x % 3;
                break;
            }
            case 3: {
                int intermediate = (y + x) % 3;
                break;
            }
            case 4: {
                int intermediate = y / 2 + x / 3 & 1;
                break;
            }
            case 5: {
                int temp = y * x;
                int intermediate = (temp & 1) + temp % 3;
                break;
            }
            case 6: {
                int temp = y * x;
                int intermediate = (temp & 1) + temp % 3 & 1;
                break;
            }
            case 7: {
                void var1_1;
                void var2_2;
                int intermediate = y * x % 3 + (var2_2 + var1_1 & 1) & 1;
                break;
            }
            default: {
                int intermediate;
                throw new IllegalArgumentException("Invalid mask pattern: ".concat(String.valueOf(intermediate)));
            }
        }
        return n == 0;
    }

    /*
     * WARNING - void declaration
     */
    private static int applyMaskPenaltyRule1Internal(ByteMatrix matrix, boolean isHorizontal) {
        void var2_2;
        int penalty = 0;
        int iLimit = isHorizontal ? matrix.getHeight() : matrix.getWidth();
        int jLimit = isHorizontal ? matrix.getWidth() : matrix.getHeight();
        Object array = matrix.getArray();
        for (int i = 0; i < iLimit; ++i) {
            int numSameBitCells = 0;
            Object prevBit = -1;
            for (int j = 0; j < jLimit; ++j) {
                Object bit = isHorizontal ? array[i][j] : array[j][i];
                if (bit == prevBit) {
                    ++numSameBitCells;
                    continue;
                }
                if (numSameBitCells >= 5) {
                    penalty += 3 + (numSameBitCells - 5);
                }
                numSameBitCells = 1;
                prevBit = bit;
            }
            if (numSameBitCells < 5) continue;
            penalty += 3 + (numSameBitCells - 5);
        }
        return (int)var2_2;
    }
}

