/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.BlockPair;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.MatrixUtil;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix matrix) {
        ByteMatrix byteMatrix;
        return MaskUtil.applyMaskPenaltyRule1(matrix) + MaskUtil.applyMaskPenaltyRule2(matrix) + MaskUtil.applyMaskPenaltyRule3(matrix) + MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    /*
     * WARNING - void declaration
     */
    public static QRCode encode(String content, ErrorCorrectionLevel ecLevel) throws WriterException {
        void var1_1;
        return Encoder.encode(content, (ErrorCorrectionLevel)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static QRCode encode(String content, ErrorCorrectionLevel ecLevel, Map<EncodeHintType, ?> hints) throws WriterException {
        void var3_3;
        void var2_2;
        void var1_1;
        BitArray bitArray;
        int dimension;
        Version version;
        CharacterSetECI eci;
        String encoding = DEFAULT_BYTE_MODE_ENCODING;
        if (hints != null && hints.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
            encoding = hints.get((Object)EncodeHintType.CHARACTER_SET).toString();
        }
        Mode mode = Encoder.chooseMode(content, encoding);
        BitArray headerBits = new BitArray();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(encoding) && (eci = CharacterSetECI.getCharacterSetECIByName(encoding)) != null) {
            Encoder.appendECI(eci, headerBits);
        }
        Encoder.appendModeInfo(mode, headerBits);
        BitArray dataBits = new BitArray();
        Encoder.appendBytes(content, mode, dataBits, encoding);
        if (hints != null && hints.containsKey((Object)EncodeHintType.QR_VERSION)) {
            version = Version.getVersionForNumber(Integer.parseInt(hints.get((Object)EncodeHintType.QR_VERSION).toString()));
            if (!Encoder.willFit(Encoder.calculateBitsNeeded(mode, headerBits, dataBits, version), version, ecLevel)) {
                throw new WriterException("Data too big for requested version");
            }
        } else {
            version = Encoder.recommendVersion(ecLevel, mode, headerBits, dataBits);
        }
        BitArray headerAndDataBits = new BitArray();
        headerAndDataBits.appendBitArray(headerBits);
        Encoder.appendLengthInfo(mode == Mode.BYTE ? dataBits.getSizeInBytes() : content.length(), version, mode, headerAndDataBits);
        headerAndDataBits.appendBitArray(dataBits);
        BitArray ecBlocks = version.getECBlocksForLevel(ecLevel);
        int numDataBytes = version.getTotalCodewords() - ((Version.ECBlocks)((Object)ecBlocks)).getTotalECCodewords();
        Encoder.terminateBits(numDataBytes, headerAndDataBits);
        BitArray finalBits = Encoder.interleaveWithECBytes(headerAndDataBits, version.getTotalCodewords(), numDataBytes, ((Version.ECBlocks)((Object)ecBlocks)).getNumBlocks());
        QRCode qrCode = new QRCode();
        qrCode.setECLevel(ecLevel);
        qrCode.setMode(mode);
        qrCode.setVersion(version);
        int n = dimension = version.getDimensionForVersion();
        ByteMatrix matrix = new ByteMatrix(n, n);
        int maskPattern = Encoder.chooseMaskPattern(finalBits, ecLevel, version, matrix);
        qrCode.setMaskPattern(maskPattern);
        MatrixUtil.buildMatrix(bitArray, (ErrorCorrectionLevel)var1_1, (Version)var2_2, maskPattern, matrix);
        qrCode.setMatrix(matrix);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static Version recommendVersion(ErrorCorrectionLevel ecLevel, Mode mode, BitArray headerBits, BitArray dataBits) throws WriterException {
        ErrorCorrectionLevel errorCorrectionLevel;
        void var3_3;
        void var2_2;
        void var1_1;
        Version provisionalVersion = Encoder.chooseVersion(Encoder.calculateBitsNeeded(mode, headerBits, dataBits, Version.getVersionForNumber(1)), ecLevel);
        return Encoder.chooseVersion(Encoder.calculateBitsNeeded((Mode)var1_1, (BitArray)var2_2, (BitArray)var3_3, provisionalVersion), errorCorrectionLevel);
    }

    /*
     * WARNING - void declaration
     */
    private static int calculateBitsNeeded(Mode mode, BitArray headerBits, BitArray dataBits, Version version) {
        void var2_2;
        void var3_3;
        Mode mode2;
        return headerBits.getSize() + mode2.getCharacterCountBits((Version)var3_3) + var2_2.getSize();
    }

    static int getAlphanumericCode(int code) {
        if (code < ALPHANUMERIC_TABLE.length) {
            int n;
            return ALPHANUMERIC_TABLE[n];
        }
        return -1;
    }

    public static Mode chooseMode(String content) {
        return Encoder.chooseMode(content, null);
    }

    /*
     * WARNING - void declaration
     */
    private static Mode chooseMode(String content, String encoding) {
        void var1_2;
        void var2_3;
        if ("Shift_JIS".equals(encoding) && Encoder.isOnlyDoubleByteKanji(content)) {
            return Mode.KANJI;
        }
        boolean hasNumeric = false;
        boolean hasAlphanumeric = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c >= '0' && c <= '9') {
                hasNumeric = true;
                continue;
            }
            if (Encoder.getAlphanumericCode(c) != -1) {
                hasAlphanumeric = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (var2_3 != false) {
            return Mode.ALPHANUMERIC;
        }
        if (var1_2 != false) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isOnlyDoubleByteKanji(String content) {
        Object bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int length = ((Object)bytes).length;
        if (length % 2 != 0) {
            return false;
        }
        for (int i = 0; i < length; i += 2) {
            void var3_3;
            int byte1 = bytes[i] & 0xFF;
            if (byte1 >= 129 && byte1 <= 159 || byte1 >= 224 && var3_3 <= 235) continue;
            return false;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bits, ErrorCorrectionLevel ecLevel, Version version, ByteMatrix matrix) throws WriterException {
        int minPenalty = Integer.MAX_VALUE;
        int bestMaskPattern = -1;
        for (int maskPattern = 0; maskPattern < 8; ++maskPattern) {
            MatrixUtil.buildMatrix(bits, ecLevel, version, maskPattern, matrix);
            int penalty = Encoder.calculateMaskPenalty(matrix);
            if (penalty >= minPenalty) continue;
            minPenalty = penalty;
            bestMaskPattern = maskPattern;
        }
        return bestMaskPattern;
    }

    /*
     * WARNING - void declaration
     */
    private static Version chooseVersion(int numInputBits, ErrorCorrectionLevel ecLevel) throws WriterException {
        for (int versionNum = 1; versionNum <= 40; ++versionNum) {
            void var3_3;
            Version version = Version.getVersionForNumber(versionNum);
            if (!Encoder.willFit(numInputBits, version, ecLevel)) continue;
            return var3_3;
        }
        throw new WriterException("Data too big");
    }

    /*
     * WARNING - void declaration
     */
    private static boolean willFit(int numInputBits, Version version, ErrorCorrectionLevel ecLevel) {
        int n;
        void var1_2;
        void var3_4;
        void var2_3;
        int numBytes = version.getTotalCodewords();
        int numEcBytes = version.getECBlocksForLevel((ErrorCorrectionLevel)var2_3).getTotalECCodewords();
        void numDataBytes = var3_4 - numEcBytes;
        int totalInputBytes = (numInputBits + 7) / 8;
        return var1_2 >= n;
    }

    /*
     * WARNING - void declaration
     */
    static void terminateBits(int numDataBytes, BitArray bits) throws WriterException {
        void var2_2;
        void var1_1;
        int i;
        int capacity = numDataBytes << 3;
        if (bits.getSize() > capacity) {
            throw new WriterException("data bits cannot fit in the QR Code" + bits.getSize() + " > " + capacity);
        }
        for (i = 0; i < 4 && bits.getSize() < capacity; ++i) {
            bits.appendBit(false);
        }
        int numBitsInLastByte = bits.getSize() & 7;
        if (numBitsInLastByte > 0) {
            while (i < 8) {
                bits.appendBit(false);
                ++i;
            }
        }
        int numPaddingBytes = numDataBytes - bits.getSizeInBytes();
        for (int i2 = 0; i2 < numPaddingBytes; ++i2) {
            bits.appendBits((i2 & 1) == 0 ? 236 : 17, 8);
        }
        if (var1_1.getSize() != var2_2) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    /*
     * WARNING - void declaration
     */
    static void getNumDataBytesAndNumECBytesForBlockID(int numTotalBytes, int numDataBytes, int numRSBlocks, int blockID, int[] numDataBytesInBlock, int[] numECBytesInBlock) throws WriterException {
        void var3_3;
        int n;
        void var2_2;
        if (blockID >= numRSBlocks) {
            throw new WriterException("Block ID too large");
        }
        int numRsBlocksInGroup2 = numTotalBytes % numRSBlocks;
        int numRsBlocksInGroup1 = numRSBlocks - numRsBlocksInGroup2;
        int numTotalBytesInGroup1 = numTotalBytes / numRSBlocks;
        int numDataBytesInGroup1 = numDataBytes / numRSBlocks;
        int numEcBytesInGroup1 = numTotalBytesInGroup1 - numDataBytesInGroup1;
        int numTotalBytesInGroup2 = numTotalBytesInGroup1 + 1;
        int numDataBytesInGroup2 = numDataBytesInGroup1 + 1;
        int numEcBytesInGroup2 = numTotalBytesInGroup2 - numDataBytesInGroup2;
        if (numEcBytesInGroup1 != numEcBytesInGroup2) {
            throw new WriterException("EC bytes mismatch");
        }
        if (var2_2 != numRsBlocksInGroup1 + numRsBlocksInGroup2) {
            throw new WriterException("RS blocks mismatch");
        }
        if (n != (numDataBytesInGroup1 + numEcBytesInGroup1) * numRsBlocksInGroup1 + (numDataBytesInGroup2 + numEcBytesInGroup2) * numRsBlocksInGroup2) {
            throw new WriterException("Total bytes mismatch");
        }
        if (var3_3 < numRsBlocksInGroup1) {
            void var1_1;
            numDataBytesInBlock[0] = var1_1;
            numECBytesInBlock[0] = numEcBytesInGroup1;
            return;
        }
        numDataBytesInBlock[0] = numDataBytesInGroup2;
        numECBytesInBlock[0] = numEcBytesInGroup2;
    }

    /*
     * WARNING - void declaration
     */
    static BitArray interleaveWithECBytes(BitArray bits, int numTotalBytes, int numDataBytes, int numRSBlocks) throws WriterException {
        Iterator iterator;
        int i;
        void var2_2;
        byte[] dataBytes;
        if (bits.getSizeInBytes() != numDataBytes) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int dataBytesOffset = 0;
        int maxNumDataBytes = 0;
        int maxNumEcBytes = 0;
        ArrayList<BlockPair> blocks = new ArrayList<BlockPair>(numRSBlocks);
        for (int i2 = 0; i2 < numRSBlocks; ++i2) {
            int[] numDataBytesInBlock = new int[1];
            int[] numEcBytesInBlock = new int[1];
            Encoder.getNumDataBytesAndNumECBytesForBlockID(numTotalBytes, numDataBytes, numRSBlocks, i2, numDataBytesInBlock, numEcBytesInBlock);
            int size = numDataBytesInBlock[0];
            dataBytes = new byte[size];
            bits.toBytes(dataBytesOffset << 3, dataBytes, 0, size);
            byte[] ecBytes = Encoder.generateECBytes(dataBytes, numEcBytesInBlock[0]);
            blocks.add(new BlockPair(dataBytes, ecBytes));
            maxNumDataBytes = Math.max(maxNumDataBytes, size);
            maxNumEcBytes = Math.max(maxNumEcBytes, ecBytes.length);
            dataBytesOffset += numDataBytesInBlock[0];
        }
        if (var2_2 != dataBytesOffset) {
            throw new WriterException("Data bytes does not match offset");
        }
        BitArray result = new BitArray();
        for (i = 0; i < maxNumDataBytes; ++i) {
            iterator = blocks.iterator();
            while (iterator.hasNext()) {
                dataBytes = ((BlockPair)iterator.next()).getDataBytes();
                if (i >= dataBytes.length) continue;
                result.appendBits(dataBytes[i], 8);
            }
        }
        for (i = 0; i < maxNumEcBytes; ++i) {
            iterator = blocks.iterator();
            while (iterator.hasNext()) {
                byte[] ecBytes = ((BlockPair)iterator.next()).getErrorCorrectionBytes();
                if (i >= ecBytes.length) continue;
                result.appendBits(ecBytes[i], 8);
            }
        }
        if (numTotalBytes != result.getSizeInBytes()) {
            void var1_1;
            throw new WriterException("Interleaving error: " + (int)var1_1 + " and " + result.getSizeInBytes() + " differ.");
        }
        return result;
    }

    static byte[] generateECBytes(byte[] dataBytes, int numEcBytesInBlock) {
        int numDataBytes = dataBytes.length;
        int[] toEncode = new int[numDataBytes + numEcBytesInBlock];
        for (int i = 0; i < numDataBytes; ++i) {
            toEncode[i] = dataBytes[i] & 0xFF;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(toEncode, numEcBytesInBlock);
        byte[] ecBytes = new byte[numEcBytesInBlock];
        for (int i = 0; i < numEcBytesInBlock; ++i) {
            ecBytes[i] = (byte)toEncode[numDataBytes + i];
        }
        return ecBytes;
    }

    static void appendModeInfo(Mode mode, BitArray bits) {
        Mode mode2;
        bits.appendBits(mode2.getBits(), 4);
    }

    /*
     * WARNING - void declaration
     */
    static void appendLengthInfo(int numLetters, Version version, Mode mode, BitArray bits) throws WriterException {
        void var1_2;
        int n;
        void var3_4;
        int numBits = mode.getCharacterCountBits(version);
        if (numLetters >= 1 << numBits) {
            throw new WriterException(numLetters + " is bigger than " + ((1 << numBits) - 1));
        }
        var3_4.appendBits(n, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    static void appendBytes(String content, Mode mode, BitArray bits, String encoding) throws WriterException {
        void var1_1;
        switch (mode) {
            case NUMERIC: {
                Encoder.appendNumericBytes(content, bits);
                return;
            }
            case ALPHANUMERIC: {
                Encoder.appendAlphanumericBytes(content, bits);
                return;
            }
            case BYTE: {
                void var3_3;
                Encoder.append8BitBytes(content, bits, (String)var3_3);
                return;
            }
            case KANJI: {
                void var2_2;
                String string;
                Encoder.appendKanjiBytes(string, (BitArray)var2_2);
                return;
            }
        }
        throw new WriterException("Invalid mode: ".concat(String.valueOf(var1_1)));
    }

    static void appendNumericBytes(CharSequence content, BitArray bits) {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int num2;
            int num1 = content.charAt(i) - 48;
            if (i + 2 < length) {
                num2 = content.charAt(i + 1) - 48;
                int num3 = content.charAt(i + 2) - 48;
                bits.appendBits(num1 * 100 + num2 * 10 + num3, 10);
                i += 3;
                continue;
            }
            if (i + 1 < length) {
                num2 = content.charAt(i + 1) - 48;
                bits.appendBits(num1 * 10 + num2, 7);
                i += 2;
                continue;
            }
            bits.appendBits(num1, 4);
            ++i;
        }
    }

    static void appendAlphanumericBytes(CharSequence content, BitArray bits) throws WriterException {
        int length = content.length();
        int i = 0;
        while (i < length) {
            int code1 = Encoder.getAlphanumericCode(content.charAt(i));
            if (code1 == -1) {
                throw new WriterException();
            }
            if (i + 1 < length) {
                int code2 = Encoder.getAlphanumericCode(content.charAt(i + 1));
                if (code2 == -1) {
                    throw new WriterException();
                }
                bits.appendBits(code1 * 45 + code2, 11);
                i += 2;
                continue;
            }
            bits.appendBits(code1, 6);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    static void append8BitBytes(String content, BitArray bits, String encoding) throws WriterException {
        Object object;
        try {
            void var2_3;
            Object bytes = content.getBytes((String)var2_3);
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException(uee);
        }
        for (Object b : object) {
            bits.appendBits((int)b, 8);
        }
    }

    static void appendKanjiBytes(String content, BitArray bits) throws WriterException {
        Object bytes;
        try {
            bytes = content.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException uee) {
            throw new WriterException(uee);
        }
        int length = ((Object)bytes).length;
        for (int i = 0; i < length; i += 2) {
            int byte1 = bytes[i] & 0xFF;
            int byte2 = bytes[i + 1] & 0xFF;
            int code = byte1 << 8 | byte2;
            int subtracted = -1;
            if (code >= 33088 && code <= 40956) {
                subtracted = code - 33088;
            } else if (code >= 57408 && code <= 60351) {
                subtracted = code - 49472;
            }
            if (subtracted == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int encoded = (subtracted >> 8) * 192 + (subtracted & 0xFF);
            bits.appendBits(encoded, 13);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendECI(CharacterSetECI eci, BitArray bits) {
        CharacterSetECI characterSetECI;
        void var1_1;
        bits.appendBits(Mode.ECI.getBits(), 4);
        var1_1.appendBits(characterSetECI.getValue(), 8);
    }
}

