/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.PerspectiveTransform;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import com.google.zxing.qrcode.detector.AlignmentPatternFinder;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Map;

public class Detector {
    private final BitMatrix image;
    private ResultPointCallback resultPointCallback;

    /*
     * WARNING - void declaration
     */
    public Detector(BitMatrix image) {
        void var1_1;
        this.image = var1_1;
    }

    protected final BitMatrix getImage() {
        return this.image;
    }

    protected final ResultPointCallback getResultPointCallback() {
        return this.resultPointCallback;
    }

    public DetectorResult detect() throws NotFoundException, FormatException {
        return this.detect(null);
    }

    /*
     * WARNING - void declaration
     */
    public final DetectorResult detect(Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException {
        void var1_1;
        this.resultPointCallback = hints == null ? null : (ResultPointCallback)hints.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        FinderPatternInfo info = new FinderPatternFinder(this.image, this.resultPointCallback).find(hints);
        return this.processFinderPatternInfo((FinderPatternInfo)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected final DetectorResult processFinderPatternInfo(FinderPatternInfo info) throws NotFoundException, FormatException {
        void var3_3;
        void var2_2;
        void var1_1;
        float f;
        FinderPattern topLeft = info.getTopLeft();
        FinderPattern topRight = info.getTopRight();
        FinderPattern bottomLeft = info.getBottomLeft();
        float moduleSize = this.calculateModuleSize(topLeft, topRight, bottomLeft);
        if (f < 1.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int dimension = Detector.computeDimension(topLeft, topRight, bottomLeft, moduleSize);
        Version provisionalVersion = Version.getProvisionalVersionForDimension(dimension);
        int modulesBetweenFPCenters = provisionalVersion.getDimensionForVersion() - 7;
        AlignmentPattern alignmentPattern = null;
        if (provisionalVersion.getAlignmentPatternCenters().length > 0) {
            float bottomRightX = topRight.getX() - topLeft.getX() + bottomLeft.getX();
            float bottomRightY = topRight.getY() - topLeft.getY() + bottomLeft.getY();
            float correctionToTopLeft = 1.0f - 3.0f / (float)modulesBetweenFPCenters;
            int estAlignmentX = (int)(topLeft.getX() + correctionToTopLeft * (bottomRightX - topLeft.getX()));
            int estAlignmentY = (int)(topLeft.getY() + correctionToTopLeft * (bottomRightY - topLeft.getY()));
            for (int i = 4; i <= 16; i <<= 1) {
                try {
                    alignmentPattern = this.findAlignmentInRegion(moduleSize, estAlignmentX, estAlignmentY, i);
                    break;
                }
                catch (NotFoundException notFoundException) {
                    continue;
                }
            }
        }
        PerspectiveTransform transform = Detector.createTransform(topLeft, topRight, bottomLeft, alignmentPattern, dimension);
        BitMatrix bits = Detector.sampleGrid(this.image, transform, dimension);
        ResultPoint[] points = alignmentPattern == null ? new ResultPoint[]{bottomLeft, topLeft, topRight} : new ResultPoint[]{var1_1, var2_2, var3_3, alignmentPattern};
        return new DetectorResult(bits, points);
    }

    /*
     * WARNING - void declaration
     */
    private static PerspectiveTransform createTransform(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft, ResultPoint alignmentPattern, int dimension) {
        void var2_2;
        void var3_4;
        void var1_1;
        ResultPoint resultPoint;
        float sourceBottomRightY;
        float sourceBottomRightX;
        float bottomRightY;
        float bottomRightX;
        float dimMinusThree = (float)dimension - 3.5f;
        if (alignmentPattern != null) {
            bottomRightX = alignmentPattern.getX();
            bottomRightY = alignmentPattern.getY();
            sourceBottomRightY = sourceBottomRightX = dimMinusThree - 3.0f;
        } else {
            bottomRightX = topRight.getX() - topLeft.getX() + bottomLeft.getX();
            bottomRightY = topRight.getY() - topLeft.getY() + bottomLeft.getY();
            sourceBottomRightX = dimMinusThree;
            sourceBottomRightY = dimMinusThree;
        }
        return PerspectiveTransform.quadrilateralToQuadrilateral(3.5f, 3.5f, dimMinusThree, 3.5f, sourceBottomRightX, sourceBottomRightY, 3.5f, dimMinusThree, topLeft.getX(), resultPoint.getY(), topRight.getX(), var1_1.getY(), bottomRightX, (float)var3_4, bottomLeft.getX(), var2_2.getY());
    }

    /*
     * WARNING - void declaration
     */
    private static BitMatrix sampleGrid(BitMatrix image, PerspectiveTransform transform, int dimension) throws NotFoundException {
        void var1_1;
        BitMatrix bitMatrix;
        void var2_2;
        void v0 = var2_2;
        return GridSampler.getInstance().sampleGrid(bitMatrix, (int)v0, (int)v0, (PerspectiveTransform)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int computeDimension(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft, float moduleSize) throws NotFoundException {
        void var0_1;
        void var1_3;
        void var3_5;
        void var2_4;
        int tltrCentersDimension = MathUtils.round(ResultPoint.distance(topLeft, topRight) / moduleSize);
        int tlblCentersDimension = MathUtils.round(ResultPoint.distance(topLeft, (ResultPoint)var2_4) / var3_5);
        void dimension = (var1_3 + tlblCentersDimension) / 2 + 7;
        switch (dimension & 3) {
            case 0: {
                ++dimension;
                break;
            }
            case 2: {
                --dimension;
                break;
            }
            case 3: {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final float calculateModuleSize(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft) {
        void var3_3;
        void var1_1;
        void var2_2;
        return (this.calculateModuleSizeOneWay(topLeft, (ResultPoint)var2_2) + this.calculateModuleSizeOneWay((ResultPoint)var1_1, (ResultPoint)var3_3)) / 2.0f;
    }

    /*
     * WARNING - void declaration
     */
    private float calculateModuleSizeOneWay(ResultPoint pattern, ResultPoint otherPattern) {
        void var1_2;
        void var3_4;
        void var2_3;
        float moduleSizeEst1 = this.sizeOfBlackWhiteBlackRunBothWays((int)pattern.getX(), (int)pattern.getY(), (int)otherPattern.getX(), (int)otherPattern.getY());
        float moduleSizeEst2 = this.sizeOfBlackWhiteBlackRunBothWays((int)otherPattern.getX(), (int)var2_3.getY(), (int)pattern.getX(), (int)pattern.getY());
        if (Float.isNaN(moduleSizeEst1)) {
            return moduleSizeEst2 / 7.0f;
        }
        if (Float.isNaN(moduleSizeEst2)) {
            return moduleSizeEst1 / 7.0f;
        }
        return (float)((var3_4 + var1_2) / 14.0f);
    }

    /*
     * WARNING - void declaration
     */
    private float sizeOfBlackWhiteBlackRunBothWays(int fromX, int fromY, int toX, int toY) {
        void var3_3;
        void var2_2;
        void var1_1;
        float result = this.sizeOfBlackWhiteBlackRun(fromX, fromY, toX, toY);
        float scale = 1.0f;
        int otherToX = fromX - (toX - fromX);
        if (otherToX < 0) {
            scale = (float)fromX / (float)(fromX - otherToX);
            otherToX = 0;
        } else if (otherToX >= this.image.getWidth()) {
            scale = (float)(this.image.getWidth() - 1 - fromX) / (float)(otherToX - fromX);
            otherToX = this.image.getWidth() - 1;
        }
        int otherToY = (int)((float)fromY - (float)(toY - fromY) * scale);
        scale = 1.0f;
        if (otherToY < 0) {
            scale = (float)fromY / (float)(fromY - otherToY);
            otherToY = 0;
        } else if (otherToY >= this.image.getHeight()) {
            scale = (float)(this.image.getHeight() - 1 - fromY) / (float)(otherToY - fromY);
            otherToY = this.image.getHeight() - 1;
        }
        otherToX = (int)((float)fromX + (float)(otherToX - fromX) * scale);
        return result + this.sizeOfBlackWhiteBlackRun((int)var1_1, (int)var2_2, (int)var3_3, otherToY) - 1.0f;
    }

    /*
     * WARNING - void declaration
     */
    private float sizeOfBlackWhiteBlackRun(int fromX, int fromY, int toX, int toY) {
        boolean steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            int temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        int dx = Math.abs(toX - fromX);
        int dy = Math.abs(toY - fromY);
        int error = -dx / 2;
        int xstep = fromX < toX ? 1 : -1;
        int ystep = fromY < toY ? 1 : -1;
        int state = 0;
        int xLimit = toX + xstep;
        int y = fromY;
        for (int x = fromX; x != xLimit; x += xstep) {
            int realY;
            int realX;
            if (state == 1 == this.image.get(realX = steep ? y : x, realY = steep ? x : y)) {
                if (state == 2) {
                    return MathUtils.distance(x, y, fromX, fromY);
                }
                ++state;
            }
            if ((error += dy) <= 0) continue;
            if (y == toY) break;
            y += ystep;
            error -= dx;
        }
        if (state == 2) {
            void var2_2;
            void var1_1;
            void var3_3;
            return MathUtils.distance((int)(var3_3 + xstep), toY, (int)var1_1, (int)var2_2);
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    protected final AlignmentPattern findAlignmentInRegion(float overallEstModuleSize, int estAlignmentX, int estAlignmentY, float allowanceFactor) throws NotFoundException {
        void var1_1;
        void var3_3;
        void var2_2;
        int n;
        int n2;
        int allowance = (int)(allowanceFactor * overallEstModuleSize);
        int alignmentAreaLeftX = Math.max(0, estAlignmentX - allowance);
        int alignmentAreaRightX = Math.min(this.image.getWidth() - 1, estAlignmentX + allowance);
        if ((float)(n2 - alignmentAreaLeftX) < overallEstModuleSize * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        int alignmentAreaTopY = Math.max(0, estAlignmentY - allowance);
        int alignmentAreaBottomY = Math.min(this.image.getHeight() - 1, estAlignmentY + allowance);
        if ((float)(n - alignmentAreaTopY) < overallEstModuleSize * 3.0f) {
            throw NotFoundException.getNotFoundInstance();
        }
        return new AlignmentPatternFinder(this.image, alignmentAreaLeftX, alignmentAreaTopY, (int)(var2_2 - alignmentAreaLeftX), (int)(var3_3 - alignmentAreaTopY), (float)var1_1, this.resultPointCallback).find();
    }
}

