/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.Version;

public enum Mode {
    TERMINATOR(new int[]{0, 0, 0}, 0),
    NUMERIC(new int[]{10, 12, 14}, 1),
    ALPHANUMERIC(new int[]{9, 11, 13}, 2),
    STRUCTURED_APPEND(new int[]{0, 0, 0}, 3),
    BYTE(new int[]{8, 16, 16}, 4),
    ECI(new int[]{0, 0, 0}, 7),
    KANJI(new int[]{8, 10, 12}, 8),
    FNC1_FIRST_POSITION(new int[]{0, 0, 0}, 5),
    FNC1_SECOND_POSITION(new int[]{0, 0, 0}, 9),
    HANZI(new int[]{8, 10, 12}, 13);

    private final int[] characterCountBitsForVersions;
    private final int bits;

    /*
     * WARNING - void declaration
     */
    private Mode(int[] characterCountBitsForVersions, int bits) {
        void var3_3;
        this.characterCountBitsForVersions = var3_3;
        this.bits = bits;
    }

    public static Mode forBits(int bits) {
        switch (bits) {
            case 0: {
                return TERMINATOR;
            }
            case 1: {
                return NUMERIC;
            }
            case 2: {
                return ALPHANUMERIC;
            }
            case 3: {
                return STRUCTURED_APPEND;
            }
            case 4: {
                return BYTE;
            }
            case 5: {
                return FNC1_FIRST_POSITION;
            }
            case 7: {
                return ECI;
            }
            case 8: {
                return KANJI;
            }
            case 9: {
                return FNC1_SECOND_POSITION;
            }
            case 13: {
                return HANZI;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - void declaration
     */
    public final int getCharacterCountBits(Version version) {
        void var1_2;
        int offset;
        int number = version.getVersionNumber();
        offset = number <= 9 ? 0 : (offset <= 26 ? 1 : 2);
        return this.characterCountBitsForVersions[var1_2];
    }

    public final int getBits() {
        return this.bits;
    }
}

