/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

final class FormatInformation {
    private static final int FORMAT_INFO_MASK_QR = 21522;
    private static final int[][] FORMAT_INFO_DECODE_LOOKUP = new int[][]{{21522, 0}, {20773, 1}, {24188, 2}, {23371, 3}, {17913, 4}, {16590, 5}, {20375, 6}, {19104, 7}, {30660, 8}, {29427, 9}, {32170, 10}, {30877, 11}, {26159, 12}, {25368, 13}, {27713, 14}, {26998, 15}, {5769, 16}, {5054, 17}, {7399, 18}, {6608, 19}, {1890, 20}, {597, 21}, {3340, 22}, {2107, 23}, {13663, 24}, {12392, 25}, {16177, 26}, {14854, 27}, {9396, 28}, {8579, 29}, {11994, 30}, {11245, 31}};
    private final ErrorCorrectionLevel errorCorrectionLevel;
    private final byte dataMask;

    /*
     * WARNING - void declaration
     */
    private FormatInformation(int formatInfo) {
        void var1_1;
        this.errorCorrectionLevel = ErrorCorrectionLevel.forBits(formatInfo >> 3 & 3);
        this.dataMask = (byte)(var1_1 & 7);
    }

    /*
     * WARNING - void declaration
     */
    static int numBitsDiffering(int a, int b) {
        void var1_1;
        return Integer.bitCount(a ^ var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static FormatInformation decodeFormatInformation(int maskedFormatInfo1, int maskedFormatInfo2) {
        void var1_1;
        int n;
        FormatInformation formatInfo = FormatInformation.doDecodeFormatInformation(maskedFormatInfo1, maskedFormatInfo2);
        if (formatInfo != null) {
            void var2_2;
            return var2_2;
        }
        return FormatInformation.doDecodeFormatInformation(n ^ 0x5412, var1_1 ^ 0x5412);
    }

    /*
     * WARNING - void declaration
     */
    private static FormatInformation doDecodeFormatInformation(int maskedFormatInfo1, int maskedFormatInfo2) {
        void var2_2;
        int bestDifference = Integer.MAX_VALUE;
        int bestFormatInfo = 0;
        int[][] nArray = FORMAT_INFO_DECODE_LOOKUP;
        int n = FORMAT_INFO_DECODE_LOOKUP.length;
        for (int i = 0; i < n; ++i) {
            int[] decodeInfo = nArray[i];
            int targetInfo = decodeInfo[0];
            if (targetInfo == maskedFormatInfo1 || targetInfo == maskedFormatInfo2) {
                return new FormatInformation(decodeInfo[1]);
            }
            int bitsDifference = FormatInformation.numBitsDiffering(maskedFormatInfo1, targetInfo);
            if (bitsDifference < bestDifference) {
                bestFormatInfo = decodeInfo[1];
                bestDifference = bitsDifference;
            }
            if (maskedFormatInfo1 == maskedFormatInfo2 || (bitsDifference = FormatInformation.numBitsDiffering(maskedFormatInfo2, targetInfo)) >= bestDifference) continue;
            bestFormatInfo = decodeInfo[1];
            bestDifference = bitsDifference;
        }
        if (var2_2 <= 3) {
            void var3_3;
            return new FormatInformation((int)var3_3);
        }
        return null;
    }

    final ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    final byte getDataMask() {
        return this.dataMask;
    }

    public final int hashCode() {
        return this.errorCorrectionLevel.ordinal() << 3 | this.dataMask;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (!(o instanceof FormatInformation)) {
            return false;
        }
        FormatInformation other = (FormatInformation)o;
        return this.errorCorrectionLevel == other.errorCorrectionLevel && this.dataMask == var1_1.dataMask;
    }
}

