/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.qrcode.decoder.BitMatrixParser;
import com.google.zxing.qrcode.decoder.DataBlock;
import com.google.zxing.qrcode.decoder.DecodedBitStreamParser;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.google.zxing.qrcode.decoder.Version;
import java.util.Map;

public final class Decoder {
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.QR_CODE_FIELD_256);

    /*
     * WARNING - void declaration
     */
    public final DecoderResult decode(boolean[][] image) throws ChecksumException, FormatException {
        void var1_1;
        return this.decode((boolean[][])var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final DecoderResult decode(boolean[][] image, Map<DecodeHintType, ?> hints) throws ChecksumException, FormatException {
        void var2_2;
        int dimension = image.length;
        BitMatrix bits = new BitMatrix(dimension);
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < dimension; ++j) {
                if (!image[i][j]) continue;
                bits.set(j, i);
            }
        }
        return this.decode(bits, (Map<DecodeHintType, ?>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final DecoderResult decode(BitMatrix bits) throws ChecksumException, FormatException {
        void var1_1;
        return this.decode((BitMatrix)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public final DecoderResult decode(BitMatrix bits, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        BitMatrixParser parser = new BitMatrixParser(bits);
        Object fe22 = null;
        Object ce22 = null;
        try {
            return this.decode(parser, hints);
        }
        catch (FormatException fe22) {
        }
        catch (ChecksumException ce22) {
            // empty catch block
        }
        try {
            void var2_3;
            parser.remask();
            parser.setMirror(true);
            parser.readVersion();
            parser.readFormatInformation();
            parser.mirror();
            DecoderResult result = this.decode(parser, (Map<DecodeHintType, ?>)var2_3);
            result.setOther(new QRCodeDecoderMetaData(true));
            return result;
        }
        catch (ChecksumException | FormatException e) {
            void var1_2;
            if (fe22 != null) {
                void var3_4;
                throw var3_4;
            }
            if (ce22 != null) {
                throw ce22;
            }
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private DecoderResult decode(BitMatrixParser parser, Map<DecodeHintType, ?> hints) throws FormatException, ChecksumException {
        void var2_3;
        void var3_4;
        void var1_1;
        Version version = parser.readVersion();
        ErrorCorrectionLevel ecLevel = parser.readFormatInformation().getErrorCorrectionLevel();
        DataBlock[] dataBlocks = DataBlock.getDataBlocks(parser.readCodewords(), version, ecLevel);
        int totalBytes = 0;
        DataBlock[] dataBlockArray = dataBlocks;
        int n = dataBlocks.length;
        for (int i = 0; i < n; ++i) {
            DataBlock dataBlock = dataBlockArray[i];
            totalBytes += dataBlock.getNumDataCodewords();
        }
        byte[] resultBytes = new byte[totalBytes];
        int resultOffset = 0;
        for (void dataBlock : var1_1) {
            byte[] codewordBytes = dataBlock.getCodewords();
            int numDataCodewords = dataBlock.getNumDataCodewords();
            this.correctErrors(codewordBytes, numDataCodewords);
            for (int i = 0; i < numDataCodewords; ++i) {
                resultBytes[resultOffset++] = codewordBytes[i];
            }
        }
        return DecodedBitStreamParser.decode(resultBytes, (Version)var3_4, ecLevel, var2_3);
    }

    private void correctErrors(byte[] codewordBytes, int numDataCodewords) throws ChecksumException {
        int i;
        int numCodewords = codewordBytes.length;
        int[] codewordsInts = new int[numCodewords];
        for (i = 0; i < numCodewords; ++i) {
            codewordsInts[i] = codewordBytes[i] & 0xFF;
        }
        try {
            this.rsDecoder.decode(codewordsInts, codewordBytes.length - numDataCodewords);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (i = 0; i < numDataCodewords; ++i) {
            codewordBytes[i] = (byte)codewordsInts[i];
        }
    }
}

