/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    /*
     * WARNING - void declaration
     */
    private DataBlock(int numDataCodewords, byte[] codewords) {
        void var2_2;
        void var1_1;
        this.numDataCodewords = var1_1;
        this.codewords = var2_2;
    }

    static DataBlock[] getDataBlocks(byte[] rawCodewords, Version version, ErrorCorrectionLevel ecLevel) {
        int longerBlocksStartAt;
        int i;
        Version.ECB[] ecBlockArray;
        if (rawCodewords.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks ecBlocks = version.getECBlocksForLevel(ecLevel);
        int totalBlocks = 0;
        Version.ECB[] eCBArray = ecBlockArray = ecBlocks.getECBlocks();
        int n = ecBlockArray.length;
        for (int j = 0; j < n; ++j) {
            Version.ECB ecBlock = eCBArray[j];
            totalBlocks += ecBlock.getCount();
        }
        DataBlock[] result = new DataBlock[totalBlocks];
        int numResultBlocks = 0;
        Version.ECB[] eCBArray2 = ecBlockArray;
        int ecBlock = ecBlockArray.length;
        for (totalBlocks = 0; totalBlocks < ecBlock; ++totalBlocks) {
            Version.ECB ecBlock2 = eCBArray2[totalBlocks];
            for (i = 0; i < ecBlock2.getCount(); ++i) {
                int numDataCodewords = ecBlock2.getDataCodewords();
                int numBlockCodewords = ecBlocks.getECCodewordsPerBlock() + numDataCodewords;
                result[numResultBlocks++] = new DataBlock(numDataCodewords, new byte[numBlockCodewords]);
            }
        }
        int shorterBlocksTotalCodewords = result[0].codewords.length;
        for (longerBlocksStartAt = result.length - 1; longerBlocksStartAt >= 0 && result[longerBlocksStartAt].codewords.length != shorterBlocksTotalCodewords; --longerBlocksStartAt) {
        }
        ++longerBlocksStartAt;
        int shorterBlocksNumDataCodewords = shorterBlocksTotalCodewords - ecBlocks.getECCodewordsPerBlock();
        int rawCodewordsOffset = 0;
        for (i = 0; i < shorterBlocksNumDataCodewords; ++i) {
            for (int j = 0; j < numResultBlocks; ++j) {
                result[j].codewords[i] = rawCodewords[rawCodewordsOffset++];
            }
        }
        for (int j = longerBlocksStartAt; j < numResultBlocks; ++j) {
            result[j].codewords[shorterBlocksNumDataCodewords] = rawCodewords[rawCodewordsOffset++];
        }
        int max = result[0].codewords.length;
        for (void i2 = var2_4; i2 < max; ++i2) {
            for (int j = 0; j < numResultBlocks; ++j) {
                void iOffset = j < longerBlocksStartAt ? i2 : i2 + true;
                result[j].codewords[var1_2] = rawCodewords[rawCodewordsOffset++];
            }
        }
        return result;
    }

    final int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    final byte[] getCodewords() {
        return this.codewords;
    }
}

