/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.detector;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class Detector {
    private static final int[] INDEXES_START_PATTERN = new int[]{0, 4, 1, 5};
    private static final int[] INDEXES_STOP_PATTERN = new int[]{6, 2, 7, 3};
    private static final float MAX_AVG_VARIANCE = 0.42f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.8f;
    private static final int[] START_PATTERN = new int[]{8, 1, 1, 1, 1, 1, 1, 3};
    private static final int[] STOP_PATTERN = new int[]{7, 1, 1, 3, 1, 1, 1, 2, 1};
    private static final int MAX_PIXEL_DRIFT = 3;
    private static final int MAX_PATTERN_DRIFT = 5;
    private static final int SKIPPED_ROW_COUNT_MAX = 25;
    private static final int ROW_STEP = 5;
    private static final int BARCODE_MIN_HEIGHT = 10;

    private Detector() {
    }

    /*
     * WARNING - void declaration
     */
    public static PDF417DetectorResult detect(BinaryBitmap image, Map<DecodeHintType, ?> hints, boolean multiple) throws NotFoundException {
        void var1_1;
        Object object;
        Object bitMatrix = image.getBlackMatrix();
        List<ResultPoint[]> barcodeCoordinates = Detector.detect(multiple, (BitMatrix)bitMatrix);
        if (barcodeCoordinates.isEmpty()) {
            void var2_2;
            bitMatrix = ((BitMatrix)bitMatrix).clone();
            ((BitMatrix)bitMatrix).rotate180();
            barcodeCoordinates = Detector.detect((boolean)var2_2, (BitMatrix)bitMatrix);
        }
        return new PDF417DetectorResult((BitMatrix)object, (List<ResultPoint[]>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static List<ResultPoint[]> detect(boolean multiple, BitMatrix bitMatrix) {
        void var2_2;
        ArrayList<ResultPoint[]> barcodeCoordinates = new ArrayList<ResultPoint[]>();
        int row = 0;
        int column = 0;
        boolean foundBarcodeInRow = false;
        while (row < bitMatrix.getHeight()) {
            ResultPoint[] vertices = Detector.findVertices(bitMatrix, row, column);
            if (vertices[0] == null && vertices[3] == null) {
                if (!foundBarcodeInRow) break;
                foundBarcodeInRow = false;
                column = 0;
                for (ResultPoint[] barcodeCoordinate : barcodeCoordinates) {
                    if (barcodeCoordinate[1] != null) {
                        row = (int)Math.max((float)row, barcodeCoordinate[1].getY());
                    }
                    if (barcodeCoordinate[3] == null) continue;
                    row = Math.max(row, (int)barcodeCoordinate[3].getY());
                }
                row += 5;
                continue;
            }
            foundBarcodeInRow = true;
            barcodeCoordinates.add(vertices);
            if (!multiple) break;
            if (vertices[2] != null) {
                column = (int)((ResultPoint)vertices[2]).getX();
                row = (int)((ResultPoint)vertices[2]).getY();
                continue;
            }
            column = (int)((ResultPoint)vertices[4]).getX();
            row = (int)((ResultPoint)vertices[4]).getY();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static ResultPoint[] findVertices(BitMatrix matrix, int startRow, int startColumn) {
        void var2_2;
        void var1_1;
        void var3_3;
        BitMatrix bitMatrix;
        int height = matrix.getHeight();
        int width = matrix.getWidth();
        ResultPoint[] result = new ResultPoint[8];
        Detector.copyToResult(result, Detector.findRowsWithPattern(matrix, height, width, startRow, startColumn, START_PATTERN), INDEXES_START_PATTERN);
        if (result[4] != null) {
            startColumn = (int)result[4].getX();
            startRow = (int)result[4].getY();
        }
        Detector.copyToResult(result, Detector.findRowsWithPattern(bitMatrix, (int)var3_3, width, (int)var1_1, (int)var2_2, STOP_PATTERN), INDEXES_STOP_PATTERN);
        return result;
    }

    private static void copyToResult(ResultPoint[] result, ResultPoint[] tmpResult, int[] destinationIndexes) {
        for (int i = 0; i < destinationIndexes.length; ++i) {
            result[destinationIndexes[i]] = tmpResult[i];
        }
    }

    /*
     * WARNING - void declaration
     */
    private static ResultPoint[] findRowsWithPattern(BitMatrix matrix, int height, int width, int startRow, int startColumn, int[] pattern) {
        void var3_3;
        int stopRow;
        boolean previousRowLoc2;
        ResultPoint[] result = new ResultPoint[4];
        boolean found = false;
        int[] counters = new int[pattern.length];
        while (startRow < height) {
            int[] loc = Detector.findGuardPattern(matrix, startColumn, startRow, width, false, pattern, counters);
            if (loc != null) {
                while (startRow > 0) {
                    int[] previousRowLoc2;
                    if ((previousRowLoc2 = Detector.findGuardPattern(matrix, startColumn, --startRow, width, false, pattern, counters)) != null) {
                        loc = previousRowLoc2;
                        continue;
                    }
                    ++startRow;
                    break;
                }
                result[0] = new ResultPoint(loc[0], startRow);
                result[1] = new ResultPoint(loc[1], startRow);
                previousRowLoc2 = true;
                break;
            }
            startRow += 5;
        }
        if (previousRowLoc2) {
            int skippedRowCount = 0;
            int[] previousRowLoc3 = new int[]{(int)result[0].getX(), (int)result[1].getX()};
            for (stopRow = startRow + 1; stopRow < height; ++stopRow) {
                int[] loc = Detector.findGuardPattern(matrix, previousRowLoc3[0], stopRow, width, false, pattern, counters);
                if (loc != null && Math.abs(previousRowLoc3[0] - loc[0]) < 5 && Math.abs(previousRowLoc3[1] - loc[1]) < 5) {
                    previousRowLoc3 = loc;
                    skippedRowCount = 0;
                    continue;
                }
                if (skippedRowCount > 25) break;
                ++skippedRowCount;
            }
            result[2] = new ResultPoint(previousRowLoc3[0], stopRow -= skippedRowCount + 1);
            result[3] = new ResultPoint(previousRowLoc3[1], stopRow);
        }
        if (stopRow - var3_3 < 10) {
            for (int i = 0; i < 4; ++i) {
                result[i] = null;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static int[] findGuardPattern(BitMatrix matrix, int column, int row, int width, boolean whiteFirst, int[] pattern, int[] counters) {
        void x;
        void patternStart;
        Arrays.fill(counters, 0, counters.length, 0);
        int pixelDrift = 0;
        while (matrix.get((int)patternStart, row) && patternStart > 0 && pixelDrift++ < 3) {
            --patternStart;
        }
        int counterPosition = 0;
        int patternLength = pattern.length;
        boolean isWhite = whiteFirst;
        for (x = patternStart; x < width; ++x) {
            if (matrix.get((int)x, row) ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (counterPosition == patternLength - 1) {
                if (Detector.patternMatchVariance(counters, pattern, 0.8f) < 0.42f) {
                    return new int[]{patternStart, x};
                }
                patternStart += counters[0] + counters[1];
                System.arraycopy(counters, 2, counters, 0, patternLength - 2);
                counters[patternLength - 2] = 0;
                counters[patternLength - 1] = 0;
                --counterPosition;
            } else {
                ++counterPosition;
            }
            counters[counterPosition] = 1;
            isWhite = !isWhite;
        }
        if (counterPosition == patternLength - 1 && Detector.patternMatchVariance(counters, pattern, 0.8f) < 0.42f) {
            void var1_1;
            return new int[]{var1_1, x - true};
        }
        return null;
    }

    private static float patternMatchVariance(int[] counters, int[] pattern, float maxIndividualVariance) {
        int numCounters = counters.length;
        int total = 0;
        int patternLength = 0;
        for (int i = 0; i < numCounters; ++i) {
            total += counters[i];
            patternLength += pattern[i];
        }
        if (total < patternLength) {
            return Float.POSITIVE_INFINITY;
        }
        float unitBarWidth = (float)total / (float)patternLength;
        maxIndividualVariance *= unitBarWidth;
        float totalVariance = 0.0f;
        for (int x = 0; x < numCounters; ++x) {
            float variance;
            int counter = counters[x];
            float scaledPattern = (float)pattern[x] * unitBarWidth;
            float f = variance = (float)counter > scaledPattern ? (float)counter - scaledPattern : scaledPattern - (float)counter;
            if (f > maxIndividualVariance) {
                return Float.POSITIVE_INFINITY;
            }
            totalVariance += variance;
        }
        return totalVariance / (float)total;
    }
}

