/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.pdf417.decoder.ec.ModulusPoly;

public final class ModulusGF {
    public static final ModulusGF PDF417_GF = new ModulusGF(929, 3);
    private final int[] expTable;
    private final int[] logTable;
    private final ModulusPoly zero;
    private final ModulusPoly one;
    private final int modulus;

    private ModulusGF(int modulus, int generator) {
        int i;
        this.modulus = modulus;
        this.expTable = new int[modulus];
        this.logTable = new int[modulus];
        int x = 1;
        for (i = 0; i < modulus; ++i) {
            this.expTable[i] = x;
            x = x * generator % modulus;
        }
        for (i = 0; i < modulus - 1; ++i) {
            this.logTable[this.expTable[i]] = i;
        }
        this.zero = new ModulusPoly(this, new int[]{0});
        this.one = new ModulusPoly(this, new int[]{1});
    }

    final ModulusPoly getZero() {
        return this.zero;
    }

    final ModulusPoly getOne() {
        return this.one;
    }

    /*
     * WARNING - void declaration
     */
    final ModulusPoly buildMonomial(int degree, int coefficient) {
        void var1_2;
        void var2_3;
        if (degree < 0) {
            throw new IllegalArgumentException();
        }
        if (coefficient == 0) {
            return this.zero;
        }
        int[] nArray = new int[degree + 1];
        int[] coefficients = nArray;
        nArray[0] = var2_3;
        return new ModulusPoly(this, (int[])var1_2);
    }

    /*
     * WARNING - void declaration
     */
    final int add(int a, int b) {
        void var2_2;
        return (a + var2_2) % this.modulus;
    }

    /*
     * WARNING - void declaration
     */
    final int subtract(int a, int b) {
        void var2_2;
        void var1_1;
        return (this.modulus + var1_1 - var2_2) % this.modulus;
    }

    /*
     * WARNING - void declaration
     */
    final int exp(int a) {
        void var1_1;
        return this.expTable[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    final int log(int a) {
        void var1_1;
        if (a == 0) {
            throw new IllegalArgumentException();
        }
        return this.logTable[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    final int inverse(int a) {
        void var1_1;
        if (a == 0) {
            throw new ArithmeticException();
        }
        return this.expTable[this.modulus - this.logTable[var1_1] - 1];
    }

    /*
     * WARNING - void declaration
     */
    final int multiply(int a, int b) {
        void var2_2;
        void var1_1;
        if (a == 0 || b == 0) {
            return 0;
        }
        return this.expTable[(this.logTable[var1_1] + this.logTable[var2_2]) % (this.modulus - 1)];
    }

    final int getSize() {
        return this.modulus;
    }
}

