/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.ChecksumException;
import com.google.zxing.pdf417.decoder.ec.ModulusGF;
import com.google.zxing.pdf417.decoder.ec.ModulusPoly;

public final class ErrorCorrection {
    private final ModulusGF field = ModulusGF.PDF417_GF;

    /*
     * WARNING - void declaration
     */
    public final int decode(int[] received, int numECCodewords, int[] erasures2) throws ChecksumException {
        ModulusPoly poly2 = new ModulusPoly(this.field, received);
        int[] S = new int[numECCodewords];
        boolean error = false;
        for (int i = numECCodewords; i > 0; --i) {
            int eval;
            S[numECCodewords - i] = eval = poly2.evaluateAt(this.field.exp(i));
            if (eval == 0) continue;
            error = true;
        }
        if (!error) {
            return 0;
        }
        ModulusPoly knownErrors = this.field.getOne();
        if (erasures2 != null) {
            int[] eval = erasures2;
            int erasures2 = erasures2.length;
            for (int poly2 = 0; poly2 < erasures2; ++poly2) {
                int erasure = eval[poly2];
                int b = this.field.exp(received.length - 1 - erasure);
                ModulusPoly term = new ModulusPoly(this.field, new int[]{this.field.subtract(0, b), 1});
                knownErrors = knownErrors.multiply(term);
            }
        }
        ModulusPoly syndrome = new ModulusPoly(this.field, S);
        ErrorCorrection errorCorrection = this;
        ModulusPoly[] sigmaOmega = errorCorrection.runEuclideanAlgorithm(errorCorrection.field.buildMonomial(numECCodewords, 1), syndrome, numECCodewords);
        ModulusPoly sigma = sigmaOmega[0];
        ModulusPoly omega = sigmaOmega[1];
        int[] errorLocations = this.findErrorLocations(sigma);
        int[] errorMagnitudes = this.findErrorMagnitudes(omega, sigma, errorLocations);
        for (int i = 0; i < errorLocations.length; ++i) {
            void var3_5;
            int position = received.length - 1 - this.field.log(errorLocations[i]);
            if (position < 0) {
                throw ChecksumException.getChecksumInstance();
            }
            received[position] = this.field.subtract(received[var3_5], errorMagnitudes[i]);
        }
        return errorLocations.length;
    }

    /*
     * WARNING - void declaration
     */
    private ModulusPoly[] runEuclideanAlgorithm(ModulusPoly a, ModulusPoly b, int R) throws ChecksumException {
        void var1_1;
        ModulusPoly q;
        if (a.getDegree() < b.getDegree()) {
            ModulusPoly temp = a;
            a = b;
            b = temp;
        }
        ModulusPoly rLast = a;
        ModulusPoly r = b;
        ModulusPoly tLast = this.field.getZero();
        ModulusPoly t = this.field.getOne();
        while (r.getDegree() >= R / 2) {
            ModulusPoly rLastLast = rLast;
            ModulusPoly tLastLast = tLast;
            rLast = r;
            tLast = t;
            if (rLast.isZero()) {
                throw ChecksumException.getChecksumInstance();
            }
            r = rLastLast;
            q = this.field.getZero();
            ModulusPoly modulusPoly = rLast;
            int denominatorLeadingTerm = modulusPoly.getCoefficient(modulusPoly.getDegree());
            int dltInverse = this.field.inverse(denominatorLeadingTerm);
            while (r.getDegree() >= rLast.getDegree() && !r.isZero()) {
                int degreeDiff = r.getDegree() - rLast.getDegree();
                ModulusPoly modulusPoly2 = r;
                int scale = this.field.multiply(modulusPoly2.getCoefficient(modulusPoly2.getDegree()), dltInverse);
                q = q.add(this.field.buildMonomial(degreeDiff, scale));
                r = r.subtract(rLast.multiplyByMonomial(degreeDiff, scale));
            }
            q = q.multiply(tLast).subtract(tLastLast).negative();
        }
        int sigmaTildeAtZero = q.getCoefficient(0);
        if (sigmaTildeAtZero == 0) {
            throw ChecksumException.getChecksumInstance();
        }
        int inverse = this.field.inverse(sigmaTildeAtZero);
        ModulusPoly sigma = q.multiply(inverse);
        ModulusPoly omega = var1_1.multiply(inverse);
        return new ModulusPoly[]{sigma, omega};
    }

    /*
     * WARNING - void declaration
     */
    private int[] findErrorLocations(ModulusPoly errorLocator) throws ChecksumException {
        void var3_3;
        void var2_2;
        int numErrors = errorLocator.getDegree();
        int[] result = new int[numErrors];
        int e = 0;
        for (int i = 1; i < this.field.getSize() && e < numErrors; ++i) {
            if (errorLocator.evaluateAt(i) != 0) continue;
            result[e] = this.field.inverse(i);
            ++e;
        }
        if (e != var2_2) {
            throw ChecksumException.getChecksumInstance();
        }
        return var3_3;
    }

    private int[] findErrorMagnitudes(ModulusPoly errorEvaluator, ModulusPoly errorLocator, int[] errorLocations) {
        int errorLocatorDegree = errorLocator.getDegree();
        int[] formalDerivativeCoefficients = new int[errorLocatorDegree];
        for (int i = 1; i <= errorLocatorDegree; ++i) {
            formalDerivativeCoefficients[errorLocatorDegree - i] = this.field.multiply(i, errorLocator.getCoefficient(i));
        }
        ModulusPoly formalDerivative = new ModulusPoly(this.field, formalDerivativeCoefficients);
        int s = errorLocations.length;
        int[] result = new int[s];
        for (int i = 0; i < s; ++i) {
            int xiInverse = this.field.inverse(errorLocations[i]);
            int numerator = this.field.subtract(0, errorEvaluator.evaluateAt(xiInverse));
            int denominator = this.field.inverse(formalDerivative.evaluateAt(xiInverse));
            result[i] = this.field.multiply(numerator, denominator);
        }
        return result;
    }
}

