/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.pdf417.PDF417Common;
import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BarcodeValue;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DecodedBitStreamParser;
import com.google.zxing.pdf417.decoder.DetectionResult;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;
import com.google.zxing.pdf417.decoder.DetectionResultRowIndicatorColumn;
import com.google.zxing.pdf417.decoder.PDF417CodewordDecoder;
import com.google.zxing.pdf417.decoder.ec.ErrorCorrection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    public static DecoderResult decode(BitMatrix image, ResultPoint imageTopLeft, ResultPoint imageBottomLeft, ResultPoint imageTopRight, ResultPoint imageBottomRight, int minCodewordWidth, int maxCodewordWidth) throws NotFoundException, FormatException, ChecksumException {
        BoundingBox boundingBox = new BoundingBox(image, imageTopLeft, imageBottomLeft, imageTopRight, imageBottomRight);
        DetectionResultRowIndicatorColumn leftRowIndicatorColumn = null;
        DetectionResultRowIndicatorColumn rightRowIndicatorColumn = null;
        DetectionResult detectionResult = null;
        for (int i = 0; i < 2; ++i) {
            if (imageTopLeft != null) {
                leftRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(image, boundingBox, imageTopLeft, true, minCodewordWidth, maxCodewordWidth);
            }
            if (imageTopRight != null) {
                rightRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(image, boundingBox, imageTopRight, false, minCodewordWidth, maxCodewordWidth);
            }
            if ((detectionResult = PDF417ScanningDecoder.merge(leftRowIndicatorColumn, rightRowIndicatorColumn)) == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            if (i != 0 || detectionResult.getBoundingBox() == null || detectionResult.getBoundingBox().getMinY() >= boundingBox.getMinY() && detectionResult.getBoundingBox().getMaxY() <= boundingBox.getMaxY()) {
                detectionResult.setBoundingBox(boundingBox);
                break;
            }
            boundingBox = detectionResult.getBoundingBox();
        }
        int maxBarcodeColumn = detectionResult.getBarcodeColumnCount() + 1;
        detectionResult.setDetectionResultColumn(0, leftRowIndicatorColumn);
        detectionResult.setDetectionResultColumn(maxBarcodeColumn, rightRowIndicatorColumn);
        boolean leftToRight = leftRowIndicatorColumn != null;
        for (int barcodeColumnCount = 1; barcodeColumnCount <= maxBarcodeColumn; ++barcodeColumnCount) {
            int barcodeColumn;
            int n = barcodeColumn = leftToRight ? barcodeColumnCount : maxBarcodeColumn - barcodeColumnCount;
            if (detectionResult.getDetectionResultColumn(barcodeColumn) != null) continue;
            DetectionResultColumn detectionResultColumn = barcodeColumn == 0 || barcodeColumn == maxBarcodeColumn ? new DetectionResultRowIndicatorColumn(boundingBox, barcodeColumn == 0) : new DetectionResultColumn(boundingBox);
            detectionResult.setDetectionResultColumn(barcodeColumn, detectionResultColumn);
            int previousStartColumn = -1;
            for (int imageRow = boundingBox.getMinY(); imageRow <= boundingBox.getMaxY(); ++imageRow) {
                Codeword codeword;
                int startColumn = PDF417ScanningDecoder.getStartColumn(detectionResult, barcodeColumn, imageRow, leftToRight);
                if (startColumn < 0 || startColumn > boundingBox.getMaxX()) {
                    if (previousStartColumn == -1) continue;
                    startColumn = previousStartColumn;
                }
                if ((codeword = PDF417ScanningDecoder.detectCodeword(image, boundingBox.getMinX(), boundingBox.getMaxX(), leftToRight, startColumn, imageRow, minCodewordWidth, maxCodewordWidth)) == null) continue;
                detectionResultColumn.setCodeword(imageRow, codeword);
                previousStartColumn = startColumn;
                minCodewordWidth = Math.min(minCodewordWidth, codeword.getWidth());
                maxCodewordWidth = Math.max(maxCodewordWidth, codeword.getWidth());
            }
        }
        return PDF417ScanningDecoder.createDecoderResult(detectionResult);
    }

    /*
     * WARNING - void declaration
     */
    private static DetectionResult merge(DetectionResultRowIndicatorColumn leftRowIndicatorColumn, DetectionResultRowIndicatorColumn rightRowIndicatorColumn) throws NotFoundException {
        BoundingBox boundingBox;
        void var2_2;
        void var1_1;
        if (leftRowIndicatorColumn == null && rightRowIndicatorColumn == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata(leftRowIndicatorColumn, rightRowIndicatorColumn);
        if (barcodeMetadata == null) {
            return null;
        }
        BoundingBox boundingBox2 = BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox(leftRowIndicatorColumn), PDF417ScanningDecoder.adjustBoundingBox((DetectionResultRowIndicatorColumn)var1_1));
        return new DetectionResult((BarcodeMetadata)var2_2, boundingBox);
    }

    /*
     * WARNING - void declaration
     */
    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn rowIndicatorColumn) throws NotFoundException {
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn;
        void var3_3;
        int row;
        if (rowIndicatorColumn == null) {
            return null;
        }
        int[] rowHeights = rowIndicatorColumn.getRowHeights();
        if (rowHeights == null) {
            return null;
        }
        int maxRowHeight = PDF417ScanningDecoder.getMax(rowHeights);
        int missingStartRows = 0;
        int[] nArray = rowHeights;
        int n = rowHeights.length;
        for (int i = 0; i < n; ++i) {
            int rowHeight = nArray[i];
            missingStartRows += maxRowHeight - rowHeight;
            if (rowHeight > 0) break;
        }
        Codeword[] codewords = rowIndicatorColumn.getCodewords();
        int row2 = 0;
        while (missingStartRows > 0 && codewords[row2] == null) {
            --missingStartRows;
            ++row2;
        }
        int missingEndRows = 0;
        for (row = rowHeights.length - 1; row >= 0; --row) {
            missingEndRows += maxRowHeight - rowHeights[row];
            if (rowHeights[row] > 0) break;
        }
        row = codewords.length - 1;
        while (missingEndRows > 0 && codewords[row] == null) {
            --missingEndRows;
            --row;
        }
        return rowIndicatorColumn.getBoundingBox().addMissingRows((int)var3_3, missingEndRows, detectionResultRowIndicatorColumn.isLeft());
    }

    /*
     * WARNING - void declaration
     */
    private static int getMax(int[] values) {
        void var1_1;
        int[] nArray;
        int maxValue = -1;
        for (int value : nArray) {
            maxValue = Math.max(maxValue, value);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn leftRowIndicatorColumn, DetectionResultRowIndicatorColumn rightRowIndicatorColumn) {
        Object object;
        void var1_1;
        BarcodeMetadata rightBarcodeMetadata;
        Object leftBarcodeMetadata;
        if (leftRowIndicatorColumn == null || (leftBarcodeMetadata = leftRowIndicatorColumn.getBarcodeMetadata()) == null) {
            if (rightRowIndicatorColumn == null) {
                return null;
            }
            return rightRowIndicatorColumn.getBarcodeMetadata();
        }
        if (rightRowIndicatorColumn == null || (rightBarcodeMetadata = rightRowIndicatorColumn.getBarcodeMetadata()) == null) {
            return leftBarcodeMetadata;
        }
        if (((BarcodeMetadata)leftBarcodeMetadata).getColumnCount() != rightBarcodeMetadata.getColumnCount() && ((BarcodeMetadata)leftBarcodeMetadata).getErrorCorrectionLevel() != rightBarcodeMetadata.getErrorCorrectionLevel() && ((BarcodeMetadata)leftBarcodeMetadata).getRowCount() != var1_1.getRowCount()) {
            return null;
        }
        return object;
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix image, BoundingBox boundingBox, ResultPoint startPoint, boolean leftToRight, int minCodewordWidth, int maxCodewordWidth) {
        DetectionResultRowIndicatorColumn rowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, leftToRight);
        for (int i = 0; i < 2; ++i) {
            int increment = i == 0 ? 1 : -1;
            int startColumn = (int)startPoint.getX();
            for (int imageRow = (int)startPoint.getY(); imageRow <= boundingBox.getMaxY() && imageRow >= boundingBox.getMinY(); imageRow += increment) {
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(image, 0, image.getWidth(), leftToRight, startColumn, imageRow, minCodewordWidth, maxCodewordWidth);
                if (codeword == null) continue;
                rowIndicatorColumn.setCodeword(imageRow, codeword);
                startColumn = leftToRight ? codeword.getStartX() : codeword.getEndX();
            }
        }
        return rowIndicatorColumn;
    }

    /*
     * WARNING - void declaration
     */
    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] barcodeMatrix) throws NotFoundException {
        void var2_3;
        int[] numberOfCodewords = barcodeMatrix[0][1].getValue();
        int calculatedNumberOfCodewords = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (numberOfCodewords.length == 0) {
            if (calculatedNumberOfCodewords <= 0 || calculatedNumberOfCodewords > 928) {
                throw NotFoundException.getNotFoundInstance();
            }
            barcodeMatrix[0][1].setValue(calculatedNumberOfCodewords);
            return;
        }
        if (var2_3[0] != calculatedNumberOfCodewords) {
            void var0_1;
            void var1_2;
            var1_2[0][1].setValue((int)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static DecoderResult createDecoderResult(DetectionResult detectionResult) throws FormatException, ChecksumException, NotFoundException {
        void var2_2;
        void var3_3;
        DetectionResult detectionResult2;
        BarcodeValue[][] barcodeMatrix = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeMatrix);
        ArrayList<Integer> erasures = new ArrayList<Integer>();
        int[] codewords = new int[detectionResult.getBarcodeRowCount() * detectionResult.getBarcodeColumnCount()];
        ArrayList<int[]> ambiguousIndexValuesList = new ArrayList<int[]>();
        ArrayList<Integer> ambiguousIndexesList = new ArrayList<Integer>();
        for (int row = 0; row < detectionResult.getBarcodeRowCount(); ++row) {
            for (int column = 0; column < detectionResult.getBarcodeColumnCount(); ++column) {
                int[] values = barcodeMatrix[row][column + 1].getValue();
                int codewordIndex = row * detectionResult.getBarcodeColumnCount() + column;
                if (values.length == 0) {
                    erasures.add(codewordIndex);
                    continue;
                }
                if (values.length == 1) {
                    codewords[codewordIndex] = values[0];
                    continue;
                }
                ambiguousIndexesList.add(codewordIndex);
                ambiguousIndexValuesList.add(values);
            }
        }
        int[][] ambiguousIndexValues = new int[ambiguousIndexValuesList.size()][];
        for (int i = 0; i < ambiguousIndexValues.length; ++i) {
            ambiguousIndexValues[i] = (int[])ambiguousIndexValuesList.get(i);
        }
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(detectionResult2.getBarcodeECLevel(), (int[])var3_3, PDF417Common.toIntArray((Collection<Integer>)var2_2), PDF417Common.toIntArray(ambiguousIndexesList), ambiguousIndexValues);
    }

    private static DecoderResult createDecoderResultFromAmbiguousValues(int ecLevel, int[] codewords, int[] erasureArray, int[] ambiguousIndexes, int[][] ambiguousIndexValues) throws FormatException, ChecksumException {
        int[] ambiguousIndexCount = new int[ambiguousIndexes.length];
        int tries = 100;
        block2: while (tries-- > 0) {
            int i;
            for (i = 0; i < ambiguousIndexCount.length; ++i) {
                codewords[ambiguousIndexes[i]] = ambiguousIndexValues[i][ambiguousIndexCount[i]];
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(codewords, ecLevel, erasureArray);
            }
            catch (ChecksumException checksumException) {
                if (ambiguousIndexCount.length == 0) {
                    throw ChecksumException.getChecksumInstance();
                }
                for (i = 0; i < ambiguousIndexCount.length; ++i) {
                    if (ambiguousIndexCount[i] < ambiguousIndexValues[i].length - 1) {
                        int n = i;
                        ambiguousIndexCount[n] = ambiguousIndexCount[n] + 1;
                        continue block2;
                    }
                    ambiguousIndexCount[i] = 0;
                    if (i != ambiguousIndexCount.length - 1) continue;
                    throw ChecksumException.getChecksumInstance();
                }
            }
        }
        throw ChecksumException.getChecksumInstance();
    }

    /*
     * WARNING - void declaration
     */
    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResult) {
        void var1_2;
        DetectionResult detectionResult2;
        BarcodeValue[][] barcodeMatrix = new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        for (int row = 0; row < barcodeMatrix.length; ++row) {
            for (int column = 0; column < barcodeMatrix[row].length; ++column) {
                barcodeMatrix[row][column] = new BarcodeValue();
            }
        }
        int column = 0;
        for (DetectionResultColumn detectionResultColumn : detectionResult2.getDetectionResultColumns()) {
            if (detectionResultColumn != null) {
                for (Codeword codeword : detectionResultColumn.getCodewords()) {
                    int rowNumber;
                    if (codeword == null || (rowNumber = codeword.getRowNumber()) < 0 || rowNumber >= barcodeMatrix.length) continue;
                    barcodeMatrix[rowNumber][column].setValue(codeword.getValue());
                }
            }
            ++column;
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int barcodeColumn) {
        DetectionResult detectionResult2;
        void var1_1;
        return barcodeColumn >= 0 && var1_1 <= detectionResult2.getBarcodeColumnCount() + 1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getStartColumn(DetectionResult detectionResult, int barcodeColumn, int imageRow, boolean leftToRight) {
        DetectionResult detectionResult2;
        void var3_3;
        int offset = leftToRight ? 1 : -1;
        Codeword codeword = null;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            codeword = detectionResult.getDetectionResultColumn(barcodeColumn - offset).getCodeword(imageRow);
        }
        if (codeword != null) {
            if (leftToRight) {
                return codeword.getEndX();
            }
            return codeword.getStartX();
        }
        codeword = detectionResult.getDetectionResultColumn(barcodeColumn).getCodewordNearby(imageRow);
        if (codeword != null) {
            if (leftToRight) {
                return codeword.getStartX();
            }
            return codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            codeword = detectionResult.getDetectionResultColumn(barcodeColumn - offset).getCodewordNearby(imageRow);
        }
        if (codeword != null) {
            if (leftToRight) {
                return codeword.getEndX();
            }
            return codeword.getStartX();
        }
        int skippedColumns = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, barcodeColumn - offset)) {
            for (Codeword previousRowCodeword : detectionResult.getDetectionResultColumn(barcodeColumn -= offset).getCodewords()) {
                if (previousRowCodeword == null) continue;
                return (leftToRight ? previousRowCodeword.getEndX() : previousRowCodeword.getStartX()) + offset * skippedColumns * (previousRowCodeword.getEndX() - previousRowCodeword.getStartX());
            }
            ++skippedColumns;
        }
        if (var3_3 != false) {
            return detectionResult.getBoundingBox().getMinX();
        }
        return detectionResult2.getBoundingBox().getMaxX();
    }

    /*
     * WARNING - void declaration
     */
    private static Codeword detectCodeword(BitMatrix image, int minColumn, int maxColumn, boolean leftToRight, int startColumn, int imageRow, int minCodewordWidth, int maxCodewordWidth) {
        void var3_3;
        void var1_1;
        Object object;
        void var2_2;
        int endColumn;
        startColumn = PDF417ScanningDecoder.adjustCodewordStartColumn(image, minColumn, maxColumn, leftToRight, startColumn, imageRow);
        int[] nArray = PDF417ScanningDecoder.getModuleBitCount(image, minColumn, maxColumn, leftToRight, startColumn, imageRow);
        Object moduleBitCount = nArray;
        if (nArray == null) {
            return null;
        }
        int codewordBitCount = MathUtils.sum((int[])moduleBitCount);
        if (leftToRight) {
            endColumn = startColumn + codewordBitCount;
        } else {
            for (int i = 0; i < ((Object)moduleBitCount).length / 2; ++i) {
                Object tmpCount = moduleBitCount[i];
                Object object2 = moduleBitCount;
                moduleBitCount[i] = object2[((Object)object2).length - 1 - i];
                Object object3 = moduleBitCount;
                object3[((Object)object3).length - 1 - i] = tmpCount;
            }
            endColumn = startColumn;
            startColumn -= codewordBitCount;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew((int)var2_2, minCodewordWidth, maxCodewordWidth)) {
            return null;
        }
        int decodedValue = PDF417CodewordDecoder.getDecodedValue((int[])object);
        int codeword = PDF417Common.getCodeword(decodedValue);
        if (codeword == -1) {
            return null;
        }
        return new Codeword(startColumn, (int)var1_1, PDF417ScanningDecoder.getCodewordBucketNumber((int)var3_3), codeword);
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getModuleBitCount(BitMatrix image, int minColumn, int maxColumn, boolean leftToRight, int startColumn, int imageRow) {
        void var1_1;
        void var2_2;
        void var3_3;
        int imageColumn = startColumn;
        int[] moduleBitCount = new int[8];
        int moduleNumber = 0;
        int increment = leftToRight ? 1 : -1;
        boolean previousPixelValue = leftToRight;
        while ((leftToRight ? imageColumn < maxColumn : imageColumn >= minColumn) && moduleNumber < 8) {
            if (image.get(imageColumn, imageRow) == previousPixelValue) {
                int n = moduleNumber;
                moduleBitCount[n] = moduleBitCount[n] + 1;
                imageColumn += increment;
                continue;
            }
            ++moduleNumber;
            previousPixelValue = !previousPixelValue;
        }
        if (moduleNumber == 8 || imageColumn == (var3_3 != false ? var2_2 : var1_1) && moduleNumber == 7) {
            return moduleBitCount;
        }
        return null;
    }

    private static int getNumberOfECCodeWords(int barcodeECLevel) {
        int n;
        return 2 << n;
    }

    private static int adjustCodewordStartColumn(BitMatrix image, int minColumn, int maxColumn, boolean leftToRight, int codewordStartColumn, int imageRow) {
        int correctedStartColumn = codewordStartColumn;
        int increment = leftToRight ? -1 : 1;
        for (int i = 0; i < 2; ++i) {
            while ((leftToRight ? correctedStartColumn >= minColumn : correctedStartColumn < maxColumn) && leftToRight == image.get(correctedStartColumn, imageRow)) {
                if (Math.abs(codewordStartColumn - correctedStartColumn) > 2) {
                    return codewordStartColumn;
                }
                correctedStartColumn += increment;
            }
            increment = -increment;
            leftToRight = !leftToRight;
        }
        return correctedStartColumn;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkCodewordSkew(int codewordSize, int minCodewordWidth, int maxCodewordWidth) {
        void var2_2;
        int n;
        return minCodewordWidth - 2 <= codewordSize && n <= var2_2 + 2;
    }

    /*
     * WARNING - void declaration
     */
    private static DecoderResult decodeCodewords(int[] codewords, int ecLevel, int[] erasures) throws FormatException, ChecksumException {
        Object object;
        void var2_2;
        void var1_1;
        void var3_3;
        if (codewords.length == 0) {
            throw FormatException.getFormatInstance();
        }
        int numECCodewords = 1 << ecLevel + 1;
        int correctedErrorsCount = PDF417ScanningDecoder.correctErrors(codewords, erasures, numECCodewords);
        PDF417ScanningDecoder.verifyCodewordCount(codewords, (int)var3_3);
        DecoderResult decoderResult = DecodedBitStreamParser.decode(codewords, String.valueOf((int)var1_1));
        Object decoderResult2 = decoderResult;
        decoderResult.setErrorsCorrected(correctedErrorsCount);
        ((DecoderResult)decoderResult2).setErasures(((void)var2_2).length);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static int correctErrors(int[] codewords, int[] erasures, int numECCodewords) throws ChecksumException {
        void var1_1;
        void var2_2;
        int[] nArray;
        if (erasures != null && erasures.length > numECCodewords / 2 + 3 || numECCodewords < 0 || numECCodewords > 512) {
            throw ChecksumException.getChecksumInstance();
        }
        return errorCorrection.decode(nArray, (int)var2_2, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyCodewordCount(int[] codewords, int numECCodewords) throws FormatException {
        void var2_2;
        if (codewords.length < 4) {
            throw FormatException.getFormatInstance();
        }
        int numberOfCodewords = codewords[0];
        if (numberOfCodewords > codewords.length) {
            throw FormatException.getFormatInstance();
        }
        if (var2_2 == false) {
            if (numECCodewords < codewords.length) {
                void var1_1;
                int[] nArray;
                codewords[0] = nArray.length - var1_1;
                return;
            }
            throw FormatException.getFormatInstance();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getBitCountForCodeword(int codeword) {
        void var1_1;
        int[] result = new int[8];
        int previousValue = 0;
        int i = 7;
        while (true) {
            if ((codeword & 1) != previousValue) {
                previousValue = codeword & 1;
                if (--i < 0) break;
            }
            int n = i;
            result[n] = result[n] + 1;
            codeword >>= 1;
        }
        return var1_1;
    }

    private static int getCodewordBucketNumber(int codeword) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(codeword));
    }

    private static int getCodewordBucketNumber(int[] moduleBitCount) {
        int[] nArray;
        return (moduleBitCount[0] - moduleBitCount[2] + moduleBitCount[4] - nArray[6] + 9) % 9;
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(BarcodeValue[][] barcodeMatrix) {
        void var2_3;
        void var1_1;
        Formatter formatter = new Formatter();
        for (int row = 0; row < barcodeMatrix.length; ++row) {
            formatter.format("Row %2d: ", row);
            for (int column = 0; column < barcodeMatrix[row].length; ++column) {
                BarcodeValue barcodeValue = barcodeMatrix[row][column];
                if (barcodeValue.getValue().length == 0) {
                    formatter.format("        ", null);
                    continue;
                }
                Object[] objectArray = new Object[2];
                objectArray[0] = barcodeValue.getValue()[0];
                BarcodeValue barcodeValue2 = barcodeValue;
                objectArray[1] = barcodeValue2.getConfidence(barcodeValue2.getValue()[0]);
                formatter.format("%4d(%2d)", objectArray);
            }
            formatter.format("%n", new Object[0]);
        }
        String result = formatter.toString();
        var1_1.close();
        return var2_3;
    }
}

