/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.pdf417.PDF417Common;

final class PDF417CodewordDecoder {
    private static final float[][] RATIOS_TABLE = new float[PDF417Common.SYMBOL_TABLE.length][8];

    private PDF417CodewordDecoder() {
    }

    /*
     * WARNING - void declaration
     */
    static int getDecodedValue(int[] moduleBitCount) {
        int[] nArray;
        int decodedValue = PDF417CodewordDecoder.getDecodedCodewordValue(PDF417CodewordDecoder.sampleBitCounts(moduleBitCount));
        if (decodedValue != -1) {
            void var1_1;
            return (int)var1_1;
        }
        return PDF417CodewordDecoder.getClosestDecodedValue(nArray);
    }

    /*
     * WARNING - void declaration
     */
    private static int[] sampleBitCounts(int[] moduleBitCount) {
        void var2_2;
        float bitCountSum = MathUtils.sum(moduleBitCount);
        int[] result = new int[8];
        int bitCountIndex = 0;
        int sumPreviousBits = 0;
        for (int i = 0; i < 17; ++i) {
            float sampleIndex = bitCountSum / 34.0f + (float)i * bitCountSum / 17.0f;
            if ((float)(sumPreviousBits + moduleBitCount[bitCountIndex]) <= sampleIndex) {
                sumPreviousBits += moduleBitCount[bitCountIndex];
            }
            int n = ++bitCountIndex;
            result[n] = result[n] + 1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static int getDecodedCodewordValue(int[] moduleBitCount) {
        void var0_1;
        int decodedValue = PDF417CodewordDecoder.getBitValue(moduleBitCount);
        if (PDF417Common.getCodeword(decodedValue) == -1) {
            return -1;
        }
        return (int)var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getBitValue(int[] moduleBitCount) {
        void var1_1;
        long result = 0L;
        for (int i = 0; i < moduleBitCount.length; ++i) {
            for (int bit = 0; bit < moduleBitCount[i]; ++bit) {
                result = result << 1 | (long)(i % 2 == 0 ? 1 : 0);
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int getClosestDecodedValue(int[] moduleBitCount) {
        void var0_1;
        int bitCountSum = MathUtils.sum(moduleBitCount);
        float[] bitCountRatios = new float[8];
        for (int i = 0; i < 8; ++i) {
            bitCountRatios[i] = (float)moduleBitCount[i] / (float)bitCountSum;
        }
        float bestMatchError = Float.MAX_VALUE;
        int bestMatch = -1;
        for (int j = 0; j < RATIOS_TABLE.length; ++j) {
            float error = 0.0f;
            float[] ratioTableRow = RATIOS_TABLE[j];
            for (int k = 0; k < 8; ++k) {
                float diff;
                float f = diff = ratioTableRow[k] - bitCountRatios[k];
                if ((error += f * f) >= bestMatchError) break;
            }
            if (!(error < bestMatchError)) continue;
            bestMatchError = error;
            bestMatch = PDF417Common.SYMBOL_TABLE[j];
        }
        return (int)var0_1;
    }

    static {
        for (int i = 0; i < PDF417Common.SYMBOL_TABLE.length; ++i) {
            int currentSymbol = PDF417Common.SYMBOL_TABLE[i];
            int currentBit = currentSymbol & 1;
            for (int j = 0; j < 8; ++j) {
                float size = 0.0f;
                while ((currentSymbol & 1) == currentBit) {
                    size += 1.0f;
                    currentSymbol >>= 1;
                }
                currentBit = currentSymbol & 1;
                PDF417CodewordDecoder.RATIOS_TABLE[i][8 - j - 1] = size / 17.0f;
            }
        }
    }
}

