/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import java.util.Formatter;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    /*
     * WARNING - void declaration
     */
    DetectionResultColumn(BoundingBox boundingBox) {
        void var1_1;
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - var1_1.getMinY() + 1];
    }

    /*
     * WARNING - void declaration
     */
    final Codeword getCodewordNearby(int imageRow) {
        Codeword codeword = this.getCodeword(imageRow);
        if (codeword != null) {
            return codeword;
        }
        for (int i = 1; i < 5; ++i) {
            void var2_5;
            Codeword codeword2;
            int nearImageRow = this.imageRowToCodewordIndex(imageRow) - i;
            if (nearImageRow >= 0 && (nearImageRow = this.codewords[nearImageRow]) != null) {
                return nearImageRow;
            }
            nearImageRow = this.imageRowToCodewordIndex(imageRow) + i;
            if (nearImageRow >= this.codewords.length || (codeword2 = this.codewords[var2_5]) == null) continue;
            return codeword2;
        }
        return null;
    }

    final int imageRowToCodewordIndex(int imageRow) {
        return imageRow - this.boundingBox.getMinY();
    }

    /*
     * WARNING - void declaration
     */
    final void setCodeword(int imageRow, Codeword codeword) {
        void var2_2;
        this.codewords[this.imageRowToCodewordIndex((int)var1_1)] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final Codeword getCodeword(int imageRow) {
        void var1_1;
        return this.codewords[this.imageRowToCodewordIndex((int)var1_1)];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        Formatter formatter = new Formatter();
        int row = 0;
        Codeword[] codewordArray = this.codewords;
        int n = this.codewords.length;
        for (int i = 0; i < n; ++i) {
            Codeword codeword = codewordArray[i];
            if (codeword == null) {
                formatter.format("%3d:    |   %n", row++);
                continue;
            }
            formatter.format("%3d: %3d|%3d%n", row++, codeword.getRowNumber(), codeword.getValue());
        }
        String result = formatter.toString();
        var1_1.close();
        return codewordArray;
    }
}

