/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;
import com.google.zxing.pdf417.decoder.DetectionResultRowIndicatorColumn;
import java.util.Formatter;

final class DetectionResult {
    private static final int ADJUST_ROW_NUMBER_SKIP = 2;
    private final BarcodeMetadata barcodeMetadata;
    private final DetectionResultColumn[] detectionResultColumns;
    private BoundingBox boundingBox;
    private final int barcodeColumnCount;

    /*
     * WARNING - void declaration
     */
    DetectionResult(BarcodeMetadata barcodeMetadata, BoundingBox boundingBox) {
        void var2_2;
        void var1_1;
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = var1_1.getColumnCount();
        this.boundingBox = var2_2;
        this.detectionResultColumns = new DetectionResultColumn[this.barcodeColumnCount + 2];
    }

    /*
     * WARNING - void declaration
     */
    final DetectionResultColumn[] getDetectionResultColumns() {
        void var2_2;
        DetectionResult detectionResult = this;
        detectionResult.adjustIndicatorColumnRowNumbers(detectionResult.detectionResultColumns[0]);
        DetectionResult detectionResult2 = this;
        detectionResult2.adjustIndicatorColumnRowNumbers(detectionResult2.detectionResultColumns[this.barcodeColumnCount + 1]);
        int unadjustedCodewordCount = 928;
        do {
            int previousUnadjustedCount = unadjustedCodewordCount;
        } while ((unadjustedCodewordCount = this.adjustRowNumbers()) > 0 && unadjustedCodewordCount < var2_2);
        return this.detectionResultColumns;
    }

    /*
     * WARNING - void declaration
     */
    private void adjustIndicatorColumnRowNumbers(DetectionResultColumn detectionResultColumn) {
        if (detectionResultColumn != null) {
            void var1_1;
            ((DetectionResultRowIndicatorColumn)var1_1).adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    }

    /*
     * WARNING - void declaration
     */
    private int adjustRowNumbers() {
        void var1_1;
        int unadjustedCount = this.adjustRowNumbersByRow();
        if (unadjustedCount == 0) {
            return 0;
        }
        for (int barcodeColumn = 1; barcodeColumn < this.barcodeColumnCount + 1; ++barcodeColumn) {
            Codeword[] codewords = this.detectionResultColumns[barcodeColumn].getCodewords();
            for (int codewordsRow = 0; codewordsRow < codewords.length; ++codewordsRow) {
                if (codewords[codewordsRow] == null || codewords[codewordsRow].hasValidRowNumber()) continue;
                this.adjustRowNumbers(barcodeColumn, codewordsRow, codewords);
            }
        }
        return (int)var1_1;
    }

    private int adjustRowNumbersByRow() {
        this.adjustRowNumbersFromBothRI();
        return this.adjustRowNumbersFromLRI() + this.adjustRowNumbersFromRRI();
    }

    private void adjustRowNumbersFromBothRI() {
        if (this.detectionResultColumns[0] == null || this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return;
        }
        Codeword[] LRIcodewords = this.detectionResultColumns[0].getCodewords();
        Codeword[] RRIcodewords = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (int codewordsRow = 0; codewordsRow < LRIcodewords.length; ++codewordsRow) {
            if (LRIcodewords[codewordsRow] == null || RRIcodewords[codewordsRow] == null || LRIcodewords[codewordsRow].getRowNumber() != RRIcodewords[codewordsRow].getRowNumber()) continue;
            for (int barcodeColumn = 1; barcodeColumn <= this.barcodeColumnCount; ++barcodeColumn) {
                Codeword codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                if (codeword == null) continue;
                codeword.setRowNumber(LRIcodewords[codewordsRow].getRowNumber());
                if (codeword.hasValidRowNumber()) continue;
                this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow] = null;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private int adjustRowNumbersFromRRI() {
        void var1_1;
        if (this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return 0;
        }
        int unadjustedCount = 0;
        Codeword[] codewords = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (int codewordsRow = 0; codewordsRow < codewords.length; ++codewordsRow) {
            if (codewords[codewordsRow] == null) continue;
            int rowIndicatorRowNumber = codewords[codewordsRow].getRowNumber();
            int invalidRowCounts = 0;
            for (int barcodeColumn = this.barcodeColumnCount + 1; barcodeColumn > 0 && invalidRowCounts < 2; --barcodeColumn) {
                Codeword codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                if (codeword == null) continue;
                invalidRowCounts = DetectionResult.adjustRowNumberIfValid(rowIndicatorRowNumber, invalidRowCounts, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++unadjustedCount;
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int adjustRowNumbersFromLRI() {
        void var1_1;
        if (this.detectionResultColumns[0] == null) {
            return 0;
        }
        int unadjustedCount = 0;
        Codeword[] codewords = this.detectionResultColumns[0].getCodewords();
        for (int codewordsRow = 0; codewordsRow < codewords.length; ++codewordsRow) {
            if (codewords[codewordsRow] == null) continue;
            int rowIndicatorRowNumber = codewords[codewordsRow].getRowNumber();
            int invalidRowCounts = 0;
            for (int barcodeColumn = 1; barcodeColumn < this.barcodeColumnCount + 1 && invalidRowCounts < 2; ++barcodeColumn) {
                Codeword codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                if (codeword == null) continue;
                invalidRowCounts = DetectionResult.adjustRowNumberIfValid(rowIndicatorRowNumber, invalidRowCounts, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++unadjustedCount;
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int adjustRowNumberIfValid(int rowIndicatorRowNumber, int invalidRowCounts, Codeword codeword) {
        void var1_1;
        if (codeword == null) {
            return invalidRowCounts;
        }
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(rowIndicatorRowNumber)) {
                int n;
                void var2_2;
                var2_2.setRowNumber(n);
                invalidRowCounts = 0;
            } else {
                ++invalidRowCounts;
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void adjustRowNumbers(int barcodeColumn, int codewordsRow, Codeword[] codewords) {
        int n;
        Codeword[] previousColumnCodewords;
        Codeword codeword = codewords[codewordsRow];
        Codeword[] nextColumnCodewords = previousColumnCodewords = this.detectionResultColumns[barcodeColumn - 1].getCodewords();
        if (this.detectionResultColumns[barcodeColumn + 1] != null) {
            nextColumnCodewords = this.detectionResultColumns[barcodeColumn + 1].getCodewords();
        }
        Codeword[] codewordArray = new Codeword[14];
        Codeword[] otherCodewords = codewordArray;
        codewordArray[2] = previousColumnCodewords[codewordsRow];
        otherCodewords[3] = nextColumnCodewords[codewordsRow];
        if (codewordsRow > 0) {
            otherCodewords[0] = codewords[codewordsRow - 1];
            otherCodewords[4] = previousColumnCodewords[codewordsRow - 1];
            otherCodewords[5] = nextColumnCodewords[codewordsRow - 1];
        }
        if (codewordsRow > 1) {
            otherCodewords[8] = codewords[codewordsRow - 2];
            otherCodewords[10] = previousColumnCodewords[codewordsRow - 2];
            otherCodewords[11] = nextColumnCodewords[codewordsRow - 2];
        }
        if (codewordsRow < codewords.length - 1) {
            otherCodewords[1] = codewords[codewordsRow + 1];
            otherCodewords[6] = previousColumnCodewords[codewordsRow + 1];
            otherCodewords[7] = nextColumnCodewords[codewordsRow + 1];
        }
        if (codewordsRow < codewords.length - 2) {
            otherCodewords[9] = codewords[codewordsRow + 2];
            otherCodewords[12] = previousColumnCodewords[codewordsRow + 2];
            otherCodewords[13] = nextColumnCodewords[n + 2];
        }
        for (n = 0; n < 14; ++n) {
            void var3_4;
            void var1_2;
            void otherCodeword = var1_2[n];
            if (!DetectionResult.adjustRowNumber(codeword, (Codeword)var3_4)) continue;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean adjustRowNumber(Codeword codeword, Codeword otherCodeword) {
        if (otherCodeword == null) {
            return false;
        }
        if (otherCodeword.hasValidRowNumber() && otherCodeword.getBucket() == codeword.getBucket()) {
            void var1_1;
            Codeword codeword2;
            codeword2.setRowNumber(var1_1.getRowNumber());
            return true;
        }
        return false;
    }

    final int getBarcodeColumnCount() {
        return this.barcodeColumnCount;
    }

    final int getBarcodeRowCount() {
        return this.barcodeMetadata.getRowCount();
    }

    final int getBarcodeECLevel() {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    }

    /*
     * WARNING - void declaration
     */
    public final void setBoundingBox(BoundingBox boundingBox) {
        void var1_1;
        this.boundingBox = var1_1;
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    /*
     * WARNING - void declaration
     */
    final void setDetectionResultColumn(int barcodeColumn, DetectionResultColumn detectionResultColumn) {
        void var2_2;
        this.detectionResultColumns[var1_1] = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    final DetectionResultColumn getDetectionResultColumn(int barcodeColumn) {
        void var1_1;
        return this.detectionResultColumns[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var3_4;
        void var2_2;
        DetectionResultColumn rowIndicatorColumn = this.detectionResultColumns[0];
        if (rowIndicatorColumn == null) {
            rowIndicatorColumn = this.detectionResultColumns[this.barcodeColumnCount + 1];
        }
        Formatter formatter = new Formatter();
        for (int codewordsRow = 0; codewordsRow < rowIndicatorColumn.getCodewords().length; ++codewordsRow) {
            formatter.format("CW %3d:", codewordsRow);
            for (int barcodeColumn = 0; barcodeColumn < this.barcodeColumnCount + 2; ++barcodeColumn) {
                if (this.detectionResultColumns[barcodeColumn] == null) {
                    formatter.format("    |   ", new Object[0]);
                    continue;
                }
                Codeword codeword = this.detectionResultColumns[barcodeColumn].getCodewords()[codewordsRow];
                if (codeword == null) {
                    formatter.format("    |   ", new Object[0]);
                    continue;
                }
                formatter.format(" %3d|%3d", codeword.getRowNumber(), codeword.getValue());
            }
            formatter.format("%n", new Object[0]);
        }
        String result = formatter.toString();
        var2_2.close();
        return var3_4;
    }
}

