/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;

final class BoundingBox {
    private BitMatrix image;
    private ResultPoint topLeft;
    private ResultPoint bottomLeft;
    private ResultPoint topRight;
    private ResultPoint bottomRight;
    private int minX;
    private int maxX;
    private int minY;
    private int maxY;

    /*
     * WARNING - void declaration
     */
    BoundingBox(BitMatrix image, ResultPoint topLeft, ResultPoint bottomLeft, ResultPoint topRight, ResultPoint bottomRight) throws NotFoundException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (topLeft == null && topRight == null || bottomLeft == null && bottomRight == null || topLeft != null && bottomLeft == null || topRight != null && bottomRight == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.init((BitMatrix)var1_1, (ResultPoint)var2_2, (ResultPoint)var3_3, topRight, bottomRight);
    }

    /*
     * WARNING - void declaration
     */
    BoundingBox(BoundingBox boundingBox) {
        void var1_1;
        this.init(boundingBox.image, boundingBox.topLeft, boundingBox.bottomLeft, boundingBox.topRight, var1_1.bottomRight);
    }

    /*
     * WARNING - void declaration
     */
    private void init(BitMatrix image, ResultPoint topLeft, ResultPoint bottomLeft, ResultPoint topRight, ResultPoint bottomRight) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.image = var1_1;
        this.topLeft = var2_2;
        this.bottomLeft = var3_3;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.calculateMinMaxValues();
    }

    /*
     * WARNING - void declaration
     */
    static BoundingBox merge(BoundingBox leftBox, BoundingBox rightBox) throws NotFoundException {
        void var1_1;
        BoundingBox boundingBox;
        if (leftBox == null) {
            return rightBox;
        }
        if (rightBox == null) {
            return leftBox;
        }
        return new BoundingBox(leftBox.image, leftBox.topLeft, boundingBox.bottomLeft, rightBox.topRight, var1_1.bottomRight);
    }

    /*
     * WARNING - void declaration
     */
    final BoundingBox addMissingRows(int missingStartRows, int missingEndRows, boolean isLeft) throws NotFoundException {
        ResultPoint newTopLeft = this.topLeft;
        ResultPoint newBottomLeft = this.bottomLeft;
        ResultPoint newTopRight = this.topRight;
        ResultPoint newBottomRight = this.bottomRight;
        if (missingStartRows > 0) {
            ResultPoint top = isLeft ? this.topLeft : this.topRight;
            int newMinY = (int)top.getY() - missingStartRows;
            if (newMinY < 0) {
                newMinY = 0;
            }
            ResultPoint newTop = new ResultPoint(top.getX(), newMinY);
            if (isLeft) {
                newTopLeft = newTop;
            } else {
                newTopRight = newTop;
            }
        }
        if (missingEndRows > 0) {
            void var3_5;
            void var2_4;
            ResultPoint bottom = isLeft ? this.bottomLeft : this.bottomRight;
            int newMaxY = (int)bottom.getY() + var2_4;
            if (newMaxY >= this.image.getHeight()) {
                newMaxY = this.image.getHeight() - 1;
            }
            ResultPoint newBottom = new ResultPoint(bottom.getX(), newMaxY);
            if (var3_5 != false) {
                newBottomLeft = newBottom;
            } else {
                void var1_3;
                newBottomRight = var1_3;
            }
        }
        this.calculateMinMaxValues();
        return new BoundingBox(this.image, newTopLeft, newBottomLeft, newTopRight, newBottomRight);
    }

    private void calculateMinMaxValues() {
        if (this.topLeft == null) {
            this.topLeft = new ResultPoint(0.0f, this.topRight.getY());
            this.bottomLeft = new ResultPoint(0.0f, this.bottomRight.getY());
        } else if (this.topRight == null) {
            this.topRight = new ResultPoint(this.image.getWidth() - 1, this.topLeft.getY());
            this.bottomRight = new ResultPoint(this.image.getWidth() - 1, this.bottomLeft.getY());
        }
        this.minX = (int)Math.min(this.topLeft.getX(), this.bottomLeft.getX());
        this.maxX = (int)Math.max(this.topRight.getX(), this.bottomRight.getX());
        this.minY = (int)Math.min(this.topLeft.getY(), this.topRight.getY());
        this.maxY = (int)Math.max(this.bottomLeft.getY(), this.bottomRight.getY());
    }

    final int getMinX() {
        return this.minX;
    }

    final int getMaxX() {
        return this.maxX;
    }

    final int getMinY() {
        return this.minY;
    }

    final int getMaxY() {
        return this.maxY;
    }

    final ResultPoint getTopLeft() {
        return this.topLeft;
    }

    final ResultPoint getTopRight() {
        return this.topRight;
    }

    final ResultPoint getBottomLeft() {
        return this.bottomLeft;
    }

    final ResultPoint getBottomRight() {
        return this.bottomRight;
    }
}

