/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.pdf417.encoder.Compaction;
import com.google.zxing.pdf417.encoder.Dimensions;
import com.google.zxing.pdf417.encoder.PDF417;
import java.nio.charset.Charset;
import java.util.Map;

public final class PDF417Writer
implements Writer {
    static final int WHITE_SPACE = 30;
    static final int DEFAULT_ERROR_CORRECTION_LEVEL = 2;

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        void var3_3;
        void var1_1;
        void var2_2;
        if (format != BarcodeFormat.PDF_417) {
            throw new IllegalArgumentException("Can only encode PDF_417, but got ".concat(String.valueOf((Object)format)));
        }
        PDF417 encoder = new PDF417();
        int margin = 30;
        int errorCorrectionLevel = 2;
        if (hints != null) {
            if (hints.containsKey((Object)EncodeHintType.PDF417_COMPACT)) {
                encoder.setCompact(Boolean.valueOf(hints.get((Object)EncodeHintType.PDF417_COMPACT).toString()));
            }
            if (hints.containsKey((Object)EncodeHintType.PDF417_COMPACTION)) {
                encoder.setCompaction(Compaction.valueOf(hints.get((Object)EncodeHintType.PDF417_COMPACTION).toString()));
            }
            if (hints.containsKey((Object)EncodeHintType.PDF417_DIMENSIONS)) {
                Dimensions dimensions = (Dimensions)hints.get((Object)EncodeHintType.PDF417_DIMENSIONS);
                encoder.setDimensions(dimensions.getMaxCols(), dimensions.getMinCols(), dimensions.getMaxRows(), dimensions.getMinRows());
            }
            if (hints.containsKey((Object)EncodeHintType.MARGIN)) {
                margin = Integer.parseInt(hints.get((Object)EncodeHintType.MARGIN).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.ERROR_CORRECTION)) {
                errorCorrectionLevel = Integer.parseInt(hints.get((Object)EncodeHintType.ERROR_CORRECTION).toString());
            }
            if (hints.containsKey((Object)EncodeHintType.CHARACTER_SET)) {
                Charset encoding = Charset.forName(hints.get((Object)EncodeHintType.CHARACTER_SET).toString());
                encoder.setEncoding(encoding);
            }
        }
        return PDF417Writer.bitMatrixFromEncoder((PDF417)var2_2, (String)var1_1, errorCorrectionLevel, (int)var3_3, height, margin);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, null);
    }

    /*
     * WARNING - void declaration
     */
    private static BitMatrix bitMatrixFromEncoder(PDF417 encoder, String contents, int errorCorrectionLevel, int width, int height, int margin) throws WriterException {
        void var1_1;
        int scale;
        int scaleY;
        int scaleX;
        encoder.generateBarcodeLogic(contents, errorCorrectionLevel);
        byte[][] originalScale = encoder.getBarcodeMatrix().getScaledMatrix(1, 4);
        boolean rotated = false;
        if (height > width ^ originalScale[0].length < originalScale.length) {
            originalScale = PDF417Writer.rotateArray(originalScale);
            rotated = true;
        }
        if ((scaleX = width / originalScale[0].length) >= (scaleY = height / originalScale.length)) {
            scale = scaleY;
        }
        if (scale > 1) {
            Object object;
            void var2_2;
            void var3_3;
            void v0 = var3_3;
            Object scaledMatrix = encoder.getBarcodeMatrix().getScaledMatrix((int)v0, (int)(v0 << 2));
            if (var2_2 != false) {
                scaledMatrix = PDF417Writer.rotateArray((byte[][])scaledMatrix);
            }
            return PDF417Writer.bitMatrixFrombitArray((byte[][])object, margin);
        }
        return PDF417Writer.bitMatrixFrombitArray((byte[][])var1_1, margin);
    }

    /*
     * WARNING - void declaration
     */
    private static BitMatrix bitMatrixFrombitArray(byte[][] input, int margin) {
        void var2_2;
        BitMatrix output = new BitMatrix(input[0].length + 2 * margin, input.length + 2 * margin);
        output.clear();
        int y = 0;
        int yOutput = output.getHeight() - margin - 1;
        while (y < input.length) {
            for (int x = 0; x < input[0].length; ++x) {
                if (input[y][x] != 1) continue;
                output.set(x + margin, yOutput);
            }
            ++y;
            --yOutput;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[][] rotateArray(byte[][] bitarray) {
        void var1_1;
        byte[][] temp = new byte[bitarray[0].length][bitarray.length];
        for (int ii = 0; ii < bitarray.length; ++ii) {
            int inverseii = bitarray.length - ii - 1;
            for (int jj = 0; jj < bitarray[0].length; ++jj) {
                temp[jj][inverseii] = bitarray[ii][jj];
            }
        }
        return var1_1;
    }
}

