/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import com.google.zxing.pdf417.decoder.PDF417ScanningDecoder;
import com.google.zxing.pdf417.detector.Detector;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public final class PDF417Reader
implements Reader,
MultipleBarcodeReader {
    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image) throws NotFoundException, FormatException, ChecksumException {
        void var1_1;
        return this.decode((BinaryBitmap)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decode(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException, FormatException, ChecksumException {
        void var1_1;
        void var2_2;
        Result[] result = PDF417Reader.decode(image, var2_2, false);
        if (result == null || result.length == 0 || result[0] == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        return var1_1[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result[] decodeMultiple(BinaryBitmap image) throws NotFoundException {
        void var1_1;
        return this.decodeMultiple((BinaryBitmap)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result[] decodeMultiple(BinaryBitmap image, Map<DecodeHintType, ?> hints) throws NotFoundException {
        try {
            void var2_2;
            return PDF417Reader.decode(image, var2_2, true);
        }
        catch (ChecksumException | FormatException readerException) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Result[] decode(BinaryBitmap image, Map<DecodeHintType, ?> hints, boolean multiple) throws NotFoundException, FormatException, ChecksumException {
        void var3_4;
        Iterator<ResultPoint[]> iterator;
        ArrayList<void> results = new ArrayList<void>();
        PDF417DetectorResult detectorResult = Detector.detect(image, iterator, multiple);
        for (ResultPoint[] points : detectorResult.getPoints()) {
            void var2_3;
            DecoderResult decoderResult = PDF417ScanningDecoder.decode(detectorResult.getBits(), points[4], points[5], points[6], points[7], PDF417Reader.getMinCodewordWidth(points), PDF417Reader.getMaxCodewordWidth(points));
            Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.PDF_417);
            result.putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, decoderResult.getECLevel());
            PDF417ResultMetadata pdf417ResultMetadata = (PDF417ResultMetadata)decoderResult.getOther();
            if (pdf417ResultMetadata != null) {
                result.putMetadata(ResultMetadataType.PDF417_EXTRA_METADATA, pdf417ResultMetadata);
            }
            results.add(var2_3);
        }
        void v0 = var3_4;
        return v0.toArray(new Result[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    private static int getMaxWidth(ResultPoint p1, ResultPoint p2) {
        void var1_1;
        ResultPoint resultPoint;
        if (p1 == null || p2 == null) {
            return 0;
        }
        return (int)Math.abs(resultPoint.getX() - var1_1.getX());
    }

    /*
     * WARNING - void declaration
     */
    private static int getMinWidth(ResultPoint p1, ResultPoint p2) {
        void var1_1;
        ResultPoint resultPoint;
        if (p1 == null || p2 == null) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.abs(resultPoint.getX() - var1_1.getX());
    }

    private static int getMaxCodewordWidth(ResultPoint[] p) {
        ResultPoint[] resultPointArray;
        return Math.max(Math.max(PDF417Reader.getMaxWidth(p[0], p[4]), PDF417Reader.getMaxWidth(p[6], p[2]) * 17 / 18), Math.max(PDF417Reader.getMaxWidth(p[1], p[5]), PDF417Reader.getMaxWidth(p[7], resultPointArray[3]) * 17 / 18));
    }

    private static int getMinCodewordWidth(ResultPoint[] p) {
        ResultPoint[] resultPointArray;
        return Math.min(Math.min(PDF417Reader.getMinWidth(p[0], p[4]), PDF417Reader.getMinWidth(p[6], p[2]) * 17 / 18), Math.min(PDF417Reader.getMinWidth(p[1], p[5]), PDF417Reader.getMinWidth(p[7], resultPointArray[3]) * 17 / 18));
    }

    @Override
    public final void reset() {
    }
}

