/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.decoders.BlockParsedResult;
import com.google.zxing.oned.rss.expanded.decoders.CurrentParsingState;
import com.google.zxing.oned.rss.expanded.decoders.DecodedChar;
import com.google.zxing.oned.rss.expanded.decoders.DecodedInformation;
import com.google.zxing.oned.rss.expanded.decoders.DecodedNumeric;
import com.google.zxing.oned.rss.expanded.decoders.FieldParser;

final class GeneralAppIdDecoder {
    private final BitArray information;
    private final CurrentParsingState current = new CurrentParsingState();
    private final StringBuilder buffer = new StringBuilder();

    /*
     * WARNING - void declaration
     */
    GeneralAppIdDecoder(BitArray information) {
        void var1_1;
        this.information = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final String decodeAllCodes(StringBuilder buff, int initialPosition) throws NotFoundException, FormatException {
        void var1_1;
        int currentPosition = initialPosition;
        String remaining = null;
        while (true) {
            String string;
            DecodedInformation info;
            String parsedFields;
            if ((parsedFields = FieldParser.parseFieldsInGeneralPurpose((info = this.decodeGeneralPurposeField(currentPosition, remaining)).getNewString())) != null) {
                buff.append(string);
            }
            string = info.isRemaining() ? String.valueOf(info.getRemainingValue()) : null;
            if (currentPosition == info.getNewPosition()) break;
            currentPosition = info.getNewPosition();
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isStillNumeric(int pos) {
        void var1_1;
        if (pos + 7 > this.information.getSize()) {
            return pos + 4 <= this.information.getSize();
        }
        for (int i = pos; i < pos + 3; ++i) {
            if (!this.information.get(i)) continue;
            return true;
        }
        return this.information.get((int)(var1_1 + 3));
    }

    /*
     * WARNING - void declaration
     */
    private DecodedNumeric decodeNumeric(int pos) throws FormatException {
        void var2_3;
        void var3_4;
        void var1_1;
        if (pos + 7 > this.information.getSize()) {
            int numeric = this.extractNumericValueFromBitArray(pos, 4);
            if (numeric == 0) {
                return new DecodedNumeric(this.information.getSize(), 10, 10);
            }
            return new DecodedNumeric(this.information.getSize(), numeric - 1, 10);
        }
        int numeric = this.extractNumericValueFromBitArray(pos, 7);
        int digit1 = (numeric - 8) / 11;
        int digit2 = (numeric - 8) % 11;
        return new DecodedNumeric((int)(var1_1 + 7), (int)var3_4, (int)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    final int extractNumericValueFromBitArray(int pos, int bits) {
        void var2_2;
        void var1_1;
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int extractNumericValueFromBitArray(BitArray information, int pos, int bits) {
        void var3_3;
        int value = 0;
        for (int i = 0; i < bits; ++i) {
            if (!information.get(pos + i)) continue;
            value |= 1 << bits - i - 1;
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    final DecodedInformation decodeGeneralPurposeField(int pos, String remaining) throws FormatException {
        this.buffer.setLength(0);
        if (remaining != null) {
            void var2_3;
            this.buffer.append((String)var2_3);
        }
        this.current.setPosition(pos);
        DecodedInformation lastDecoded = this.parseBlocks();
        if (lastDecoded != null && lastDecoded.isRemaining()) {
            void var1_2;
            return new DecodedInformation(this.current.getPosition(), this.buffer.toString(), var1_2.getRemainingValue());
        }
        return new DecodedInformation(this.current.getPosition(), this.buffer.toString());
    }

    /*
     * WARNING - void declaration
     */
    private DecodedInformation parseBlocks() throws FormatException {
        void var2_2;
        void var1_1;
        boolean isFinished;
        void var3_3;
        do {
            BlockParsedResult result;
            int initialPosition = this.current.getPosition();
            if (this.current.isAlpha()) {
                result = this.parseAlphaBlock();
                isFinished = result.isFinished();
                continue;
            }
            if (this.current.isIsoIec646()) {
                result = this.parseIsoIec646Block();
                isFinished = result.isFinished();
                continue;
            }
            result = this.parseNumericBlock();
            isFinished = result.isFinished();
        } while ((var3_3 != this.current.getPosition() || isFinished) && var1_1 == false);
        return var2_2.getDecodedInformation();
    }

    /*
     * WARNING - void declaration
     */
    private BlockParsedResult parseNumericBlock() throws FormatException {
        while (true) {
            void var1_1;
            DecodedInformation information;
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillNumeric(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            DecodedNumeric numeric = generalAppIdDecoder2.decodeNumeric(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(numeric.getNewPosition());
            if (numeric.isFirstDigitFNC1()) {
                information = numeric.isSecondDigitFNC1() ? new DecodedInformation(this.current.getPosition(), this.buffer.toString()) : new DecodedInformation(this.current.getPosition(), this.buffer.toString(), ((DecodedNumeric)((Object)information)).getSecondDigit());
                return new BlockParsedResult(information, true);
            }
            this.buffer.append(((DecodedNumeric)((Object)information)).getFirstDigit());
            if (((DecodedNumeric)((Object)information)).isSecondDigitFNC1()) {
                information = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)var1_1, true);
            }
            this.buffer.append(var1_1.getSecondDigit());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isNumericToAlphaNumericLatch(generalAppIdDecoder.current.getPosition())) {
            this.current.setAlpha();
            this.current.incrementPosition(4);
        }
        return new BlockParsedResult(false);
    }

    /*
     * WARNING - void declaration
     */
    private BlockParsedResult parseIsoIec646Block() throws FormatException {
        while (true) {
            void var1_1;
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillIsoIec646(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            DecodedChar iso = generalAppIdDecoder2.decodeIsoIec646(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(iso.getNewPosition());
            if (iso.isFNC1()) {
                DecodedInformation information = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)var1_1, true);
            }
            this.buffer.append(var1_1.getValue());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isAlphaOr646ToNumericLatch(generalAppIdDecoder.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else {
            GeneralAppIdDecoder generalAppIdDecoder3 = this;
            if (generalAppIdDecoder3.isAlphaTo646ToAlphaLatch(generalAppIdDecoder3.current.getPosition())) {
                if (this.current.getPosition() + 5 < this.information.getSize()) {
                    this.current.incrementPosition(5);
                } else {
                    this.current.setPosition(this.information.getSize());
                }
                this.current.setAlpha();
            }
        }
        return new BlockParsedResult(false);
    }

    /*
     * WARNING - void declaration
     */
    private BlockParsedResult parseAlphaBlock() {
        while (true) {
            void var1_1;
            GeneralAppIdDecoder generalAppIdDecoder = this;
            if (!generalAppIdDecoder.isStillAlpha(generalAppIdDecoder.current.getPosition())) break;
            GeneralAppIdDecoder generalAppIdDecoder2 = this;
            DecodedChar alpha = generalAppIdDecoder2.decodeAlphanumeric(generalAppIdDecoder2.current.getPosition());
            this.current.setPosition(alpha.getNewPosition());
            if (alpha.isFNC1()) {
                DecodedInformation information = new DecodedInformation(this.current.getPosition(), this.buffer.toString());
                return new BlockParsedResult((DecodedInformation)var1_1, true);
            }
            this.buffer.append(var1_1.getValue());
        }
        GeneralAppIdDecoder generalAppIdDecoder = this;
        if (generalAppIdDecoder.isAlphaOr646ToNumericLatch(generalAppIdDecoder.current.getPosition())) {
            this.current.incrementPosition(3);
            this.current.setNumeric();
        } else {
            GeneralAppIdDecoder generalAppIdDecoder3 = this;
            if (generalAppIdDecoder3.isAlphaTo646ToAlphaLatch(generalAppIdDecoder3.current.getPosition())) {
                if (this.current.getPosition() + 5 < this.information.getSize()) {
                    this.current.incrementPosition(5);
                } else {
                    this.current.setPosition(this.information.getSize());
                }
                this.current.setIsoIec646();
            }
        }
        return new BlockParsedResult(false);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isStillIsoIec646(int pos) {
        void var1_1;
        void var2_2;
        if (pos + 5 > this.information.getSize()) {
            return false;
        }
        int fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue >= 5 && fiveBitValue < 16) {
            return true;
        }
        if (pos + 7 > this.information.getSize()) {
            return false;
        }
        int sevenBitValue = this.extractNumericValueFromBitArray(pos, 7);
        if (sevenBitValue >= 64 && var2_2 < 116) {
            return true;
        }
        if (pos + 8 > this.information.getSize()) {
            return false;
        }
        int eightBitValue = this.extractNumericValueFromBitArray(pos, 8);
        return eightBitValue >= 232 && var1_1 < 253;
    }

    /*
     * WARNING - void declaration
     */
    private DecodedChar decodeIsoIec646(int pos) throws FormatException {
        void var2_2;
        void var1_1;
        int fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue == 15) {
            return new DecodedChar(pos + 5, '$');
        }
        if (fiveBitValue >= 5 && fiveBitValue < 15) {
            return new DecodedChar(pos + 5, (char)(fiveBitValue + 48 - 5));
        }
        int sevenBitValue = this.extractNumericValueFromBitArray(pos, 7);
        if (sevenBitValue >= 64 && sevenBitValue < 90) {
            return new DecodedChar(pos + 7, (char)(sevenBitValue + 1));
        }
        if (sevenBitValue >= 90 && sevenBitValue < 116) {
            return new DecodedChar(pos + 7, (char)(sevenBitValue + 7));
        }
        switch (this.extractNumericValueFromBitArray(pos, 8)) {
            case 232: {
                int c = 33;
                break;
            }
            case 233: {
                int c = 34;
                break;
            }
            case 234: {
                int c = 37;
                break;
            }
            case 235: {
                int c = 38;
                break;
            }
            case 236: {
                int c = 39;
                break;
            }
            case 237: {
                int c = 40;
                break;
            }
            case 238: {
                int c = 41;
                break;
            }
            case 239: {
                int c = 42;
                break;
            }
            case 240: {
                int c = 43;
                break;
            }
            case 241: {
                int c = 44;
                break;
            }
            case 242: {
                int c = 45;
                break;
            }
            case 243: {
                int c = 46;
                break;
            }
            case 244: {
                int c = 47;
                break;
            }
            case 245: {
                int c = 58;
                break;
            }
            case 246: {
                int c = 59;
                break;
            }
            case 247: {
                int c = 60;
                break;
            }
            case 248: {
                int c = 61;
                break;
            }
            case 249: {
                int c = 62;
                break;
            }
            case 250: {
                int c = 63;
                break;
            }
            case 251: {
                int c = 95;
                break;
            }
            case 252: {
                int c = 32;
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        return new DecodedChar((int)(var1_1 + 8), (char)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isStillAlpha(int pos) {
        void var1_1;
        void var2_2;
        if (pos + 5 > this.information.getSize()) {
            return false;
        }
        int fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue >= 5 && var2_2 < 16) {
            return true;
        }
        if (pos + 6 > this.information.getSize()) {
            return false;
        }
        int sixBitValue = this.extractNumericValueFromBitArray(pos, 6);
        return sixBitValue >= 16 && var1_1 < 63;
    }

    /*
     * WARNING - void declaration
     */
    private DecodedChar decodeAlphanumeric(int pos) {
        void var2_2;
        void var1_1;
        int fiveBitValue = this.extractNumericValueFromBitArray(pos, 5);
        if (fiveBitValue == 15) {
            return new DecodedChar(pos + 5, '$');
        }
        if (fiveBitValue >= 5 && fiveBitValue < 15) {
            return new DecodedChar(pos + 5, (char)(fiveBitValue + 48 - 5));
        }
        int sixBitValue = this.extractNumericValueFromBitArray(pos, 6);
        if (sixBitValue >= 32 && sixBitValue < 58) {
            return new DecodedChar(pos + 6, (char)(sixBitValue + 33));
        }
        switch (sixBitValue) {
            case 58: {
                int c = 42;
                break;
            }
            case 59: {
                int c = 44;
                break;
            }
            case 60: {
                int c = 45;
                break;
            }
            case 61: {
                int c = 46;
                break;
            }
            case 62: {
                int c = 47;
                break;
            }
            default: {
                int c;
                throw new IllegalStateException("Decoding invalid alphanumeric value: ".concat(String.valueOf(c)));
            }
        }
        return new DecodedChar((int)(var1_1 + 6), (char)var2_2);
    }

    private boolean isAlphaTo646ToAlphaLatch(int pos) {
        if (pos + 1 > this.information.getSize()) {
            return false;
        }
        for (int i = 0; i < 5 && i + pos < this.information.getSize(); ++i) {
            if (!(i == 2 ? !this.information.get(pos + 2) : this.information.get(pos + i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAlphaOr646ToNumericLatch(int pos) {
        if (pos + 3 > this.information.getSize()) {
            return false;
        }
        for (int i = pos; i < pos + 3; ++i) {
            if (!this.information.get(i)) continue;
            return false;
        }
        return true;
    }

    private boolean isNumericToAlphaNumericLatch(int pos) {
        if (pos + 1 > this.information.getSize()) {
            return false;
        }
        for (int i = 0; i < 4 && i + pos < this.information.getSize(); ++i) {
            if (!this.information.get(pos + i)) continue;
            return false;
        }
        return true;
    }
}

