/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.decoders.AI01weightDecoder;

final class AI013x0x1xDecoder
extends AI01weightDecoder {
    private static final int HEADER_SIZE = 8;
    private static final int WEIGHT_SIZE = 20;
    private static final int DATE_SIZE = 16;
    private final String dateCode;
    private final String firstAIdigits;

    /*
     * WARNING - void declaration
     */
    AI013x0x1xDecoder(BitArray information, String firstAIdigits, String dateCode) {
        super((BitArray)var1_1);
        void var2_2;
        void var3_3;
        void var1_1;
        this.dateCode = var3_3;
        this.firstAIdigits = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String parseInformation() throws NotFoundException {
        void var1_1;
        if (this.getInformation().getSize() != 84) {
            throw NotFoundException.getNotFoundInstance();
        }
        StringBuilder buf = new StringBuilder();
        this.encodeCompressedGtin(buf, 8);
        this.encodeCompressedWeight(buf, 48, 20);
        this.encodeCompressedDate(buf, 68);
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void encodeCompressedDate(StringBuilder buf, int currentPos) {
        void var3_3;
        void var1_1;
        void var2_2;
        int numericDate = this.getGeneralDecoder().extractNumericValueFromBitArray(currentPos, 16);
        if (numericDate == 38400) {
            return;
        }
        buf.append('(');
        buf.append(this.dateCode);
        buf.append(')');
        int day = numericDate % 32;
        int month = (numericDate /= 32) % 12 + 1;
        if ((numericDate /= 12) / 10 == 0) {
            buf.append('0');
        }
        buf.append((int)var2_2);
        if (month / 10 == 0) {
            buf.append('0');
        }
        buf.append(month);
        if (day / 10 == 0) {
            buf.append('0');
        }
        var1_1.append((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void addWeightCode(StringBuilder buf, int weight) {
        void var1_1;
        void var2_2;
        buf.append('(');
        buf.append(this.firstAIdigits);
        buf.append((int)(var2_2 / 100000));
        var1_1.append(')');
    }

    @Override
    protected final int checkWeight(int weight) {
        return weight % 100000;
    }
}

