/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.oned.rss.AbstractRSSReader;
import com.google.zxing.oned.rss.DataCharacter;
import com.google.zxing.oned.rss.FinderPattern;
import com.google.zxing.oned.rss.Pair;
import com.google.zxing.oned.rss.RSSUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class RSS14Reader
extends AbstractRSSReader {
    private static final int[] OUTSIDE_EVEN_TOTAL_SUBSET = new int[]{1, 10, 34, 70, 126};
    private static final int[] INSIDE_ODD_TOTAL_SUBSET = new int[]{4, 20, 48, 81};
    private static final int[] OUTSIDE_GSUM = new int[]{0, 161, 961, 2015, 2715};
    private static final int[] INSIDE_GSUM = new int[]{0, 336, 1036, 1516};
    private static final int[] OUTSIDE_ODD_WIDEST = new int[]{8, 6, 4, 3, 1};
    private static final int[] INSIDE_ODD_WIDEST = new int[]{2, 4, 6, 8};
    private static final int[][] FINDER_PATTERNS = new int[][]{{3, 8, 2, 1}, {3, 5, 5, 1}, {3, 3, 7, 1}, {3, 1, 9, 1}, {2, 7, 4, 1}, {2, 5, 6, 1}, {2, 3, 8, 1}, {1, 5, 7, 1}, {1, 3, 9, 1}};
    private final List<Pair> possibleLeftPairs = new ArrayList<Pair>();
    private final List<Pair> possibleRightPairs = new ArrayList<Pair>();

    @Override
    public final Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException {
        Iterator<Pair> iterator;
        Iterator<Pair> iterator2;
        Pair leftPair = this.decodePair(row, false, rowNumber, hints);
        RSS14Reader.addOrTally(this.possibleLeftPairs, leftPair);
        row.reverse();
        Pair rightPair = this.decodePair(row, true, rowNumber, (Map<DecodeHintType, ?>)((Object)iterator2));
        RSS14Reader.addOrTally(this.possibleRightPairs, (Pair)((Object)iterator));
        row.reverse();
        for (Pair left : this.possibleLeftPairs) {
            if (left.getCount() <= 1) continue;
            for (Pair right : this.possibleRightPairs) {
                if (right.getCount() <= 1 || !RSS14Reader.checkChecksum(left, right)) continue;
                return RSS14Reader.constructResult(left, right);
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    /*
     * WARNING - void declaration
     */
    private static void addOrTally(Collection<Pair> possiblePairs, Pair pair) {
        void var2_2;
        if (pair == null) {
            return;
        }
        boolean found = false;
        for (Pair other : possiblePairs) {
            if (other.getValue() != pair.getValue()) continue;
            other.incrementCount();
            found = true;
            break;
        }
        if (var2_2 == false) {
            void var1_1;
            Collection<Pair> collection;
            collection.add((Pair)var1_1);
        }
    }

    @Override
    public final void reset() {
        this.possibleLeftPairs.clear();
        this.possibleRightPairs.clear();
    }

    /*
     * WARNING - void declaration
     */
    private static Result constructResult(Pair leftPair, Pair rightPair) {
        void var2_4;
        void var3_5;
        void var1_1;
        Pair pair;
        String text = String.valueOf(4537077L * (long)leftPair.getValue() + (long)rightPair.getValue());
        StringBuilder buffer = new StringBuilder(14);
        for (int i = 13 - text.length(); i > 0; --i) {
            buffer.append('0');
        }
        buffer.append(text);
        int checkDigit = 0;
        for (int i = 0; i < 13; ++i) {
            int digit = buffer.charAt(i) - 48;
            checkDigit += (i & 1) == 0 ? 3 * digit : digit;
        }
        if ((checkDigit = 10 - checkDigit % 10) == 10) {
            checkDigit = 0;
        }
        buffer.append(checkDigit);
        ResultPoint[] leftPoints = pair.getFinderPattern().getResultPoints();
        ResultPoint[] rightPoints = var1_1.getFinderPattern().getResultPoints();
        return new Result(String.valueOf(var3_5.toString()), null, new ResultPoint[]{leftPoints[0], var2_4[1], rightPoints[0], rightPoints[1]}, BarcodeFormat.RSS_14);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkChecksum(Pair leftPair, Pair rightPair) {
        void var0_1;
        void var2_3;
        void var1_2;
        int checkValue = (leftPair.getChecksumPortion() + 16 * rightPair.getChecksumPortion()) % 79;
        int targetCheckValue = 9 * leftPair.getFinderPattern().getValue() + var1_2.getFinderPattern().getValue();
        if (targetCheckValue > 72) {
            --targetCheckValue;
        }
        if (targetCheckValue > 8) {
            --targetCheckValue;
        }
        return var2_3 == var0_1;
    }

    /*
     * WARNING - void declaration
     */
    private Pair decodePair(BitArray row, boolean right, int rowNumber, Map<DecodeHintType, ?> hints) {
        try {
            void var1_1;
            int[] startEnd = this.findFinderPattern(row, 0, right);
            FinderPattern pattern = this.parseFoundFinderPattern(row, rowNumber, right, startEnd);
            ResultPointCallback resultPointCallback = hints == null ? null : (ResultPointCallback)hints.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
            if (resultPointCallback != null) {
                void var3_3;
                void var2_2;
                float center = (float)(startEnd[0] + startEnd[1]) / 2.0f;
                if (var2_2 != false) {
                    center = (float)(row.getSize() - 1) - center;
                }
                resultPointCallback.foundPossibleResultPoint(new ResultPoint(center, (float)var3_3));
            }
            DataCharacter outside = this.decodeDataCharacter(row, pattern, true);
            DataCharacter inside = this.decodeDataCharacter(row, pattern, false);
            return new Pair(1597 * outside.getValue() + inside.getValue(), outside.getChecksumPortion() + 4 * var1_1.getChecksumPortion(), pattern);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private DataCharacter decodeDataCharacter(BitArray row, FinderPattern pattern, boolean outsideChar) throws NotFoundException {
        void var1_3;
        void var2_8;
        void var3_9;
        void tEven2;
        int vOdd;
        int oddWidest;
        int[] nArray = this.getDataCharacterCounters();
        int[] counters = nArray;
        nArray[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        counters[4] = 0;
        counters[5] = 0;
        counters[6] = 0;
        counters[7] = 0;
        if (outsideChar) {
            RSS14Reader.recordPatternInReverse(row, pattern.getStartEnd()[0], counters);
        } else {
            RSS14Reader.recordPattern(row, pattern.getStartEnd()[1] + 1, counters);
            int i = 0;
            for (int j = counters.length - 1; i < j; ++i, --j) {
                int temp = counters[i];
                counters[i] = counters[j];
                counters[j] = temp;
            }
        }
        int numModules = outsideChar ? 16 : 15;
        float elementWidth = (float)MathUtils.sum(counters) / (float)numModules;
        int[] oddCounts = this.getOddCounts();
        int[] evenCounts = this.getEvenCounts();
        float[] oddRoundingErrors = this.getOddRoundingErrors();
        float[] evenRoundingErrors = this.getEvenRoundingErrors();
        for (int i = 0; i < counters.length; ++i) {
            float value = (float)counters[i] / elementWidth;
            int count = (int)(value + 0.5f);
            if (count <= 0) {
                count = 1;
            } else if (count > 8) {
                count = 8;
            }
            int offset = i / 2;
            if ((i & 1) == 0) {
                oddCounts[offset] = count;
                oddRoundingErrors[offset] = value - (float)count;
                continue;
            }
            evenCounts[offset] = count;
            evenRoundingErrors[offset] = value - (float)count;
        }
        this.adjustOddEvenCounts(outsideChar, numModules);
        int oddSum = 0;
        int oddChecksumPortion = 0;
        for (int i = oddCounts.length - 1; i >= 0; --i) {
            oddChecksumPortion = oddChecksumPortion * 9 + oddCounts[i];
            oddSum += oddCounts[i];
        }
        int evenChecksumPortion = 0;
        int evenSum = 0;
        for (int i = evenCounts.length - 1; i >= 0; --i) {
            evenChecksumPortion = evenChecksumPortion * 9 + evenCounts[i];
            evenSum += evenCounts[i];
        }
        int checksumPortion = oddChecksumPortion + 3 * evenChecksumPortion;
        if (outsideChar) {
            if ((oddSum & 1) != 0 || oddSum > 12 || oddSum < 4) {
                throw NotFoundException.getNotFoundInstance();
            }
            int group = (12 - oddSum) / 2;
            oddWidest = OUTSIDE_ODD_WIDEST[group];
            int evenWidest = 9 - oddWidest;
            vOdd = RSSUtils.getRSSvalue(oddCounts, oddWidest, false);
            int vEven = RSSUtils.getRSSvalue(evenCounts, evenWidest, true);
            int tEven2 = OUTSIDE_EVEN_TOTAL_SUBSET[group];
            int gSum = OUTSIDE_GSUM[group];
            return new DataCharacter(vOdd * tEven2 + vEven + gSum, checksumPortion);
        }
        if (evenSum & true || evenSum > 10 || evenSum < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        int group = (10 - evenSum) / 2;
        oddWidest = INSIDE_ODD_WIDEST[group];
        int evenWidest = 9 - oddWidest;
        vOdd = RSSUtils.getRSSvalue((int[])tEven2, oddWidest, true);
        int vEven = RSSUtils.getRSSvalue(evenCounts, evenWidest, false);
        int tOdd = INSIDE_ODD_TOTAL_SUBSET[group];
        int gSum = INSIDE_GSUM[group];
        return new DataCharacter(vEven * tOdd + var3_9 + var2_8, (int)var1_3);
    }

    /*
     * WARNING - void declaration
     */
    private int[] findFinderPattern(BitArray row, int rowOffset, boolean rightFinderPattern) throws NotFoundException {
        void x;
        int[] nArray = this.getDecodeFinderCounters();
        int[] counters = nArray;
        nArray[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int width = row.getSize();
        boolean isWhite = false;
        while (rowOffset < width) {
            boolean bl = isWhite = !row.get(rowOffset);
            if (rightFinderPattern == isWhite) break;
            ++rowOffset;
        }
        int counterPosition = 0;
        int patternStart = rowOffset;
        while (x < width) {
            if (row.get((int)x) ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
            } else {
                if (counterPosition == 3) {
                    if (RSS14Reader.isFinderPattern(counters)) {
                        return new int[]{patternStart, x};
                    }
                    patternStart += counters[0] + counters[1];
                    counters[0] = counters[2];
                    counters[1] = counters[3];
                    counters[2] = 0;
                    counters[3] = 0;
                    --counterPosition;
                } else {
                    ++counterPosition;
                }
                counters[counterPosition] = 1;
                isWhite = !isWhite;
            }
            ++x;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    /*
     * WARNING - void declaration
     */
    private FinderPattern parseFoundFinderPattern(BitArray row, int rowNumber, boolean right, int[] startEnd) throws NotFoundException {
        void var2_2;
        void var3_3;
        int firstElementStart;
        boolean firstIsBlack = row.get(startEnd[0]);
        for (firstElementStart = startEnd[0] - 1; firstElementStart >= 0 && firstIsBlack ^ row.get(firstElementStart); --firstElementStart) {
        }
        int firstCounter = startEnd[0] - ++firstElementStart;
        int[] counters = this.getDecodeFinderCounters();
        System.arraycopy(counters, 0, counters, 1, counters.length - 1);
        counters[0] = firstCounter;
        int value = RSS14Reader.parseFinderValue(counters, FINDER_PATTERNS);
        int start = firstElementStart;
        int end = startEnd[1];
        if (var3_3 != false) {
            void var1_1;
            start = row.getSize() - 1 - start;
            end = var1_1.getSize() - 1 - end;
        }
        return new FinderPattern(value, new int[]{firstElementStart, startEnd[1]}, start, end, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void adjustOddEvenCounts(boolean outsideChar, int numModules) throws NotFoundException {
        void var2_2;
        boolean evenParityBad;
        int oddSum = MathUtils.sum(this.getOddCounts());
        int evenSum = MathUtils.sum(this.getEvenCounts());
        boolean incrementOdd = false;
        boolean decrementOdd = false;
        boolean incrementEven = false;
        boolean decrementEven = false;
        if (outsideChar) {
            if (oddSum > 12) {
                decrementOdd = true;
            } else if (oddSum < 4) {
                incrementOdd = true;
            }
            if (evenSum > 12) {
                decrementEven = true;
            } else if (evenSum < 4) {
                incrementEven = true;
            }
        } else {
            if (oddSum > 11) {
                decrementOdd = true;
            } else if (oddSum < 5) {
                incrementOdd = true;
            }
            if (evenSum > 10) {
                decrementEven = true;
            } else if (evenSum < 4) {
                incrementEven = true;
            }
        }
        int mismatch = oddSum + evenSum - numModules;
        boolean oddParityBad = (oddSum & 1) == (outsideChar ? 1 : 0);
        boolean bl = evenParityBad = (evenSum & 1) == 1;
        if (mismatch == 1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                decrementOdd = true;
            } else {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                decrementEven = true;
            }
        } else if (mismatch == -1) {
            if (oddParityBad) {
                if (evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                incrementOdd = true;
            } else {
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                incrementEven = true;
            }
        } else if (var2_2 == false) {
            void var1_1;
            if (var1_1 != false) {
                void var3_3;
                if (!evenParityBad) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (var3_3 < evenSum) {
                    incrementOdd = true;
                    decrementEven = true;
                } else {
                    decrementOdd = true;
                    incrementEven = true;
                }
            } else if (evenParityBad) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (incrementOdd) {
            if (decrementOdd) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (decrementOdd) {
            RSS14Reader.decrement(this.getOddCounts(), this.getOddRoundingErrors());
        }
        if (incrementEven) {
            if (decrementEven) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.getEvenCounts(), this.getOddRoundingErrors());
        }
        if (decrementEven) {
            RSS14Reader.decrement(this.getEvenCounts(), this.getEvenRoundingErrors());
        }
    }
}

