/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import com.google.zxing.oned.UPCEReader;
import java.util.Map;

public final class UPCEWriter
extends UPCEANWriter {
    private static final int CODE_WIDTH = 51;

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (format != BarcodeFormat.UPC_E) {
            throw new IllegalArgumentException("Can only encode UPC_E, but got ".concat(String.valueOf((Object)format)));
        }
        return super.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, hints);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean[] encode(String contents) {
        void var3_3;
        if (contents.length() != 8) {
            throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + contents.length());
        }
        int checkDigit = Integer.parseInt(contents.substring(7, 8));
        int parities = UPCEReader.CHECK_DIGIT_ENCODINGS[checkDigit];
        boolean[] result = new boolean[51];
        int pos = 0 + UPCEWriter.appendPattern(result, 0, UPCEANReader.START_END_PATTERN, true);
        for (int i = 1; i <= 6; ++i) {
            int n = i;
            int digit = Integer.parseInt(contents.substring(n, n + 1));
            if ((parities >> 6 - i & 1) == 1) {
                digit += 10;
            }
            pos += UPCEWriter.appendPattern(result, pos, UPCEANReader.L_AND_G_PATTERNS[digit], false);
        }
        UPCEWriter.appendPattern(result, pos, UPCEANReader.END_PATTERN, false);
        return var3_3;
    }
}

