/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class UPCEReader
extends UPCEANReader {
    static final int[] CHECK_DIGIT_ENCODINGS = new int[]{56, 52, 50, 49, 44, 38, 35, 42, 41, 37};
    private static final int[] MIDDLE_END_PATTERN = new int[]{1, 1, 1, 1, 1, 1};
    private static final int[][] NUMSYS_AND_CHECK_DIGIT_PATTERNS = new int[][]{{56, 52, 50, 49, 44, 38, 35, 42, 41, 37}, {7, 11, 13, 14, 19, 25, 28, 21, 22, 26}};
    private final int[] decodeMiddleCounters = new int[4];

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int decodeMiddle(BitArray row, int[] startRange, StringBuilder result) throws NotFoundException {
        void var2_3;
        void var3_4;
        int[] counters = this.decodeMiddleCounters;
        this.decodeMiddleCounters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        for (int x = 0; x < 6 && rowOffset < end; ++x) {
            int bestMatch = UPCEReader.decodeDigit(row, counters, rowOffset, L_AND_G_PATTERNS);
            result.append((char)(48 + bestMatch % 10));
            int[] nArray = counters;
            int n = counters.length;
            for (int i = 0; i < n; ++i) {
                int counter = nArray[i];
                rowOffset += counter;
            }
            if (bestMatch < 10) continue;
            lgPatternFound |= 1 << 5 - x;
        }
        UPCEReader.determineNumSysAndCheckDigit((StringBuilder)var3_4, lgPatternFound);
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final int[] decodeEnd(BitArray row, int endStart) throws NotFoundException {
        void var2_2;
        return UPCEReader.findGuardPattern(row, (int)var2_2, true, MIDDLE_END_PATTERN);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean checkChecksum(String s) throws FormatException {
        void var1_1;
        return super.checkChecksum(UPCEReader.convertUPCEtoUPCA((String)var1_1));
    }

    private static void determineNumSysAndCheckDigit(StringBuilder resultString, int lgPatternFound) throws NotFoundException {
        for (int numSys = 0; numSys <= 1; ++numSys) {
            for (int d = 0; d < 10; ++d) {
                if (lgPatternFound != NUMSYS_AND_CHECK_DIGIT_PATTERNS[numSys][d]) continue;
                resultString.insert(0, (char)(numSys + 48));
                resultString.append((char)(d + 48));
                return;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    final BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_E;
    }

    /*
     * WARNING - void declaration
     */
    public static String convertUPCEtoUPCA(String upce) {
        void var2_2;
        String string;
        char[] upceChars = new char[6];
        upce.getChars(1, 7, upceChars, 0);
        StringBuilder result = new StringBuilder(12);
        result.append(upce.charAt(0));
        char lastChar = upceChars[5];
        switch (lastChar) {
            case '0': 
            case '1': 
            case '2': {
                result.append(upceChars, 0, 2);
                result.append(lastChar);
                result.append("0000");
                result.append(upceChars, 2, 3);
                break;
            }
            case '3': {
                result.append(upceChars, 0, 3);
                result.append("00000");
                result.append(upceChars, 3, 2);
                break;
            }
            case '4': {
                result.append(upceChars, 0, 4);
                result.append("00000");
                result.append(upceChars[4]);
                break;
            }
            default: {
                void var3_3;
                void var1_1;
                result.append((char[])var1_1, 0, 5);
                result.append("0000");
                result.append((char)var3_3);
            }
        }
        result.append(string.charAt(7));
        return var2_2.toString();
    }
}

