/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    /*
     * WARNING - void declaration
     */
    final Result decodeRow(int rowNumber, BitArray row, int[] extensionStartRange) throws NotFoundException {
        void var1_2;
        void var2_4;
        void var3_5;
        StringBuilder result = this.decodeRowStringBuffer;
        result.setLength(0);
        int end = this.decodeMiddle(row, extensionStartRange, result);
        String resultString = result.toString();
        Map<ResultMetadataType, Object> extensionData = UPCEANExtension5Support.parseExtensionString(resultString);
        Result extensionResult = new Result(resultString, null, new ResultPoint[]{new ResultPoint((float)(extensionStartRange[0] + var3_5[1]) / 2.0f, rowNumber), new ResultPoint((float)var2_4, rowNumber)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (extensionData != null) {
            extensionResult.putAllMetadata(extensionData);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        void var2_3;
        void var3_4;
        int[] counters = this.decodeMiddleCounters;
        this.decodeMiddleCounters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int lgPatternFound = 0;
        for (int x = 0; x < 5 && rowOffset < end; ++x) {
            int bestMatch = UPCEANReader.decodeDigit(row, counters, rowOffset, UPCEANReader.L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            int[] nArray = counters;
            int n = counters.length;
            for (int i = 0; i < n; ++i) {
                int counter = nArray[i];
                rowOffset += counter;
            }
            if (bestMatch >= 10) {
                lgPatternFound |= 1 << 4 - x;
            }
            if (x == 4) continue;
            rowOffset = row.getNextSet(rowOffset);
            rowOffset = row.getNextUnset(rowOffset);
        }
        if (resultString.length() != 5) {
            throw NotFoundException.getNotFoundInstance();
        }
        int checkDigit = UPCEANExtension5Support.determineCheckDigit(lgPatternFound);
        if (UPCEANExtension5Support.extensionChecksum(var3_4.toString()) != checkDigit) {
            throw NotFoundException.getNotFoundInstance();
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static int extensionChecksum(CharSequence s) {
        void var2_2;
        int i;
        int length = s.length();
        int sum = 0;
        for (i = length - 2; i >= 0; i -= 2) {
            sum += s.charAt(i) - 48;
        }
        sum *= 3;
        for (i = var1_1 - true; i >= 0; i -= 2) {
            sum += s.charAt(i) - 48;
        }
        return (int)(var2_2 * 3 % 10);
    }

    private static int determineCheckDigit(int lgPatternFound) throws NotFoundException {
        for (int d = 0; d < 10; ++d) {
            if (lgPatternFound != CHECK_DIGIT_ENCODINGS[d]) continue;
            return d;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    /*
     * WARNING - void declaration
     */
    private static Map<ResultMetadataType, Object> parseExtensionString(String raw) {
        void var1_1;
        String string;
        if (raw.length() != 5) {
            return null;
        }
        String value = UPCEANExtension5Support.parseExtension5String(raw);
        if (value == null) {
            return null;
        }
        EnumMap<ResultMetadataType, String> result = new EnumMap<ResultMetadataType, String>(ResultMetadataType.class);
        result.put(ResultMetadataType.SUGGESTED_PRICE, string);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String parseExtension5String(String raw) {
        void var0_2;
        void var2_4;
        void var1_3;
        switch (raw.charAt(0)) {
            case '0': {
                String currency = "\u00a3";
                break;
            }
            case '5': {
                String currency = "$";
                break;
            }
            case '9': {
                if ("90000".equals(raw)) {
                    return null;
                }
                if ("99991".equals(raw)) {
                    return "0.00";
                }
                if ("99990".equals(raw)) {
                    return "Used";
                }
                String currency = "";
                break;
            }
            default: {
                String currency = "";
            }
        }
        int rawAmount = Integer.parseInt(raw.substring(1));
        String unitsString = String.valueOf(rawAmount / 100);
        int hundredths = rawAmount % 100;
        String hundredthsString = hundredths < 10 ? "0".concat(String.valueOf(hundredths)) : String.valueOf(hundredths);
        return (String)var1_3 + (String)var2_4 + '.' + (String)var0_2;
    }
}

