/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension2Support {
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension2Support() {
    }

    /*
     * WARNING - void declaration
     */
    final Result decodeRow(int rowNumber, BitArray row, int[] extensionStartRange) throws NotFoundException {
        void var1_2;
        void var2_4;
        void var3_5;
        StringBuilder result = this.decodeRowStringBuffer;
        result.setLength(0);
        int end = this.decodeMiddle(row, extensionStartRange, result);
        String resultString = result.toString();
        Map<ResultMetadataType, Object> extensionData = UPCEANExtension2Support.parseExtensionString(resultString);
        Result extensionResult = new Result(resultString, null, new ResultPoint[]{new ResultPoint((float)(extensionStartRange[0] + var3_5[1]) / 2.0f, rowNumber), new ResultPoint((float)var2_4, rowNumber)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (extensionData != null) {
            extensionResult.putAllMetadata(extensionData);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    private int decodeMiddle(BitArray row, int[] startRange, StringBuilder resultString) throws NotFoundException {
        void var2_3;
        void var3_4;
        int[] counters = this.decodeMiddleCounters;
        this.decodeMiddleCounters[0] = 0;
        counters[1] = 0;
        counters[2] = 0;
        counters[3] = 0;
        int end = row.getSize();
        int rowOffset = startRange[1];
        int checkParity = 0;
        for (int x = 0; x < 2 && rowOffset < end; ++x) {
            int bestMatch = UPCEANReader.decodeDigit(row, counters, rowOffset, UPCEANReader.L_AND_G_PATTERNS);
            resultString.append((char)(48 + bestMatch % 10));
            int[] nArray = counters;
            int n = counters.length;
            for (int i = 0; i < n; ++i) {
                int counter = nArray[i];
                rowOffset += counter;
            }
            if (bestMatch >= 10) {
                checkParity |= 1 << 1 - x;
            }
            if (x == 1) continue;
            rowOffset = row.getNextSet(rowOffset);
            rowOffset = row.getNextUnset(rowOffset);
        }
        if (resultString.length() != 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (Integer.parseInt(var3_4.toString()) % 4 != checkParity) {
            throw NotFoundException.getNotFoundInstance();
        }
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<ResultMetadataType, Object> parseExtensionString(String raw) {
        void var1_1;
        String string;
        if (raw.length() != 2) {
            return null;
        }
        EnumMap<ResultMetadataType, Integer> result = new EnumMap<ResultMetadataType, Integer>(ResultMetadataType.class);
        result.put(ResultMetadataType.ISSUE_NUMBER, Integer.valueOf(string));
        return var1_1;
    }
}

