/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class UPCAWriter
implements Writer {
    private final EAN13Writer subWriter = new EAN13Writer();

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        void var3_3;
        void var1_1;
        if (format != BarcodeFormat.UPC_A) {
            void var2_2;
            throw new IllegalArgumentException("Can only encode UPC-A, but got ".concat(String.valueOf(var2_2)));
        }
        return ((OneDimensionalCodeWriter)this.subWriter).encode(UPCAWriter.preencode((String)var1_1), BarcodeFormat.EAN_13, (int)var3_3, height, hints);
    }

    /*
     * WARNING - void declaration
     */
    private static String preencode(String contents) {
        String string;
        void var1_1;
        int length = contents.length();
        if (length == 11) {
            int sum = 0;
            for (int i = 0; i < 11; ++i) {
                sum += (contents.charAt(i) - 48) * (i % 2 == 0 ? 3 : 1);
            }
            contents = contents + (1000 - var1_1) % 10;
        } else if (var1_1 != 12) {
            throw new IllegalArgumentException("Requested contents should be 11 or 12 digits long, but got " + contents.length());
        }
        return "0".concat(String.valueOf(string));
    }
}

