/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.OneDReader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class MultiFormatUPCEANReader
extends OneDReader {
    private final UPCEANReader[] readers;

    /*
     * WARNING - void declaration
     */
    public MultiFormatUPCEANReader(Map<DecodeHintType, ?> hints) {
        void var2_2;
        Collection possibleFormats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
        ArrayList<UPCEANReader> readers = new ArrayList<UPCEANReader>();
        if (possibleFormats != null) {
            void var1_1;
            if (possibleFormats.contains((Object)BarcodeFormat.EAN_13)) {
                readers.add(new EAN13Reader());
            } else if (possibleFormats.contains((Object)BarcodeFormat.UPC_A)) {
                readers.add(new UPCAReader());
            }
            if (possibleFormats.contains((Object)BarcodeFormat.EAN_8)) {
                readers.add(new EAN8Reader());
            }
            if (var1_1.contains((Object)BarcodeFormat.UPC_E)) {
                readers.add(new UPCEReader());
            }
        }
        if (readers.isEmpty()) {
            readers.add(new EAN13Reader());
            readers.add(new EAN8Reader());
            readers.add(new UPCEReader());
        }
        void v0 = var2_2;
        this.readers = v0.toArray(new UPCEANReader[v0.size()]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Result decodeRow(int rowNumber, BitArray row, Map<DecodeHintType, ?> hints) throws NotFoundException {
        int[] startGuardPattern = UPCEANReader.findStartGuardPattern(row);
        UPCEANReader[] uPCEANReaderArray = this.readers;
        int n = this.readers.length;
        for (int i = 0; i < n; ++i) {
            void var2_4;
            boolean canReturnUPCA;
            Result result;
            UPCEANReader reader = uPCEANReaderArray[i];
            try {
                result = reader.decodeRow(rowNumber, row, startGuardPattern, hints);
            }
            catch (ReaderException readerException) {
                continue;
            }
            boolean ean13MayBeUPCA = result.getBarcodeFormat() == BarcodeFormat.EAN_13 && result.getText().charAt(0) == '0';
            Collection possibleFormats = hints == null ? null : (Collection)hints.get((Object)DecodeHintType.POSSIBLE_FORMATS);
            boolean bl = canReturnUPCA = possibleFormats == null || possibleFormats.contains((Object)BarcodeFormat.UPC_A);
            if (ean13MayBeUPCA && var2_4 != false) {
                void var1_2;
                Result resultUPCA = new Result(result.getText().substring(1), result.getRawBytes(), result.getResultPoints(), BarcodeFormat.UPC_A);
                resultUPCA.putAllMetadata(result.getResultMetadata());
                return var1_2;
            }
            return result;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public final void reset() {
        UPCEANReader[] uPCEANReaderArray = this.readers;
        int n = this.readers.length;
        for (int i = 0; i < n; ++i) {
            uPCEANReaderArray[i].reset();
        }
    }
}

