/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEANWriter;
import java.util.Map;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 67;

    /*
     * WARNING - void declaration
     */
    @Override
    public final BitMatrix encode(String contents, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) throws WriterException {
        void var3_3;
        void var2_2;
        void var1_1;
        if (format != BarcodeFormat.EAN_8) {
            throw new IllegalArgumentException("Can only encode EAN_8, but got ".concat(String.valueOf((Object)format)));
        }
        return super.encode((String)var1_1, (BarcodeFormat)var2_2, (int)var3_3, height, hints);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean[] encode(String contents) {
        void var2_2;
        void var3_3;
        int digit;
        if (contents.length() != 8) {
            throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + contents.length());
        }
        boolean[] result = new boolean[67];
        int pos = 0 + EAN8Writer.appendPattern(result, 0, UPCEANReader.START_END_PATTERN, true);
        int i = 0;
        while (i <= 3) {
            int n = i++;
            digit = Integer.parseInt(contents.substring(n, n + 1));
            pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.L_PATTERNS[digit], false);
        }
        pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.MIDDLE_PATTERN, false);
        i = 4;
        while (i <= 7) {
            int n = i++;
            digit = Integer.parseInt(contents.substring(n, n + 1));
            pos += EAN8Writer.appendPattern(result, pos, UPCEANReader.L_PATTERNS[digit], true);
        }
        EAN8Writer.appendPattern(result, (int)var3_3, UPCEANReader.START_END_PATTERN, true);
        return var2_2;
    }
}

